/***************************************************************/
//
//
//		DirectX	[ rendereropengl.h ]
//
//											Author	kazuki tanaka
//											Date	2017 5/16
/*---------------------------------------------------------------
Update : 2017/5/16
			Create Header File -> rendereropengl.h.h 
 			< Add Class Function >
				CRENDEREROPENGL->Constructor
				CRENDEREROPENGL->Destructor
				CRENDEREROPENGL->Create ( static member )
				CRENDEREROPENGL->Init
				CRENDEREROPENGL->Uninit
				CRENDEREROPENGL->Update
				CRENDEREROPENGL->Draw

Update : 2017/5/16



/*-------------------------------------------------------------*/
#ifndef _RENDEREROPENGL_H_

#define _RENDEREROPENGL_H_

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "renderer.h"

#include <Windows.h>
#include <GL/gl.h>
#include <GL/glu.h>

#pragma comment( lib, "opengl32.lib" )
#pragma comment( lib, "glu32.lib" )

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class RendererDX9 Using RendererDX9
class RendererOpenGL : public Renderer
{
public:
	
	RendererOpenGL( );						// RendererDX9 constructor
	~RendererOpenGL( );						// RendererDX9 destructor

	static Renderer* Create( void );		// RendererDX9 Create Instance Class

	void Init( HWND hWnd, bool bWindow );	// RendererDX9 Initialize
	void Uninit( void );					// RendererDX9 Uninitialize
	bool RenderBegin( void );				// RendererDX9 Draw Start
	void RenderEnd( void );					// RendererDX9 Draw End
	void Present( void );					// RendererDX9 Present Backbuffer
	
	HGLRC GetDevice( void );				// RendererDX9 GetDeviceInfo

	virtual void RenderState(				// RendererDX9 SetRenderState
		int* stateArray,
		bool* flaglist,
		int dataNumber );
	
private:

	// Member Function
	HWND   hWnd;
	HGLRC  hGLRC;
	HDC    hDC;

};


#endif	//	_RENDEREROPENGL_H_


