/***************************************************************/
//
//
//		DirectX	[ renderinterfacemanager.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/12
/*---------------------------------------------------------------
Update : 2017/6/12
			Create Header File -> renderinterfacemanager.h.h 
 			< Add Class Function >
				RenderInterfaceManager->Constructor
				RenderInterfaceManager->Destructor
				RenderInterfaceManager->Create ( static member )
				RenderInterfaceManager->Init
				RenderInterfaceManager->Uninit
				RenderInterfaceManager->Update
				RenderInterfaceManager->Draw

Update : 2017/6/12



/*-------------------------------------------------------------*/
#ifndef _RENDERINTERFACEMANAGER_H_

#define _RENDERINTERFACEMANAGER_H_


/*---------------------------------------------------------------
	Include File + other
---------------------------------------------------------------*/

#include <vector>

class RenderInterface;

#define PRIORITY_NUMBER (8)

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class RenderInterfaceManager Using RenderInterfaceManager
class RenderInterfaceManager
{
public:
	
	RenderInterfaceManager( );						// RenderInterfaceManager Constructor
	~RenderInterfaceManager( );						// RenderInterfaceManager Destructor

	static RenderInterfaceManager* Create( void );	// RenderInterfaceManager Create Instance Class

	static void Registry( 							// RenderInterfaceManager Registry
		RenderInterface* data,
		const int priority );

	static void Delete( 
		const RenderInterface* object );			// RenderInterfaceManager Delete

	static void Release( void );					// RenderInterfaceManager Release
	static void Render( void );						// RenderInterfaceManager Render
	
	void Destory( void );							// RenderInterfaceManager Destory
	

private:

	// Member Variable
	std::vector<RenderInterface*> data[PRIORITY_NUMBER];

	static RenderInterfaceManager* pManager;

};


#endif	//	_RENDERINTERFACEMANAGER_H_


