/***************************************************************/
//
//
//		DirectX	[ resource.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/7
/*---------------------------------------------------------------
Update : 2017/6/7
			Create Header File -> resource.h.h 
 			< Add Class Function >
				RESOURCE->Constructor
				RESOURCE->Destructor
				RESOURCE->Create ( static member )
				RESOURCE->Init
				RESOURCE->Uninit
				RESOURCE->Update
				RESOURCE->Draw

Update : 2017/6/7



/*-------------------------------------------------------------*/
#ifndef _RESOURCE_H_

#define _RESOURCE_H_


/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#define _CRT_SECURE_NO_WARNINGS

#include <stdio.h>

#include <map>
#include <vector>

typedef unsigned __int64 _ID;

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class Resource Using Resource
template <class X> class Resource
{

public:

	// Member Variable
	std::map<unsigned __int64, X > data;
	std::vector< unsigned __int64 > id;


public:
	
	Resource( ){}						// Resource Constructor
	~Resource( ){}						// Resource Destructor

	void Registry(						// Resuorce Registry
		const std::string& filename,
		X resource ){
	
		data[GetID(filename.data())] = resource;
		id.push_back( GetID(filename.data()) );
	}
		
	void Release( X search ){			// Resuorce Search
	
		for( int index = 0; index < id.size(); index++ ){
			if( data[id[index]] == search ){
				
				data[id[index]]->Release( );
				auto itr = data.find( id[index] );
				data.erase(itr);
				id.erase(id.begin()+index);
			}
		}
	}

	void Delete( void ){				// Resource Delete
	
		if( id.empty() ){
			return;
		}

		// All data -> Release
		for( int index = 0;; index++ ){

			data[id[index]]->Release( );
			auto itr = data.find( id[index] );
			data.erase(itr);
			if( id[index] == id.back())
				break;
		}
		
		// delete < ID >
		id.erase( id.begin(), id.end() );
	}

	X Export(							// Resource GetResourceData
		const std::string& filename ){
	
		return data[GetID(filename.data())];
	}	

private:

	static unsigned __int64 GetID(
		const char* FILE_NAME )			// Resource GetID
	{
	
		//unsigned __int64 data = 0;
		unsigned __int64 data = 0;

		// Divide File Name
		char filename [256] = {};
		char extension[256] = {};
		char loadFile [256] = {};

		// Split Path
		_splitpath( FILE_NAME, NULL, NULL, filename, extension );
	
		// Synthesis String < Load File Name >
		sprintf( loadFile, "%s%s", filename , extension );

		for( int index = 0; index < strlen(loadFile); index++ ){
			data *= 10;
			data += (int)loadFile[index]; 
		}

		return data;
	}

};



#endif	//	_RESOURCE_H_







