/***************************************************************/
//
//
//		DirectX	[ spriteinterfacemanager.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 6/15
/*---------------------------------------------------------------
Update : 2017/6/15
			spriteinterfacemanager.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "sprite_interfacemanager.h"

#include "sprite_interface.h"

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/


/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/

SpriteInterfaceManager* SpriteInterfaceManager::pManager = nullptr;




// SpriteInterfaceManager Constructor
SpriteInterfaceManager::SpriteInterfaceManager( )
{

	// Member Clear Process
	Release();
	pManager = this;

}

// SpriteInterfaceManager Destructor
SpriteInterfaceManager::~SpriteInterfaceManager( )
{

	// Do Nothing!!
	
}

// SpriteInterfaceManager Create Instance 
SpriteInterfaceManager* SpriteInterfaceManager::Create( void )
{

	// Create Class Instance
	return new SpriteInterfaceManager;

}

// SpriteInterfaceManager Registry
void SpriteInterfaceManager::Registry( SpriteInterface* data, const int priority )
{

	// Registry Process
	pManager->data[priority].push_back(data);

}

// SpriteInterfaceManager Delete
void SpriteInterfaceManager::Delete( const SpriteInterface* object )
{

	for( int priority = 0; priority < SPRITE_PRIORITY_NUMBER; priority++ ){
		for( int index = pManager->data[priority].size(); index > 0; index-- ){
			if( pManager->data[priority][index-1] == object ){
				delete pManager->data[priority][index-1];
				pManager->data[priority].erase( pManager->data[priority].begin() + index-1 );
			}
		}
	}

}

// SpriteInterfaceManager Destory
void SpriteInterfaceManager::Destory( void )
{

	for( int priority = 0; priority < SPRITE_PRIORITY_NUMBER; priority++ ){
		for( int index = data[priority].size(); index > 0; index-- ){
			if( data[priority][index-1]){
				delete data[priority][index-1];
			}
			data[priority].pop_back();
		}
	}

}

// SpriteInterfaceManager Release
void SpriteInterfaceManager::Release( void )
{

	// Release Process
	if(pManager){
		pManager->Destory();
		delete pManager;
	}
}

// SpriteInterfaceManager Render
void SpriteInterfaceManager::Render( void )
{

	// Draw Process
	for( int priority = 0; priority < SPRITE_PRIORITY_NUMBER; priority++ ){
		for( int index = 0; index < pManager->data[priority].size(); index++ ){
			pManager->data[priority][index]->Render();
		}
	}

}







