/***************************************************************/
//
//
//		DirectX	[ userinterface.h ]
//
//											Author	kazuki tanaka
//											Date	2017 6/21
/*---------------------------------------------------------------
Update : 2017/6/21
			Create Header File -> userinterface.h.h 
 			< Add Class Function >
				CUSERINTERFACE->Constructor
				CUSERINTERFACE->Destructor
				CUSERINTERFACE->Create ( static member )
				CUSERINTERFACE->Init
				CUSERINTERFACE->Uninit
				CUSERINTERFACE->Update
				CUSERINTERFACE->Draw

Update : 2017/6/21



/*-------------------------------------------------------------*/
#ifndef _USERINTERFACE_H_

#define _USERINTERFACE_H_

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "meshplane.h"

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class UserInterface Using UserInterface
class UserInterface : public MeshPlane
{
public:
	
	UserInterface(						// UserInterface Constructor
		const std::string& filename,
		const float& vertical = 0.5f,
		const float& horizonal = 0.5f,
		const Color& color = Color(1,1,1,1),
		const Vector3& pos = Vector3(0,0,1.0f),
		const Vector3& rot = Vector3(0,0,0),
		const Vector3& scale = Vector3(1,1,1),
		const Matrix& mat = Matrix());	
	~UserInterface( );					// UserInterface Destructor

	static UserInterface* Create(		// UserInterface Create Instance Class
		const std::string& filename,
		const float& vertical = 0.5f,
		const float& horizonal = 0.5f,
		const Color& color = Color(1,1,1,1),
		const Vector3& pos = Vector3(0,0,1.0f),
		const Vector3& rot = Vector3(0,0,0),
		const Vector3& scale = Vector3(1,1,1),
		const Matrix& mat = Matrix());	

	void Init( void );					// UserInterface Initialize
	void Uninit( void );				// UserInterface Uninitialize
	void Update( void );				// UserInterface Update

	
	void SetBuffer( void );				// UserInterface SetBuffer
	
	void Resize(						// UserInterface Resize
		const float width,
		const float height );

	void SetColor(						// UserInterface SetColor
		const Color& color );

	void ChangeTexture(					// UserInterface Change Texture
		const std::string& filename );

	template<class X>X* Inheritance( void ){			// GameObject Inheritance Access
		return dynamic_cast<X*>(this);
	}
	
private:

	// Member Variable


};



#endif	//	_USERINTERFACE_H_


