/***************************************************************/
//
//
//		Aus System	[ vector3.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 4/24
/*---------------------------------------------------------------
Update : 2017/4/24
			vector3.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/


//#include <Windows.h>
//#include <stdio.h>
//#include <d3dx9.h>

//#include "main.h"
#include <Windows.h>
#include <math.h>
#include "vector3.h"

//#pragma comment (lib,"d3d9.lib")
//#pragma comment (lib,"d3dx9.lib")
//#pragma comment (lib,"dxguid.lib")


/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/

#define SAFE_RELEASE(p) { if (p) { (p)->Release(); (p)=NULL; } }


/*---------------------------------------------------------------
	Const Number Difinition
---------------------------------------------------------------*/

#define NUM_VERTEX  ( 4 )						
#define NUM_POLYGON ( 2 )						

/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/





// CVector3 Constructor
Vector3::Vector3( )
	: x(0.0f) 
	, y(0.0f)
	, z(0.0f)
{

	// Menber Clear Process
	

}

// CVector3 Destructor
Vector3::~Vector3( )
{

	// Do Nothing!!

}

// CVector3 Constructor
Vector3::Vector3( const float* ref )
	: x(*ref) 
	, y(*ref)
	, z(*ref)
{

	// Menber Clear Process
	

}

// CVector3 Constructor
Vector3::Vector3( const Vector3& other )
	: x(other.x) 
	, y(other.y)
	, z(other.z)
{

	// Menber Clear Process
	

}

// Vector3 Constructor
Vector3::Vector3( const D3DXVECTOR3& other )
	: x(other.x) 
	, y(other.y)
	, z(other.z)
{

	// Menber Clear Process

}

// Vector3 Constructor
Vector3::Vector3( const D3DXVECTOR3* other )
	: x(other->x) 
	, y(other->y)
	, z(other->z)
{

	// Menber Clear Process

}

// CVector3 Constructor
Vector3::Vector3( float x, float y, float z )
	: x(x) 
	, y(y)
	, z(z)
{

	// Menber Clear Process
	

}

// Vector3 Calc Length
float Vector3::Length( void ) const
{

	return sqrt( Dot(*this) );

}

// Vector3 Vec Distance
float Vector3::Distance( const Vector3& other ) const
{

	return (*this - other ).Length( );

}

// Vector3 Normalize
Vector3 Vector3::Normalize( void ) const
{

	return *this/Length( );

}

// Vector3 Operator Cross
Vector3 Vector3::Cross( const Vector3& other ) const
{

	return Vector3( y*other.z - z*other.y, z*other.x - x*other.z, x*other.y - y*other.x );

}

// Vector3 Operator Dot
float Vector3::Dot( const Vector3& other ) const
{

	return ( x * other.x + y * other.y + z * other.z );

}

// Vector3 Operator Angle
float Vector3::Angle( Vector3& other )
{

	float dot = this->Dot( other );
	float lengthA,lengthB;
	lengthA = Length( );
	lengthB = other.Length( );

	return acosf( dot / (lengthA * lengthB) );

}

