/***************************************************************/
//
//
//		DirectX	[ vertexbuffer.h ]
//
//											Author	kazuki tanaka
//											Date	2017 5/19
/*---------------------------------------------------------------
Update : 2017/5/19
			Create Header File -> vertexbuffer.h.h 
 			< Add Class Function >
				CVERTEXBUFFER->Constructor
				CVERTEXBUFFER->Destructor
				CVERTEXBUFFER->Create ( static member )
				CVERTEXBUFFER->Init
				CVERTEXBUFFER->Uninit
				CVERTEXBUFFER->Update
				CVERTEXBUFFER->Draw

Update : 2017/5/19



/*-------------------------------------------------------------*/
#ifndef _VERTEXBUFFER_H_

#define _VERTEXBUFFER_H_

/*---------------------------------------------------------------
	class
---------------------------------------------------------------*/

#include "vertex3d.h"
class Vertex3D;
class Vertex2D;
class GridVertex;

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class VertexBuffer Using VertexBuffer
class VertexBuffer
{
public:
	
	VertexBuffer( );							// VertexBuffer constructor
	virtual ~VertexBuffer( );					// VertexBuffer destructor
	
	virtual bool CreateVertexBuffer(			// VertexBuffer CreateVertexBuffer
		const int FVF_FORMAT,
		unsigned int vertexNumber,
		int vertexData = sizeof(Vertex3D)) = 0;
	
	virtual void SetVertex( void ) = 0;			// VertexBuffer SetVertex
	virtual void SetVertex3D( void ) = 0;		// VertexBuffer SetVertex
	virtual void SetVertex2D( void ) = 0;		// VertexBuffer SetVertex

	virtual void Release( void ) = 0;			// VertexBuffer Uninitialize
	
	virtual void Lock(							// VertexBufferDX9 Lock
		GridVertex** pVtx ) = 0;	

	virtual void Lock( 							// VertexBuffer Lock
		Vertex2D** pVtx ) = 0;

	virtual void Lock( 							// VertexBuffer Lock
		Vertex3D** pVtx ) = 0;
	
	virtual void Unlock( void ) = 0;			// VertexBuffer Unlock

	virtual int GetVertexNumber( void ){		// VertexBuffer VtxCount
		return vertexNumber;
	}


protected:

	// Member Variable
	int vertexNumber;

};


#endif	//	_VERTEXBUFFER_H_


