/***************************************************************/
//
//
//		DirectX	[ vertexbufferdx9.cpp ]
//
//											Author	kazuki tanaka
//											Date	2017 5/18
/*---------------------------------------------------------------
Update : 2017/5/18
			vertexbufferdx9.cpp̍쐬

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "vertexbufferdx9.h"

#include "grid.h"
#include "vertex2d.h"
#include "vertex3d.h"

/*---------------------------------------------------------------
	Macro Difinition
---------------------------------------------------------------*/


/*---------------------------------------------------------------
	Const Number Difinition
---------------------------------------------------------------*/


/*----------------------------------------------------------------
	static member variable Initialize 
----------------------------------------------------------------*/




// VertexBufferDX9 Constructor
VertexBufferDX9::VertexBufferDX9( )
	: pVtxBuf(nullptr)
	, FVF_FORMAT( 0 )
	, fvfSize( 0 )
{

	// Menber Clear Process

}

// VertexBufferDX9 Destructor
VertexBufferDX9::~VertexBufferDX9( )
{

	// Do Nothing!!

}

// VertexBufferDX9 Create Instance 
VertexBufferDX9* VertexBufferDX9::Create( void )
{

	// Create Class Instance
	return  new VertexBufferDX9;

}

// VertexBufferDX9 Initialize for 3DVertex
bool VertexBufferDX9::CreateVertexBuffer( const int FVF_FORMAT, unsigned int vertexNumber, int vertexData )
{

	LPDIRECT3DDEVICE9 pDevice = GetDevice( );

	// Create Vertex Process
	if( FAILED( pDevice ->CreateVertexBuffer(
			vertexData * vertexNumber,					// mۂobt@TCY(_m) P:oCg
			// sizeof( Vertex2D ) * vertexNumber,
			D3DUSAGE_WRITEONLY,							// gp@
			FVF_FORMAT,									// gp钸_tH[}bg
			D3DPOOL_MANAGED,							// obt@̊Ǘ@
			&pVtxBuf,									// i[|C^
			NULL )))
	{
		#ifdef _DEBUG
		MessageBox( NULL, "obt@ւ݂̏Ɏs܂!!" , " DRAWLOGO VTXBUF ERROR !!" , MB_OK );
		#endif	// _DEBUG

		return false;
	}

	// Registry FVF format
	VertexBufferDX9::FVF_FORMAT = FVF_FORMAT;
	VertexBufferDX9::vertexNumber = vertexNumber;
	VertexBufferDX9::fvfSize = vertexData;

	return true;

}

// VertexBufferDX9 Uninitialize
void VertexBufferDX9::Release( void )
{

	// Uninitialize Process
	//SAFE_RELEASE( pVtxBuf )
	VertexBufferDX9* vtx = this;
	if (pVtxBuf) {
		(pVtxBuf)->Release();
		(pVtxBuf)=NULL; 
	}
	delete vtx;
	vtx = nullptr;

}

// VertexBufferDX9 SetFVF
void VertexBufferDX9::SetVertex( void )
{

	LPDIRECT3DDEVICE9 pDevice = GetDevice( );

	// Set Stream : Pipeline 
	pDevice ->SetStreamSource( 0,
	pVtxBuf,							
	0,												
	fvfSize);							

	// Set FVF format
	pDevice ->SetFVF( FVF_FORMAT );

}

// VertexBufferDX9 SetFVF
void VertexBufferDX9::SetVertex3D( void )
{

	LPDIRECT3DDEVICE9 pDevice = GetDevice( );

	// Set Stream : Pipeline 
	pDevice ->SetStreamSource( 0,
	pVtxBuf,							
	0,												
	sizeof( Vertex3D ));							

	// Set FVF format
	pDevice ->SetFVF( FVF_FORMAT );

}

// VertexBufferDX9 SetFVF
void VertexBufferDX9::SetVertex2D( void )
{

	LPDIRECT3DDEVICE9 pDevice = GetDevice( );

	// Set Stream : Pipeline 
	pDevice ->SetStreamSource( 0,
	pVtxBuf,							
	0,												
	sizeof( Vertex2D ));							

	// Set FVF format
	pDevice ->SetFVF( FVF_FORMAT );

}

// VertexBufferDX9 Update
void VertexBufferDX9::Lock( GridVertex** pVtx )
{

	// Get < virtual Pointer >
	(pVtxBuf) -> Lock( 0, 0, (void**)pVtx, 0 );

}

// VertexBufferDX9 Update
void VertexBufferDX9::Lock( Vertex2D** pVtx )
{

	// Get < virtual Pointer >
	(pVtxBuf) -> Lock( 0, 0, (void**)pVtx, 0 );

}

// VertexBufferDX9 Update
void VertexBufferDX9::Lock( Vertex3D** pVtx )
{

	// Get < virtual Pointer >
	(pVtxBuf) -> Lock( 0, 0, (void**)pVtx, 0 );


}

// VertexBufferDX9 Draw
void VertexBufferDX9::Unlock( void )
{

	// Unlock Buffer
	(pVtxBuf) ->Unlock( );

}





