/***************************************************************/
//
//
//		DirectX	[ vertexbufferdx9.h ]
//
//											Author	kazuki tanaka
//											Date	2017 5/18
/*---------------------------------------------------------------
Update : 2017/5/18
			Create Header File -> vertexbufferdx9.h.h 
 			< Add Class Function >
				CVERTEXBUFFERDX9->Constructor
				CVERTEXBUFFERDX9->Destructor
				CVERTEXBUFFERDX9->Create ( static member )
				CVERTEXBUFFERDX9->Init
				CVERTEXBUFFERDX9->Uninit
				CVERTEXBUFFERDX9->Update
				CVERTEXBUFFERDX9->Draw

Update : 2017/5/18



/*-------------------------------------------------------------*/
#ifndef _VERTEXBUFFERDX9_H_

#define _VERTEXBUFFERDX9_H_

/*---------------------------------------------------------------
	Include File
---------------------------------------------------------------*/

#include "vertexbuffer.h"

#include "rendererdx9.h"

/*---------------------------------------------------------------
	Class
---------------------------------------------------------------*/


// Class CVertexBufferDX9 Using VertexBufferDX9
class VertexBufferDX9 : public VertexBuffer
{
public:
	
	VertexBufferDX9( );							// VertexBufferDX9 constructor
	~VertexBufferDX9( );						// VertexBufferDX9 destructor

	static VertexBufferDX9* Create( void );		// VertexBufferDX9 Create Instance Class
	
	bool CreateVertexBuffer(					// VertexBufferDX9 CreateVertexBuffer
		const int FVF_FORMAT,
		unsigned int vertexNumber,
		int vertexData = sizeof(Vertex3D) );

	void SetVertex3D( void );					// VertexBufferDX9 SetVertex
	void SetVertex2D( void );					// VertexBufferDX9 SetVertex

	void SetVertex( void );						// VertexBufferDX9 SetVertex
	
	void Release( void );						// VertexBufferDX9 Uninitialize
	
	void Lock( 
		GridVertex** pVtxx );					// VertexBufferDX9 Lock

	void Lock( 									// VertexBufferDX9 Lock
		Vertex2D** pVtx );
	
	void Lock( 									// VertexBufferDX9 Lock
		Vertex3D** pVtx );

	void Unlock( void );						// VertexBufferDX9 Unlock


private:

	// Member Variable
	LPDIRECT3DVERTEXBUFFER9 pVtxBuf;			// VertexBufferDX9InterfacePointer
	unsigned short FVF_FORMAT;
	unsigned short fvfSize;
	//int FVF_FORMAT;
	//int fvfSize;


};


#endif	//	_VERTEXBUFFERDX9_H_


