/***************************************************************/
//
//
//		DirectX	[ xboxcontroller.h ]
//
//											Author	kazuki tanaka
//											Date	2017 2/22
/*---------------------------------------------------------------
Update : 2017/2/22
			Create Header File -> xboxcontroller.h.h 
 			< Add Class Function >
				CXboxController->Constructor
				CXboxController->Destructor
				CXboxController->Create ( static member )
				CXboxController->Access ( static member )
				CXboxController->Init
				CXboxController->Uninit
				CXboxController->Update
				CXboxController->ReleaseAll ( static member )
				CXboxController->UpdateAll  ( static member )
				CXboxController->DrawAll    ( static member )

Update : 2017/2/22



/*-------------------------------------------------------------*/
#ifndef _XBOXCONTROLLER_H_

#define _XBOXCONTROLLER_H_

#include <XInput.h>
#include "input.h"

#pragma comment ( lib, "Xinput.lib") 

#define XBOXCONTROLLER_MAX (6)
#define STRING_MAX (32)

/*---------------------------------------------------------------
	class
---------------------------------------------------------------*/


// class CXboxController Using XboxController
class CXboxController : public CInput
{
public:

	// Virtual Bottom XInput( for XboxController )
	typedef enum{
	
		XINPUT_UP	          = 0x0001,
		XINPUT_DOWN	          = 0x0002,
		XINPUT_LEFT	          = 0x0004,
		XINPUT_RIGHT          = 0x0008,
		XINPUT_START          = 0x0010,
		XINPUT_BACK           = 0x0020,
		XINPUT_THUMB          = 0x0040,
		XINPUT_RIGHT_THUMB    = 0x0080,
		XINPUT_LEFT_SHOULDER  = 0x0100,
		XINPUT_RIGHT_SHOULDER = 0x0200,
		XINPUT_A              = 0x1000,
		XINPUT_B              = 0x2000,
		XINPUT_X              = 0x4000,
		XINPUT_Y              = 0x8000,
	}STATE;

	CXboxController( );							// CXboxController constructor
	~CXboxController( );						// CXboxController destructor

	static CXboxController* Create( 			// CXboxController Create Instance Class
		const char* XBOXCONTROLLER_NAME );
	static void ReleaseAll( void );				// CXboxController Class Release All 
	static CXboxController* Access(				// CXboxController Class Access Outside Function 
		const char* XBOXCONTROLLER_NAME );

	virtual void Init( void );					// CXboxController Initialize
	virtual void Uninit( void );				// CXboxController Uninitialize
	virtual void Update( void );				// CXboxController Update

	static void UpdateAll( void );				// CXboxController Update Class All

	static inline CXboxController* Access(		// CXboxController Class Access Outside Function 
		const int index )
	{
		return pXboxController[ index ];
	}
			
	bool GetKeyPress( int nKey );				// CXboxController GetKeyPressState

	bool GetKeyTrigger( int key );				// CXboxController GetKeyTriggerState

	int  deviceIndex;

private:

	// XboxController Member 
	char xboxcontrollerName[ STRING_MAX ];
	//int  deviceIndex;

	// static Member
	static CXboxController* pXboxController[ XBOXCONTROLLER_MAX ];

	// KeyState
    XINPUT_STATE press;
	XINPUT_STATE trigger;
	XINPUT_STATE release;
	
    bool bConnected;

};


#endif	//	_XBOXCONTROLLER_H_




