/* R\[֌W */

#include "bootpack.h"
#include <stdio.h>
#include <string.h>
int atoi(const char *nptr);

void console_task(struct SHEET *sheet, int memtotal)
{
	struct TASK *task = task_now();
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	int i, j = 0, k = 0;
	int fifobuf[128];
	int *fat = (int *) memman_alloc_4k(memman, 4 * 2880);
	char *cmdline = (char *) memman_alloc_4k(memman, 30 * 21); /* MȂ */
	struct CONSOLE cons;
	cons.sht    = sheet;
	cons.curx   =     8;
	cons.cury   =    28;
	cons.curcol =    -1;
	*((int *) 0x0fec) = (int) &cons;

	fifo32_init(&task->fifo, 128, fifobuf, task);
	cons.timer = timer_alloc();
	timer_init(cons.timer, &task->fifo, 1);
	timer_settime(cons.timer, 50);
	file_readfat(fat, (unsigned char *) (ADR_DISKIMG + 0x000200));

	/* View prompt. */
	cons_putchar(&cons, '>', 1);

	for (;;) {
		io_cli();
		if (fifo32_status(&task->fifo) == 0) {
			task_sleep(task);
			io_sti();
		} else {
			i = fifo32_get(&task->fifo);
			io_sti();
			if (i <= 1) {
				/* J[\p */
				if (i) {
					timer_init(cons.timer, &task->fifo, 0);
					if (cons.curcol >= 0)
						cons.curcol = COL8_000000;
				} else {
					timer_init(cons.timer, &task->fifo, 1);
					if (cons.curcol >= 0)
						cons.curcol = COL8_FFFFFF;
				}
				timer_settime(cons.timer, 50);
			}
			if (i == 2) {
				/* J[\ON */
				cons.curcol = COL8_FFFFFF;
			}
			if (i == 3) {
				/* J[\OFF */
				boxfill8(sheet->buf, sheet->bxsize, COL8_000000, cons.curx, cons.cury, cons.curx + 7, cons.cury + 15);
				cons.curcol = -1;
			}
			if (256 <= i && i < 512) {
				/* L[{[h */
				i -= 256;	// ɈƂ
				if (i == 0x01) {
					/* GXP[vL[ */
					/* ͒̃R\[̕S */
					cons_putchar(&cons, ' ', 0);
					while (cons.curx > 16) {
						cons.curx -= 8;
						cons_putchar(&cons, ' ', 0);
					}
				} else if (i == 8) {
					/* obNXy[X */
					if (cons.curx > 16) {
						cons_putchar(&cons, ' ', 0);
						cons.curx -= 8;
						cons_putchar(&cons, ' ', 0);
					}
				} else if (i == 10) {
					/* EnterL[ */
					cons_putchar(&cons, ' ', 0);
					cmdline[cons.curx / 8 - 2] = 0;
					k = 0;
					for (i = 0; i < 30; i++) {
						/* ÕR}hƔr */
						if (cmdline[i] == cmdline[30 + i])
							k++;
					}
					if (i != k && cons.curx / 8 - 2 > 0) {
						/* ÕR}hƂ͈āA͂Ă */
						/* R}h炵iӂ邢Hj */
						for (j = 20; 0 < j; j--) {
							for (i = 0; i < 30; i++) {
								cmdline[30 * j + i] = cmdline[30 * (j - 1) + i];
								if (cmdline[30 * j + i] == 0) {
									break;
								}
							}
						}
					}
					j = 0;
					cons_newline(&cons);
					cons_runcmd(cmdline, &cons, fat, memtotal);
					/* vvg\ */
					cons_putchar(&cons, '>', 1);
				} else if (i == 0xe0) {
					/* E0g */
					i = fifo32_get(&task->fifo) - 256;	// ɂ1oCg
					if (i == 56) {
						/* Up key */
						if (j < 20) {
							if (cmdline[(j + 1) * 30] != 0) {
								/* Oɗ */
								j++;
								cons_recent(&cons, cmdline, j);
							}
						}
					} else if (i == 50) {
						/* Down key */
						if (1 < j) {
							j--;
							cons_recent(&cons, cmdline, j);
						}
					}
				} else {
					/* ʕ */
				 	if (cons.curx < 240) {
						cmdline[cons.curx / 8 - 2] = i;
						cons_putchar(&cons, i, 1);
					}
				}
			}
			/* J[\ĕ\ */
			if (cons.cury >= 0)
				boxfill8(sheet->buf, sheet->bxsize, cons.curcol, cons.curx, cons.cury + 15, cons.curx + 7, cons.cury + 15);
			sheet_refresh(sheet, cons.curx, cons.cury + 15, cons.curx + 8, cons.cury + 16);
		}
	}
}

void cons_putchar(struct CONSOLE *cons, int chr, char move)
{
	char s[2];
	s[0] = chr;
	s[1] = 0;

	if (s[0] == 0x09) {
		/* Tab */
		for (;;) {
			putfonts8_asc_sht(cons->sht, cons->curx, cons->cury, COL8_FFFFFF, COL8_000000, " ", 1);
			cons->curx += 8;
			if (cons->curx == 8 + 240)
				cons_newline(cons);
			if (((cons->curx - 8) & 0x1f) == 0)
				break;	/* 32Ŋ؂ꂽbreak; */
		}
	} else if (s[0] == 0x0a) {
		/* s */
		cons_newline(cons);
	} else if (s[0] == 0x0d) {
		/* A */
		// Ƃ肠ȂɂȂ
	} else {
		/* ӂ[̕ */
		putfonts8_asc_sht(cons->sht, cons->curx, cons->cury, COL8_FFFFFF, COL8_000000, s, 1);
		if (move) {
			cons->curx += 8;
			if (cons->curx == 8 + 240)
				cons_newline(cons);
		}
	}
	return;
}

void cons_putstr0(struct CONSOLE *cons, char *s)
{
	for (; *s != 0; s++)
		cons_putchar(cons, *s, 1);
	return;
}

void cons_putstr1(struct CONSOLE *cons, char *s, int l)
{
	int i;
	for (i = 0; i < l; i++)
		cons_putchar(cons, s[i], 1);
	return;
}

void cons_newline(struct CONSOLE *cons)
{
	int x, y;
	struct SHEET *sheet = cons->sht;
	if (cons->cury < 28 + 112) {
		cons->cury += 16;
	} else {
		/* XN[ */
		for (y = 28; y < 28 + 112; y++) {
			for (x = 8; x < 8 + 240; x++) {
				sheet->buf[x + y * sheet->bxsize] = sheet->buf[x + (y + 16) * sheet->bxsize];
			}
		}
		for (y = 28 + 112; y < 28 + 128; y++) {
			for (x = 8; x < 8 + 240; x++) {
				sheet->buf[x + y * sheet->bxsize] = COL8_000000;
			}
		}
		sheet_refresh(sheet, 8, 28, 8 + 240, 28 + 128);
	}
	cons->curx = 8;
	return;
}

void cons_recent(struct CONSOLE *cons, char *cmdline, int n)
{
	int i;
	/* ͒̃R\[̕S */
	cons_putchar(cons, ' ', 0);
	while (cons->curx > 16) {
		cons->curx -= 8;
		cons_putchar(cons, ' ', 0);
	}
	/* ݂nÕR}h݂̃R}hCɃRs[ďo */
	for (i = 0; i < 30; i++) {
		cmdline[i] = cmdline[n * 30 + i];
		if (cmdline[i] == 0) {
			break;
		}
		cons_putchar(cons, cmdline[i], 1);
	}
	return;
}

void cons_runcmd(char *cmdline, struct CONSOLE *cons, int *fat, int memtotal)
{
	/* R}hs */
	if (strcmp(cmdline, "mem") == 0) {
		/* memR}h */
		cmd_mem(cons, memtotal);
	} else if (strcmp(cmdline, "reboot") == 0) {
		/* rebootR}h */
		cmd_reboot(cons);
	} else if (strcmp(cmdline, "cls") == 0) {
		/* clsR}h */
		cmd_cls(cons);
	} else if (strcmp(cmdline, "dir") == 0) {
		/* dirR}h */
		cmd_dir(cons);
	} else if (strncmp(cmdline, "type ", 5) == 0) {
		/* typeR}h */
		cmd_type(cons, fat, cmdline);
	} else if (strcmp(cmdline, "ver") == 0) {
		/* verR}h */
		cmd_ver(cons);
	} else if (strncmp(cmdline, "history", 7) == 0) {
		/* historyR}h */
		cmd_history(cons, cmdline);
	} else if (cmdline[0] != 0) {
		if (cmd_app(cons, fat, cmdline) == 0) {
			/* R}hłȂAsłȂ */
			cons_putstr0(cons, "Command or file not found.\n\n");
		}
	}
	return;
}

void cmd_mem(struct CONSOLE *cons, int memtotal)
{
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	char s[60];
	sprintf(s, "Total: %dKB\nFree : %dKB\n\n", memtotal / 1000, memman_total(memman) / 1024);
	cons_putstr0(cons, s);
	return;
}

void cmd_reboot(struct CONSOLE *cons)
{
	io_cli();
	wait_KBC_sendready();
	io_out8(PORT_KEYCMD, 0xfe); /* ċN */
	for (;;)
	    io_hlt();
}

void cmd_cls(struct CONSOLE *cons)
{
	int x, y;
	struct SHEET *sheet = cons->sht;
	for (y = 28; y < 28 + 128; y++) {
		for (x = 8; x < 8 + 240; x++) {
			sheet->buf[x + y * sheet->bxsize] = COL8_000000;
		}
	}
	sheet_refresh(sheet, 8, 28, 8 + 240, 28 + 128);
	cons->cury = 28;
	return;
}

void cmd_dir(struct CONSOLE *cons)
{
	struct FILEINFO *finfo = (struct FILEINFO *) (ADR_DISKIMG + 0x002600);
	int i, j;
	char s[30];
	for (i = 0; i < 224; i++) {
		if (finfo[i].name[0] == 0x00)
			break;
		if (finfo[i].name[0] != 0xe5) {
			if ((finfo[i].type & 0x18) == 0) {
				sprintf(s, "filename.ext   %7d\n", finfo[i].size);
				for (j = 0; j < 8; j++)
					s[j] = finfo[i].name[j];
				s[ 9] = finfo[i].ext[0];
				s[10] = finfo[i].ext[1];
				s[11] = finfo[i].ext[2];
				cons_putstr0(cons, s);
			}
		}
	}
	cons_newline(cons);
	return;
}

void cmd_type(struct CONSOLE *cons, int *fat, char *cmdline)
{
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	struct FILEINFO *finfo = file_search(cmdline + 5, (struct FILEINFO *) (ADR_DISKIMG + 0x002600), 224);
	char *p;

	if (finfo) {
		/* t@C */
		p = (char *) memman_alloc_4k(memman, finfo->size);
		file_loadfile(finfo->clustno, finfo->size, p, fat, (char *) (ADR_DISKIMG + 0x003e00));
		cons_putstr1(cons, p, finfo->size);
		memman_free_4k(memman, (int) p, finfo->size);
	} else {
		/* t@CȂ */
		cons_putstr0(cons, "File not found.\n");
	}
	cons_newline(cons);
	return;
}

void cmd_ver(struct CONSOLE *cons)
{
	cons_putstr0(cons, "OSAkkie Ver.0.0.23.02\n");
	cons_putstr0(cons, "Copyright(C) 2006 Akkiesoft.\n\n");
	return;
}

void cmd_history(struct CONSOLE *cons, char *cmdline)
{
/*  */
	char s[50], s2[30];
	int i, j, num = 0;

	/* w肳Ă */
	if (*(cmdline + 7) != 0) {
		num = atoi(cmdline + 8);
		if (0 < num && num < 21) {
			for (i = 0; i < 30; i++) {
				s2[i] = cmdline[30 * num + i];
			}
			sprintf(s, "[%d] %s\n\n", num, s2);
			cons_putstr0(cons, s);
		} else {
			/* ۑ𒴂Ă邩1w肳ĂAg\ */
			cons_putstr0(cons, "using> history [1-20]\n\n");
		}
		return;
	}

	/* w肳ĂȂ̂ŁAׂĕ\ */
	for (j = 20; 0 < j; j--) {
		for (i = 0; i < 30; i++) {
			s2[i] = cmdline[30 * j + i];
			if (s2[i] == 0) {
				break;	/* 0܂œ */
			}
		}
		if (s2[0] == 0) {
			/* ȂiJb|j */
			continue;
		}
		sprintf(s, "[%d] %s\n", j, s2);
		cons_putstr0(cons, s);
	}
	cons_putstr0(cons, "\n");
	return;
}

int cmd_app(struct CONSOLE *cons, int *fat, char *cmdline)
{
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	struct FILEINFO *finfo;
	struct SEGMENT_DESCRIPTOR *gdt = (struct SEGMENT_DESCRIPTOR *) ADR_GDT;
	struct SHTCTL *shtctl;
	struct SHEET *sht;
	char name[18], *p, *q;
	struct TASK *task = task_now();
	int i;
	int segsize, datsize, esp, dathrb;

	/* R}hCt@C𐶐 */
	for (i = 0; i < 13; i++) {
		if (cmdline[i] <= ' ')
			break;
		name[i] = cmdline[i];
	}
	name[i] = 0;

	finfo = file_search(name, (struct FILEINFO *) (ADR_DISKIMG + 0x002600), 224);
	if (finfo == 0 && name[i - 1] != '.') {
		/* Ȃ̂ŁA.HRBăgC */
		name[i    ] = '.';
		name[i + 1] = 'H';
		name[i + 2] = 'R';
		name[i + 3] = 'B';
		name[i + 4] = 0;
		finfo = file_search(name, (struct FILEINFO *) (ADR_DISKIMG + 0x002600), 224);
	}

	if (finfo != 0) {
		/* t@C */
		p = (char *) memman_alloc_4k(memman, finfo->size);
		file_loadfile(finfo->clustno, finfo->size, p, fat, (char *) (ADR_DISKIMG + 0x003e00));
		if (finfo->size >= 36 && strncmp(p + 4, "Hari", 4) == 0 && *p == 0x00) {
			segsize = *((int *) (p + 0x0000));
			esp     = *((int *) (p + 0x000c));
			datsize = *((int *) (p + 0x0010));
			dathrb  = *((int *) (p + 0x0014));
			q = (char *) memman_alloc_4k(memman, segsize);
			*((int *) 0xfe8) = (int) q;
			set_segmdesc(gdt + 1003, finfo->size - 1, (int) p, AR_CODE32_ER + 0x60);
			set_segmdesc(gdt + 1004, segsize - 1,     (int) q, AR_DATA32_RW + 0x60);
			for (i = 0; i < datsize; i++)
				q[esp + i] = p[dathrb + i];
			start_app(0x1b, 1003 * 8, esp, 1004 * 8, &(task->tss.esp0));
			shtctl = (struct SHTCTL *) *((int *) 0x0fe4);
			for (i = 0; i < MAX_SHEETS; i++) {
				sht = &(shtctl->sheets0[i]);
				if (sht->flags && sht->task == task) {
					/* Av͏IĂ̂ɉ~cĂ */
					sheet_free(sht);		/*  */
				}
			}
			memman_free_4k(memman, (int) q, segsize);
		} else {
			cons_putstr0(cons, ".hrb file format error.\n");
		}
		memman_free_4k(memman, (int) p, finfo->size);
		cons_newline(cons);
		return 1;
	}
	return 0;
}

int *hrb_api(int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax)
{
	int ds_base = *((int *) 0xfe8);
	struct TASK *task = task_now();
	struct CONSOLE *cons = (struct CONSOLE *) *((int *) 0x0fec);
	struct SHTCTL *shtctl = (struct SHTCTL *) *((int *) 0x0fe4);
	struct SHEET *sht;
	int *reg = &eax + 1; /* Ԃl */
	int i;

	if (edx == 1) {
		cons_putchar(cons, eax & 0xff, 1);
	} else if (edx == 2) {
		cons_putstr0(cons, (char *) ebx + ds_base);
	} else if (edx == 3) {
		cons_putstr1(cons, (char *) ebx + ds_base, ecx);
	} else if (edx == 4) {
		return &(task->tss.esp0);
	} else if (edx == 5) {
		sht = sheet_alloc(shtctl);
		sht->task = task;
		sheet_setbuf(sht, (char *) ebx + ds_base, esi, edi, eax);
		make_window8((char *) ebx + ds_base, esi, edi, (char *) ecx + ds_base, 0, 0);
		sheet_slide(sht, 100, 50);
		sheet_updown(sht, 3); /* task_ȁ */
		reg[7] = (int) sht;
	} else if (edx == 6) {
		sht = (struct SHEET *) (ebx & 0xfffffffe);
		putfonts8_asc(sht->buf, sht->bxsize, esi, edi, eax, (char *) ebp + ds_base);
		if ((ebx & 1) == 0) {
			sheet_refresh(sht, esi, edi, esi + ecx * 8, edi + 16);
		}
	} else if (edx == 7) {
		sht = (struct SHEET *) (ebx & 0xfffffffe);
		boxfill8(sht->buf, sht->bxsize, ebp, eax, ecx, esi, edi);
		if ((ebx & 1) == 0) {
			sheet_refresh(sht, eax, ecx, esi + 1, edi + 1);
		}
	} else if (edx == 8) {
		memman_init((struct MEMMAN *) (ebx + ds_base));
		ecx &= 0xfffffff0;	/* 16oCgPʂɂ */
		memman_free((struct MEMMAN *) (ebx + ds_base), eax, ecx);
	} else if (edx == 9) {
		ecx = (ecx + 0x0f) & 0xfffffff0;	/* 16oCgPʂɐ؂グ */
		reg[7] = memman_alloc((struct MEMMAN *) (ebx + ds_base), ecx);
	} else if (edx == 10) {
		ecx = (ecx + 0x0f) & 0xfffffff0;	/* 16oCgPʂɐ؂グ */
		memman_free((struct MEMMAN *) (ebx + ds_base), eax, ecx);
	} else if (edx == 11) {
		sht = (struct SHEET *) (ebx & 0xfffffffe);
		sht->buf[sht->bxsize * edi + esi] = eax;
		if ((ebx & 1) == 0) {
			sheet_refresh(sht, esi, edi, esi + 1, edi + 1);
		}
	} else if (edx == 12) {
		sht = (struct SHEET *) ebx;
		sheet_refresh(sht, eax, ecx, esi, edi);
	} else if (edx == 13) {
		sht = (struct SHEET *) (ebx & 0xfffffffe);
		hrb_api_linewin(sht, eax, ecx, esi, edi, ebp);
		if ((ebx & 1) == 0) {
			sheet_refresh(sht, eax, ecx, esi + 1, edi + 1);
		}
	} else if (edx == 14) {
		sheet_free((struct SHEET *) ebx);
	} else if (edx == 15) {
		for (;;) {
			io_cli();
			if (fifo32_status(&task->fifo) == 0) {
				if (eax != 0) {
					/* fifoJb| */
					task_sleep(task);	/* Qđ҂ */
				} else {
					io_sti();
					reg[7] = -1;
					return 0;
				}
			}
			i = fifo32_get(&task->fifo);
			io_sti();
			if (i <= 1) {
				/* J[\p */
				/* Avs̓J[\oȂ̂ŁA͕\p1𒍕 */
					timer_init(cons->timer, &task->fifo, 1);
					timer_settime(cons->timer, 50);
			}
			if (i == 2) {
				/* J[\ON */
				cons->curcol = COL8_FFFFFF;
			}
			if (i == 3) {
				/* J[\OFF */
				cons->curcol = -1;
			}
			if (256 <= i && i < 512) {
				reg[7] = i - 256;
				return 0;
			}
		}
	}// else if (edx == 16) {
	//}
	return 0;
}

int *inthandler0c(int *esp)
{
	struct CONSOLE *cons = (struct CONSOLE *) *((int *) 0x0fec);
	struct TASK *task = task_now();
	char s[30];
	cons_putstr0(cons, "\nINT 0C :\n Stack Exception.\n");
	sprintf(s, "EIP = %08X", esp[11]);
	cons_putstr0(cons, s);
	return &(task->tss.esp0);
}

int *inthandler0d(int *esp)
{
	struct CONSOLE *cons = (struct CONSOLE *) *((int *) 0x0fec);
	struct TASK *task = task_now();
	char s[30];
	cons_putstr0(cons, "\nINT 0D :\n General Protected Exception.\n");
	sprintf(s, "EIP = %08X", esp[11]);
	cons_putstr0(cons, s);
	return &(task->tss.esp0);
}

void hrb_api_linewin(struct SHEET *sht, int x0, int y0, int x1, int y1, int col)
{
	int i, x, y, len, dx, dy;

	dx = x1 - x0;
	dy = y1 - y0;
	x = x0 << 10;
	y = y0 << 10;
	if (dx < 0){
		dx = - dx;
	}
	if (dy < 0){
		dy = - dy;
	}
	if (dx >= dy) {
		len = dx + 1;
		if (x0 > x1) {
			dx = - 1024;
		} else {
			dx = 1024;
		}
		if (y0 <= y1) {
			dy = ((y1 - y0 + 1) << 10) / len;
		} else {
			dy = ((y1 - y0 - 1) << 10) / len;
		}
	} else {
		len = dy + 1;
		if (y0 > y1) {
			dy = - 1024;
		} else {
			dy = 1024;
		}
		if (x0 <= x1) {
			dx = ((x1 - x0 + 1) << 10) / len;
		} else {
			dx = ((x1 - x0 - 1) << 10) / len;
		}
	}

	for (i = 0; i < len; i++) {
		sht->buf[(y >> 10) * sht->bxsize + (x >> 10)] = col;
		x += dx;
		y += dy;
	}

	return;
}
