/* Window֌W */

#include "bootpack.h"

void make_window8(unsigned char *buf, int xsize, int ysize, char *title, int icon, char act)
{
	boxfill8(buf, xsize, COL8_C6C6C6, 0      , 0      , xsize-2, 0      );	// 㔖DF
	boxfill8(buf, xsize, COL8_C6C6C6, 0      , 0      , 0,       ysize-2);	// DF
	boxfill8(buf, xsize, COL8_FFFFFF, 1      , 1      , xsize-2, 1      );	// 㔒F
	boxfill8(buf, xsize, COL8_FFFFFF, 1      , 1      , 1,       ysize-2);	// F
	boxfill8(buf, xsize, COL8_C6C6C6, 2      , 2      , xsize-3, ysize-3);	// DFiEBhE{́j
	boxfill8(buf, xsize, COL8_848484, xsize-2, 1      , xsize-2, ysize-2);	// EZDF
	boxfill8(buf, xsize, COL8_848484, 1      , ysize-2, xsize-2, ysize-2);	// ZDF
	boxfill8(buf, xsize, COL8_000000, xsize-1, 0      , xsize-1, ysize-1);	// EF
	boxfill8(buf, xsize, COL8_000000, 0      , ysize-1, xsize-1, ysize-1);	// F
	make_wtitle8(buf, xsize, title, icon, act);
	return;
}

void make_wtitle8(unsigned char *buf, int xsize, char *title, int icon, char act)
{
	static unsigned char closebtn[14 * 15] = {
		0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
		0x07,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x07,0x07,0x11,0x11,0x11,0x07,0x07,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x11,0x07,0x07,0x11,0x07,0x07,0x11,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x11,0x11,0x07,0x07,0x07,0x11,0x11,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x11,0x11,0x07,0x07,0x07,0x11,0x11,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x11,0x07,0x07,0x11,0x07,0x07,0x11,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x07,0x07,0x11,0x11,0x11,0x07,0x07,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x07,
		0x07,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x11,0x07,
		0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07
	};
	char tc, tbc;
	unsigned char logo[3];

	if (act) {
		tc  = COL8_FFFFFF;
		tbc = COL8_0080FF;
	} else {
		tc  = COL8_C6C6C6;
		tbc = COL8_848484;
	}
	boxfill8(buf, xsize, tbc, 3, 3, xsize-4, 20);	// ^Cgo[
	logo[0] = 0x80 + icon * 2;
	logo[1] = 0x81 + icon * 2;
	logo[2] = 0;
	putfonts8_asc(buf, xsize,  8, 4, tc, logo);
	putfonts8_asc(buf, xsize, 24, 4, tc, title);
	picdata8(buf, xsize, closebtn, 15, 14, COL8_0080FF, xsize - 20, 5);

	return;
}

void make_textbox8(struct SHEET *sht, int x0, int y0, int sx, int sy, int c)
{
	int x1 = x0 + sx, y1 = y0 + sy;

	boxfill8(sht->buf, sht->bxsize, COL8_848484, x0 - 2, y0 - 3, x1 + 1, y0 - 3);
	boxfill8(sht->buf, sht->bxsize, COL8_848484, x0 - 3, y0 - 3, x0 - 3, y1 + 1);
	boxfill8(sht->buf, sht->bxsize, COL8_FFFFFF, x0 - 3, y1 + 2, x1 + 1, y1 + 2);
	boxfill8(sht->buf, sht->bxsize, COL8_FFFFFF, x1 + 2, y0 - 3, x1 + 2, y1 + 2);
	boxfill8(sht->buf, sht->bxsize, COL8_000000, x0 - 1, y0 - 2, x1 + 0, y0 - 2);
	boxfill8(sht->buf, sht->bxsize, COL8_000000, x0 - 2, y0 - 2, x0 - 2, y1 + 0);
	boxfill8(sht->buf, sht->bxsize, COL8_C6C6C6, x0 - 2, y1 + 1, x1 + 0, y1 + 1);
	boxfill8(sht->buf, sht->bxsize, COL8_C6C6C6, x1 + 1, y0 - 2, x1 + 1, y1 + 1);
	boxfill8(sht->buf, sht->bxsize, c,           x0 - 1, y0 - 1, x1 + 0, y1 + 0);

	return;
}

void putfonts8_asc_sht(struct SHEET *sht, int x, int y, int c, int b, char *s, int l)
{
	boxfill8(sht->buf, sht->bxsize, b, x, y, x + l * 8 - 1, y + 15);
	putfonts8_asc(sht->buf, sht->bxsize, x, y, c, s);
	sheet_refresh(sht, x, y, x + l * 8, y + 16);
}
