/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.classes;

import java.util.HashMap;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.runtime.JiBXException;

public class ClassItem {
    protected static HashMap s_signatureMap = new HashMap();
    protected ClassFile m_classFile;
    protected String m_name;
    protected String m_signature;
    protected String m_typeName;
    protected String[] m_argTypes;
    protected FieldOrMethod m_item;

    public ClassItem(String name, ClassFile cf, FieldOrMethod item) {
        this.m_classFile = cf;
        this.m_name = name;
        this.m_item = item;
        this.m_signature = item.getSignature();
        if (item instanceof Method) {
            this.m_typeName = Utility.methodSignatureReturnType(this.m_signature, false);
            this.m_argTypes = Utility.methodSignatureArgumentTypes(this.m_signature, false);
        } else {
            this.m_typeName = Utility.signatureToString(this.m_signature, false);
        }
    }

    public ClassFile getClassFile() {
        return this.m_classFile;
    }

    public String getName() {
        return this.m_name;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public int getArgumentCount() {
        if (this.m_item instanceof Method) {
            return this.m_argTypes.length;
        }
        return 0;
    }

    public String getArgumentType(int index) {
        if (this.m_item instanceof Method) {
            return this.m_argTypes[index];
        }
        return null;
    }

    public int getAccessFlags() {
        return this.m_item.getAccessFlags();
    }

    public void setAccessFlags(int flags) {
        this.m_item.setAccessFlags(flags);
        this.m_classFile.setModified();
    }

    public String getSignature() {
        return this.m_signature;
    }

    public boolean isMethod() {
        return this.m_item == null || this.m_item instanceof Method;
    }

    public String[] getExceptions() {
        ExceptionTable etab;
        if (this.m_item instanceof Method && (etab = ((Method)this.m_item).getExceptionTable()) != null) {
            return etab.getExceptionNames();
        }
        return null;
    }

    public static boolean isPrimitive(String type) {
        return s_signatureMap.get(type) != null;
    }

    public static ClassItem findVirtualMethod(String name, String[] sigs) throws JiBXException {
        int split = name.lastIndexOf(46);
        String cname = name.substring(0, split);
        String mname = name.substring(split + 1);
        ClassFile cf = ClassCache.getClassFile(cname);
        int i = 0;
        while (i < sigs.length) {
            ClassItem method = cf.getMethod(mname, sigs[i]);
            if (method != null) {
                return method;
            }
            ++i;
        }
        return null;
    }

    public static ClassItem findStaticMethod(String name, String[] sigs) throws JiBXException {
        int split = name.lastIndexOf(46);
        String cname = name.substring(0, split);
        String mname = name.substring(split + 1);
        ClassFile cf = ClassCache.getClassFile(cname);
        int i = 0;
        while (i < sigs.length) {
            ClassItem method = cf.getStaticMethod(mname, sigs[i]);
            if (method != null) {
                return method;
            }
            ++i;
        }
        return null;
    }

    public static String[] getSignatureVariants(String name) throws JiBXException {
        Object obj = s_signatureMap.get(name);
        if (obj == null) {
            ClassFile cf = ClassCache.getClassFile(name);
            return cf.getInstanceSigs();
        }
        return (String[])obj;
    }

    public static boolean isAssignable(String from, String to) throws JiBXException {
        if (from.equals(to)) {
            return true;
        }
        Object fobj = s_signatureMap.get(from);
        Object tobj = s_signatureMap.get(to);
        if (fobj == null && tobj == null) {
            ClassFile cf = ClassCache.getClassFile(from);
            String[] sigs = cf.getInstanceSigs();
            String match = Utility.getSignature(to);
            int i = 0;
            while (i < sigs.length) {
                if (match.equals(sigs[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (fobj != null && tobj != null) {
            String[] fsigs = (String[])fobj;
            String[] tsigs = (String[])tobj;
            if (tsigs.length == 1) {
                int i = 0;
                while (i < fsigs.length) {
                    if (fsigs[i] == tsigs[0]) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
        return false;
    }

    static {
        s_signatureMap.put("boolean", new String[]{"Z"});
        s_signatureMap.put("byte", new String[]{"B", "S", "I"});
        s_signatureMap.put("char", new String[]{"C", "I"});
        s_signatureMap.put("double", new String[]{"D"});
        s_signatureMap.put("float", new String[]{"F"});
        s_signatureMap.put("int", new String[]{"I"});
        s_signatureMap.put("long", new String[]{"J"});
        s_signatureMap.put("short", new String[]{"S", "I"});
        s_signatureMap.put("void", new String[]{"V"});
    }
}

