/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.QueueIF;

class Queue_2
implements QueueIF {
    private List mContainer = new ArrayList();
    private Comparator mComp;
    private int mInitialSize;
    private int mLaeveCount;

    public Queue_2(Comparator inComp) {
        this.mComp = inComp;
    }

    public void enqueue(Object inRec) {
        this.mContainer.add(inRec);
    }

    public Object dequeue() {
        if (0 >= --this.mLaeveCount) {
            this.sort();
            --this.mLaeveCount;
        }
        Object aRet = this.mContainer.remove(0);
        return aRet;
    }

    public void addAll(Object[] inContainer) {
        this.mContainer.addAll(Arrays.asList(inContainer));
    }

    public void flip() {
        this.mInitialSize = this.size();
    }

    public void clear() {
        this.mContainer.clear();
    }

    public void sort() {
        if (this.mInitialSize / this.size() < 4) {
            this.makeHeap();
            this.heapSort();
            this.mLaeveCount = this.size();
            System.out.println("queue sorted. (" + this.mLaeveCount + " leaves.)");
        }
    }

    public boolean isEmpty() {
        return this.mContainer.isEmpty();
    }

    public int size() {
        return this.mContainer.size();
    }

    private void pushHeap(int inBegin, int inEnd, Comparator inComp) {
        int aIndex = inEnd - inBegin - 1;
        int aPredecessor = (aIndex - 1) / 2;
        Object aTemp = this.mContainer.get(aIndex);
        while (aPredecessor != aIndex && 0 < inComp.compare(this.mContainer.get(aPredecessor), aTemp)) {
            this.mContainer.set(aIndex, this.mContainer.get(aPredecessor));
            aIndex = aPredecessor;
            aPredecessor = (aIndex - 1) / 2;
        }
        this.mContainer.set(aIndex, aTemp);
    }

    private void popHeap(int inBegin, int inEnd, Comparator inComp) {
        int aIndex = 0;
        int aSuccessor = 1;
        int aLastPos = inEnd - inBegin - 1;
        Object aTemp = this.mContainer.get(aLastPos);
        this.mContainer.set(aLastPos, this.mContainer.get(0));
        while (aSuccessor < aLastPos) {
            if (aSuccessor < aLastPos - 1 && 0 < inComp.compare(this.mContainer.get(aSuccessor), this.mContainer.get(aSuccessor + 1))) {
                ++aSuccessor;
            }
            if (0 >= inComp.compare(aTemp, this.mContainer.get(aSuccessor))) break;
            this.mContainer.set(aIndex, this.mContainer.get(aSuccessor));
            aIndex = aSuccessor;
            aSuccessor = (aIndex + 1) * 2 - 1;
        }
        this.mContainer.set(aIndex, aTemp);
    }

    private void makeHeap() {
        for (int i = 1; i < this.size(); ++i) {
            this.pushHeap(0, i, this.mComp);
        }
    }

    private void heapSort() {
        int aSize = this.size();
        while (aSize > 1) {
            this.popHeap(0, aSize--, this.mComp);
        }
    }

    public void printQueue() {
        System.out.println("-------------------------------------------");
        System.out.println("print queue entry.");
        for (int i = 0; i < this.size(); ++i) {
            System.out.println(this.mContainer.get(i));
        }
        System.out.println();
    }
}

