/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental;

import java.util.Comparator;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.QueueIF;

class Queue_3
implements QueueIF {
    private Object[] mEnqueueBuf;
    private Object[] mDequeueBuf;
    private int mEnQueueBufSize;
    private int mDeQueueBufSize;
    private int mCurPos;
    private Comparator mComp;
    private int mInitialSize;

    public Queue_3(Comparator inComp) {
        this.mComp = inComp;
    }

    public void enqueue(Object inRec) {
        this.mEnqueueBuf[this.mEnQueueBufSize++] = inRec;
    }

    public Object dequeue() {
        if (0 > --this.mDeQueueBufSize) {
            this.sort();
            --this.mDeQueueBufSize;
        }
        Object aRet = this.mDequeueBuf[this.mCurPos++];
        return aRet;
    }

    public void addAll(Object[] inContainer) {
    }

    public void flip() {
    }

    public void clear() {
    }

    public void sort() {
        if (this.mInitialSize < this.size()) {
            this.mInitialSize = this.size();
        }
        if (this.mInitialSize / this.size() < 4) {
            this.heapSort(this.mEnqueueBuf, 0, this.mEnQueueBufSize, this.mComp);
            System.out.println("queue sorted. (" + this.mEnQueueBufSize + " leaves.)");
            this.printQueue();
        }
        Object[] aTemp = this.mDequeueBuf;
        this.mDequeueBuf = this.mEnqueueBuf;
        this.mDeQueueBufSize = this.mEnQueueBufSize;
        this.mEnqueueBuf = aTemp;
        this.mEnQueueBufSize = 0;
        this.mCurPos = 0;
    }

    public boolean isEmpty() {
        return this.mDeQueueBufSize + this.mEnQueueBufSize == 0;
    }

    public int size() {
        return this.mDeQueueBufSize + this.mEnQueueBufSize;
    }

    public void printQueue() {
        System.out.println("-------------------------------------------");
        System.out.println("print queue entry.");
        for (int i = 0; i < this.size(); ++i) {
            System.out.println(this.mEnqueueBuf[i]);
        }
        System.out.println();
    }

    private void pushHeap(Object[] inArray, int inBegin, int inEnd, Comparator inComp) {
        int aIndex = inEnd - inBegin - 1;
        int aPredecessor = (aIndex - 1) / 2;
        Object aTemp = inArray[aIndex];
        while (aPredecessor != aIndex && 0 < inComp.compare(inArray[aPredecessor], aTemp)) {
            inArray[aIndex] = inArray[aPredecessor];
            aIndex = aPredecessor;
            aPredecessor = (aIndex - 1) / 2;
        }
        inArray[aIndex] = aTemp;
    }

    private void popHeap(Object[] inArray, int inBegin, int inEnd, Comparator inComp) {
        int aIndex = 0;
        int aSuccessor = 1;
        int aLastPos = inEnd - inBegin - 1;
        Object aTemp = inArray[aLastPos];
        inArray[aLastPos] = inArray[0];
        while (aSuccessor < aLastPos) {
            if (aSuccessor < aLastPos - 1 && 0 < inComp.compare(inArray[aSuccessor], inArray[aSuccessor + 1])) {
                ++aSuccessor;
            }
            if (0 >= inComp.compare(aTemp, inArray[aSuccessor])) break;
            inArray[aIndex] = inArray[aSuccessor];
            aIndex = aSuccessor;
            aSuccessor = (aIndex + 1) * 2 - 1;
        }
        inArray[aIndex] = aTemp;
    }

    private void makeHeap(Object[] inArray, int inBeginPos, int inEndPos, Comparator inComp) {
        for (int i = 1; i < inEndPos; ++i) {
            this.pushHeap(inArray, inBeginPos, i, inComp);
        }
    }

    private void heapSort(Object[] inArray, int inBeginPos, int inEndPos, Comparator inComp) {
        this.makeHeap(inArray, inBeginPos, inEndPos, inComp);
        int aSize = inEndPos;
        while (aSize > 1) {
            this.popHeap(inArray, inBeginPos, aSize--, inComp);
        }
    }
}

