/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jp.gr.java_conf.ktz.puzzle.framework.Model;
import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SoluteSeparatedException;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SolveDiscompleteException;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SolverHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.QueueIF;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.Queue_2;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.SolverFinishedState;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.SolverProcessingState;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.SolverStartState;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;

public class SolverRI_4
implements SolverHandler {
    private static final State sStartState = new SolverStartState();
    private static final State sProcessingState = new SolverProcessingState();
    private static final State sBuildDisableState = new DisableState();
    private static final State sFinishedState = new SolverFinishedState();
    private static final Direction[] DIRECTIONS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    private static final Direction[] DIAGONAL = new Direction[]{Direction.NORTH_WEST, Direction.NORTH_EAST, Direction.SOUTH_WEST, Direction.SOUTH_EAST};
    private static final int NUM_PER_DIRECTION = 2;
    private static final int LOOP_ONCE_LIMIT = 100;
    private static final int PENALTY_WEIGHT = DIRECTIONS.length * 2;
    private Map mRecords = new HashMap();
    private QueueIF mQueue = new Queue_2(new SolverRecordComparator());
    private Map mChainMap = new HashMap();
    private Model mModel;
    private int mLap;
    private int mLoopCount = 0;
    private boolean mIsNotResolve;
    private SolverPattern[] mPatterns = new SolverPattern[]{new HashikakeSolverPattern1(), new HashikakeSolverPattern2(), new HashikakeSolverPattern3(), new HashikakeSolverPattern4(), new HashikakeSolverPattern5()};

    public SolverRI_4(Model inModel) {
        this.mModel = inModel;
    }

    public void reset() {
        this.initRecords();
        this.mLap = 0;
        this.mLoopCount = 0;
        this.mIsNotResolve = false;
    }

    private void initRecords() {
        this.mRecords.clear();
        this.mChainMap.clear();
        this.mQueue.clear();
        ArrayList<SolverRecord> aList = new ArrayList<SolverRecord>();
        for (int y = 0; y < this.mModel.getHeight(); ++y) {
            for (int x = 0; x < this.mModel.getWidth(); ++x) {
                if (!this.mModel.isNumberAt(x, y)) continue;
                SolverRecord aRec = this.createSolverRecordAt(x, y);
                aList.add(aRec);
            }
        }
        this.mQueue.addAll(aList.toArray(new SolverRecord[aList.size()]));
        this.mQueue.flip();
    }

    public void addSolvePosAt(int inX, int inY) {
        if (this.mModel.isNumberAt(inX, inY)) {
            SolverRecord aRec = this.createSolverRecordAt(inX, inY);
            this.mQueue.enqueue(aRec);
            this.mQueue.flip();
        }
    }

    private SolverRecord createSolverRecordAt(int inX, int inY) {
        Point aPos = new Point(inX, inY);
        SolverRecord aRec = this.getSolverRecord(aPos);
        this.updateSolverRecord(aRec);
        return aRec;
    }

    public boolean isSolute() {
        return this.mQueue.isEmpty();
    }

    public void nextSolute() {
        if (this.isSolute()) {
            return;
        }
        this.nextSoluteSub();
    }

    private boolean nextSoluteSub() {
        if (this.mLap <= 0) {
            this.mLap = this.mQueue.size();
        }
        SolverRecord aRec = null;
        do {
            --this.mLap;
            if (this.mQueue.isEmpty()) {
                return true;
            }
            aRec = (SolverRecord)this.mQueue.dequeue();
        } while (this.isFinishedState(aRec.mState));
        return this.attemptBuild(aRec);
    }

    public boolean nextSoluteAll() throws SolveDiscompleteException {
        if (this.mQueue.isEmpty()) {
            return true;
        }
        int aCount = 0;
        int aLimit = 100;
        try {
            do {
                ++this.mLoopCount;
                --aLimit;
                if (!this.nextSoluteSub()) {
                    if (this.mQueue.size() != ++aCount) continue;
                    if (this.mIsNotResolve) {
                        throw new SolveDiscompleteException(this.mQueue.size());
                    }
                    this.mIsNotResolve = true;
                    aCount = 0;
                    continue;
                }
                aCount = 0;
            } while (this.mLap > 0 && aLimit > 0);
        }
        catch (SoluteSeparatedException e) {
            System.out.println(e);
            throw new SolveDiscompleteException(e.getMessage());
        }
        if (this.isSolute()) {
            System.out.print("loop count : " + this.mLoopCount);
            return true;
        }
        return false;
    }

    private boolean attemptBuild(SolverRecord inRec) {
        boolean aRet = false;
        do {
            this.updateSolverRecord(inRec);
            if (this.isFinishedState(inRec.mState)) {
                return true;
            }
            aRet = false;
            Point[] aAroundPos = new Point[DIRECTIONS.length];
            int aSum = this.getAroundMax(inRec, aAroundPos);
            SolverInfo aInfo = new SolverInfo(inRec, aSum, aAroundPos);
            for (int i = 0; i < this.mPatterns.length && !(aRet |= this.mPatterns[i].build(aInfo)); ++i) {
            }
        } while (aRet);
        if (!this.isFinishedState(inRec.mState)) {
            inRec.mPenalty += PENALTY_WEIGHT;
            this.mQueue.enqueue(inRec);
        }
        return aRet;
    }

    private SolverRecord getSolverRecord(Point inPos) {
        if (this.mRecords.containsKey(inPos)) {
            return (SolverRecord)this.mRecords.get(inPos);
        }
        if (this.mModel.isNumberAt(inPos.x, inPos.y)) {
            int aCount = Integer.MIN_VALUE;
            Point aPos = new Point(inPos);
            try {
                aCount = Integer.parseInt(StateManager.getInstance().findIdentityOf(this.mModel.getCurStateAt(aPos.x, aPos.y)));
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("The simbol of Number State cannot be parsed as integer.");
            }
            SolverRecord aRec = new SolverRecord(this.mRecords.size(), aPos, aCount);
            this.mRecords.put(aPos, aRec);
            return aRec;
        }
        throw new IllegalArgumentException("The state of specified position isnot NumberState (pos : x = " + inPos.x + ", y = " + inPos.y + ")");
    }

    private boolean isBuild(Point inStart, Direction inDir, Point outOpposite) {
        Point aPos = new Point(inStart);
        Point aDiff = inDir.getDifference();
        aPos.translate(aDiff.x, aDiff.y);
        if (!this.mModel.contains(aPos.x, aPos.y)) {
            return false;
        }
        while (this.mModel.contains(aPos.x, aPos.y)) {
            if (this.mModel.isNumberAt(aPos.x, aPos.y)) {
                outOpposite.setLocation(aPos.x, aPos.y);
                return true;
            }
            StateEventCode aCode = UtilityFuncs.getDetermineDirectionEventCode(inDir);
            if (!this.mModel.isTransitAt(aPos.x, aPos.y, aCode)) {
                return false;
            }
            aPos.translate(aDiff.x, aDiff.y);
        }
        return false;
    }

    private boolean isStartState(State inState) {
        return inState == sStartState;
    }

    private boolean isFinishedState(State inState) {
        return inState == sFinishedState;
    }

    private boolean isDisableState(State inState) {
        return inState == sBuildDisableState;
    }

    private boolean isProcessState(State inState) {
        return inState == sProcessingState;
    }

    private boolean buildBridge(SolverRecord inRec, int inCount, int inIndex) {
        int aCount;
        Point aPos = new Point(inRec.mPos);
        OppositeRecord aOppRec = inRec.mOpposite[inIndex];
        if (null == aOppRec) {
            return false;
        }
        if (this.isFinishedState(aOppRec.mState)) {
            return false;
        }
        if (inCount == aOppRec.mCount) {
            return false;
        }
        Direction aDirection = DIRECTIONS[inIndex];
        StateEventCode aCode = UtilityFuncs.getDetermineDirectionEventCode(aDirection);
        Point aDiff = aDirection.getDifference();
        do {
            for (aCount = aOppRec.mCount; aCount < inCount; ++aCount) {
                this.mModel.nextStateAt(aPos.x, aPos.y, aCode);
            }
            aPos.translate(aDiff.x, aDiff.y);
        } while (!this.mModel.isNumberAt(aPos.x, aPos.y));
        aDirection = UtilityFuncs.inverseDirection(aDirection);
        aCode = UtilityFuncs.getDetermineDirectionEventCode(aDirection);
        for (aCount = aOppRec.mCount; aCount < inCount; ++aCount) {
            this.mModel.nextStateAt(aPos.x, aPos.y, aCode);
        }
        aOppRec.mCount = inCount;
        SolverRecord aAgainstRec = this.getSolverRecord(aPos);
        this.addChainMap(inRec, aAgainstRec);
        this.updateSolverRecord(aAgainstRec);
        return true;
    }

    private void addChainMap(SolverRecord inRec, SolverRecord inAgainstRec) {
        Integer aRemoveRefID;
        if (inRec.mQueueRef == inAgainstRec.mQueueRef) {
            return;
        }
        List aList = this.getChainList(inRec);
        List aAgainstList = this.getChainList(inAgainstRec);
        if (inRec.mQueueRef < inAgainstRec.mQueueRef) {
            aRemoveRefID = new Integer(inAgainstRec.mQueueRef);
            this.mergeChainList(aList, aAgainstList, inRec.mQueueRef);
        } else {
            aRemoveRefID = new Integer(inRec.mQueueRef);
            this.mergeChainList(aAgainstList, aList, inAgainstRec.mQueueRef);
        }
        this.mChainMap.remove(aRemoveRefID);
    }

    private List getChainList(SolverRecord inRec) {
        Integer aKey = new Integer(inRec.mQueueRef);
        LinkedList<SolverRecord> aList = (LinkedList<SolverRecord>)this.mChainMap.get(aKey);
        if (null == aList) {
            aList = new LinkedList<SolverRecord>();
            aList.add(inRec);
            this.mChainMap.put(aKey, aList);
        }
        return aList;
    }

    private void mergeChainList(List inList1, List inList2, int inRefID) {
        while (!inList2.isEmpty()) {
            SolverRecord aRec = (SolverRecord)inList2.remove(0);
            aRec.mQueueRef = inRefID;
            inList1.add(aRec);
        }
        this.mChainMap.put(new Integer(inRefID), inList1);
    }

    private void removeChainMap(SolverRecord inRec) {
        Integer aRefID = new Integer(inRec.mQueueRef);
        List aList = (List)this.mChainMap.get(aRefID);
        if (null == aList) {
            return;
        }
        aList.remove(inRec);
        if (this.mChainMap.size() > 1 && aList.isEmpty()) {
            throw new SoluteSeparatedException();
        }
    }

    private void updateSolverRecord(SolverRecord inRec) {
        if (this.isFinishedState(inRec.mState)) {
            return;
        }
        inRec.mValied = false;
        inRec.mMostPriority = false;
        int aSum = 0;
        Point aOpposite = new Point();
        for (int i = 0; i < DIRECTIONS.length; ++i) {
            SolverRecord aAgainstRec;
            OppositeRecord aOppRec;
            block8: {
                block6: {
                    block9: {
                        block7: {
                            aOpposite.setLocation(Integer.MIN_VALUE, Integer.MIN_VALUE);
                            aOppRec = inRec.mOpposite[i];
                            if (!this.isBuild(inRec.mPos, DIRECTIONS[i], aOpposite)) break block6;
                            aAgainstRec = this.getSolverRecord(aOpposite);
                            if (null != aOppRec) break block7;
                            if (!this.isFinishedState(aAgainstRec.mState)) {
                                this.initOppositeRecord(inRec, aAgainstRec, i);
                            }
                            break block8;
                        }
                        if (!this.isDisableState(aOppRec.mState)) break block9;
                        if (this.isFinishedState(aAgainstRec.mState)) {
                            aOppRec = null;
                            inRec.mOpposite[i] = null;
                            --inRec.mOppositeCount;
                        } else {
                            this.initOppositeRecord(inRec, aAgainstRec, i);
                        }
                        break block8;
                    }
                    if (!this.isProcessState(aOppRec.mState) || !this.isFinishedState(aAgainstRec.mState)) break block8;
                    inRec.mResidue -= aOppRec.mCount;
                    --inRec.mOppositeCount;
                    aOppRec.mState = sFinishedState;
                    break block8;
                }
                if (null == aOppRec) continue;
                aOppRec = null;
                inRec.mOpposite[i] = null;
                --inRec.mOppositeCount;
                continue;
            }
            aAgainstRec = this.getSolverRecord(aOpposite);
            if (null == aOppRec || this.isDisableState(aOppRec.mState) || this.isFinishedState(aOppRec.mState)) continue;
            this.updateOppositeRecord(inRec, aAgainstRec, aOppRec);
            if (this.isFinishedState(aOppRec.mState)) continue;
            aSum += aOppRec.mCount;
        }
        if (aSum == inRec.mResidue || 0 == inRec.mOppositeCount || 0 == inRec.mResidue) {
            this.finalizeOppositeRecordAll(inRec);
        }
    }

    private void finalizeOppositeRecordAll(SolverRecord inRec) {
        inRec.mResidue = 0;
        inRec.mState = sFinishedState;
        for (int i = 0; i < DIRECTIONS.length; ++i) {
            this.finalizeOppositeRecord(inRec, i);
        }
        this.removeChainMap(inRec);
    }

    private void finalizeOppositeRecord(SolverRecord inRec, int inIndex) {
        if (null != inRec.mOpposite[inIndex]) {
            if (0 == inRec.mOpposite[inIndex].mCount) {
                inRec.mOpposite[inIndex].mState = sBuildDisableState;
                inRec.mOpposite[inIndex] = null;
            } else if (this.isFinishedState(inRec.mOpposite[inIndex].mState)) {
                return;
            }
            --inRec.mOppositeCount;
        }
    }

    private void updateOppositeRecord(SolverRecord inRec, SolverRecord inAgainst, OppositeRecord inOppRec) {
        if (this.isFinishedState(inOppRec.mState)) {
            return;
        }
        if (2 == inOppRec.mCount) {
            inOppRec.mState = sFinishedState;
            inRec.mResidue -= inOppRec.mCount;
            --inRec.mOppositeCount;
            if (0 < inRec.mPenalty) {
                inRec.mPenalty -= PENALTY_WEIGHT;
            }
            inAgainst.mResidue -= inOppRec.mCount;
            --inAgainst.mOppositeCount;
            if (0 < inRec.mPenalty) {
                inAgainst.mPenalty -= PENALTY_WEIGHT;
            }
        } else if (0 < inOppRec.mCount) {
            inOppRec.mState = sProcessingState;
        }
    }

    private void initOppositeRecord(SolverRecord inRec, SolverRecord inAgainst, int inIndex) {
        Direction aInverse = UtilityFuncs.inverseDirection(DIRECTIONS[inIndex]);
        int aIndex = this.getDirectionToIndex(aInverse);
        OppositeRecord aOppRec = inAgainst.mOpposite[aIndex];
        if (null == aOppRec) {
            inAgainst.mOpposite[aIndex] = aOppRec = new OppositeRecord();
            ++inAgainst.mOppositeCount;
        }
        inRec.mOpposite[inIndex] = aOppRec;
        ++inRec.mOppositeCount;
    }

    private int getDirectionToIndex(Direction inDirection) {
        for (int i = 0; i < DIRECTIONS.length; ++i) {
            if (DIRECTIONS[i] != inDirection) continue;
            return i;
        }
        throw new IllegalArgumentException("Direction, " + inDirection + "is illegal.");
    }

    private int getAroundMax(SolverRecord inRec, Point[] outAgainstPos) {
        int aSum = 0;
        for (int i = 0; i < DIRECTIONS.length; ++i) {
            Point aOpposite;
            if (null == inRec.mOpposite[i] || this.isFinishedState(inRec.mOpposite[i].mState) || !this.isBuild(inRec.mPos, DIRECTIONS[i], aOpposite = new Point())) continue;
            SolverRecord aAgainstRec = this.getSolverRecord(aOpposite);
            aSum += aAgainstRec.mResidue;
            outAgainstPos[i] = aOpposite;
        }
        return aSum;
    }

    static /* synthetic */ State access$000() {
        return sStartState;
    }

    private class SolverRecordComparator
    implements Comparator {
        private Point[] mTemp = new Point[SolverRI_4.access$100().length];

        private SolverRecordComparator() {
        }

        public int compare(Object inLHS, Object inRHS) {
            if (inLHS.equals(inRHS)) {
                return 0;
            }
            SolverRecord aLHS = (SolverRecord)inLHS;
            SolverRecord aRHS = (SolverRecord)inRHS;
            int aLScore = aLHS.mOppositeCount * 2 - aLHS.mResidue + aLHS.mPenalty;
            int aRScore = aRHS.mOppositeCount * 2 - aRHS.mResidue + aRHS.mPenalty;
            if (aLScore >= 2 && aRScore >= 2) {
                if (this.valiedPriority(aLHS)) {
                    return 1;
                }
                if (this.valiedPriority(aRHS)) {
                    return -1;
                }
            }
            if (aLScore == aRScore) {
                return aLHS.mResidue < aRHS.mResidue ? -1 : 1;
            }
            return aLScore > aRScore ? -1 : 1;
        }

        private boolean valiedPriority(SolverRecord inRec) {
            if (!inRec.mValied) {
                Point[] aAroundPos = this.mTemp;
                int aSum = SolverRI_4.this.getAroundMax(inRec, aAroundPos);
                inRec.mValied = true;
                for (int i = 0; i < aAroundPos.length; ++i) {
                    if (null == aAroundPos[i]) continue;
                    SolverRecord aAdjacent = SolverRI_4.this.getSolverRecord(aAroundPos[i]);
                    aAroundPos[i] = null;
                    if (aSum - aAdjacent.mResidue > inRec.mResidue) continue;
                    inRec.mMostPriority = true;
                    break;
                }
            }
            return inRec.mMostPriority;
        }
    }

    private class BuildChainMap {
        private Map mChainMap;

        private BuildChainMap() {
        }

        public List getChainList(SolverRecord inRec) {
            Integer aKey = new Integer(inRec.mQueueRef);
            LinkedList<SolverRecord> aList = (LinkedList<SolverRecord>)this.mChainMap.get(aKey);
            if (null == aList) {
                aList = new LinkedList<SolverRecord>();
                aList.add(inRec);
                this.mChainMap.put(aKey, aList);
            }
            return aList;
        }

        public void addSolverRecordPair(SolverRecord inRec, SolverRecord inAgainstRec) {
            Integer aRemoveRefID;
            if (inRec.mQueueRef == inAgainstRec.mQueueRef) {
                return;
            }
            List aList = this.getChainList(inRec);
            List aAgainstList = this.getChainList(inAgainstRec);
            if (inRec.mQueueRef < inAgainstRec.mQueueRef) {
                aRemoveRefID = new Integer(inAgainstRec.mQueueRef);
                this.mergeChainList(aList, aAgainstList, inRec.mQueueRef);
            } else {
                aRemoveRefID = new Integer(inRec.mQueueRef);
                this.mergeChainList(aAgainstList, aList, inAgainstRec.mQueueRef);
            }
            this.mChainMap.remove(aRemoveRefID);
        }

        private void mergeChainList(List inList1, List inList2, int inRefID) {
            while (!inList2.isEmpty()) {
                SolverRecord aRec = (SolverRecord)inList2.remove(0);
                aRec.mQueueRef = inRefID;
                inList1.add(aRec);
            }
            this.mChainMap.put(new Integer(inRefID), inList1);
        }

        public void removeSolverRecord(SolverRecord inRec) {
            Integer aRefID = new Integer(inRec.mQueueRef);
            List aList = (List)this.mChainMap.get(aRefID);
            if (null == aList) {
                return;
            }
            aList.remove(inRec);
            if (this.mChainMap.size() > 1 && aList.isEmpty()) {
                throw new IllegalStateException("The building bridge has separated.");
            }
        }
    }

    private class HashikakeSolverPattern5
    implements SolverPattern {
        private HashikakeSolverPattern5() {
        }

        public boolean build(SolverInfo inInfo) {
            boolean aRet = false;
            SolverRecord aRec = inInfo.mRec;
            int aOverCount = aRec.mOppositeCount * 2 - aRec.mResidue;
            if (aRec.mOppositeCount > 2 && aOverCount >= 2 && aOverCount < 4) {
                Point aDiagonalPos = new Point();
                for (int i = 0; i < DIAGONAL.length; ++i) {
                    if (!this.isBuildDiagonal(aRec, DIAGONAL[i], aDiagonalPos)) continue;
                    Direction aInverse = UtilityFuncs.inverseDirection(DIAGONAL[i]);
                    Direction[] aUnit = UtilityFuncs.getUnitDirection(aInverse);
                    SolverRecord aAdjacentRec = SolverRI_4.this.getSolverRecord(aDiagonalPos);
                    SolverRI_4.this.updateSolverRecord(aAdjacentRec);
                    if (this.isBuildForExceptsAround(aAdjacentRec, aUnit[0], aUnit[1])) continue;
                    for (int j = 0; j < DIRECTIONS.length; ++j) {
                        if (DIRECTIONS[j] != aUnit[0] && DIRECTIONS[j] != aUnit[1]) continue;
                        aRet |= SolverRI_4.this.buildBridge(aRec, 1, j);
                    }
                }
            }
            return aRet;
        }

        private boolean isBuildDiagonal(SolverRecord inRecord, Direction inDiagonal, Point outDiagonalPos) {
            Point aDiff = inDiagonal.getDifference();
            Point aPos = new Point(aDiff.x + inRecord.mPos.x, aDiff.y + inRecord.mPos.y);
            if (!SolverRI_4.this.mModel.isNumberAt(aPos.x, aPos.y)) {
                return false;
            }
            Direction[] aUnit = UtilityFuncs.getUnitDirection(inDiagonal);
            int aBuilt = 0;
            boolean aBuildable = true;
            for (int j = 0; j < DIRECTIONS.length; ++j) {
                if (DIRECTIONS[j] == aUnit[0] || DIRECTIONS[j] == aUnit[1]) {
                    if (null != inRecord.mOpposite[j]) continue;
                    aBuildable = false;
                    continue;
                }
                if (null == inRecord.mOpposite[j] || 0 >= inRecord.mOpposite[j].mCount) continue;
                ++aBuilt;
            }
            outDiagonalPos.setLocation(aPos);
            return aBuildable && aUnit.length != aBuilt;
        }

        private boolean isBuildForExceptsAround(SolverRecord inRecord, Direction inExcepts1, Direction inExcepts2) {
            if (inRecord.mOppositeCount == 0) {
                return true;
            }
            int aSum = 0;
            Point aAround = new Point();
            for (int i = 0; i < DIRECTIONS.length; ++i) {
                if (inExcepts1 == DIRECTIONS[i] || inExcepts2 == DIRECTIONS[i] || !SolverRI_4.this.isBuild(inRecord.mPos, DIRECTIONS[i], aAround)) continue;
                SolverRecord aAgainstRec = SolverRI_4.this.getSolverRecord(aAround);
                aSum += aAgainstRec.mResidue > 2 ? 2 : aAgainstRec.mResidue;
            }
            return aSum >= inRecord.mResidue;
        }
    }

    private class HashikakeSolverPattern4
    implements SolverPattern {
        private HashikakeSolverPattern4() {
        }

        public boolean build(SolverInfo inInfo) {
            boolean aRet = false;
            int aSum = this.getEffectiveAroundMax(inInfo);
            int aResidue = inInfo.mRec.mResidue;
            for (int i = 0; i < DIRECTIONS.length; ++i) {
                if (null == inInfo.mAroundPos[i]) continue;
                SolverRecord aAgainstRec = SolverRI_4.this.getSolverRecord(inInfo.mAroundPos[i]);
                int aCount = aAgainstRec.mMaxBuildCount;
                for (int j = 0; j < DIRECTIONS.length; ++j) {
                    if (null == aAgainstRec.mOpposite[j] || inInfo.mRec.mOpposite[i] == aAgainstRec.mOpposite[j]) continue;
                    aCount -= aAgainstRec.mOpposite[j].mCount;
                }
                if (aCount > 2) {
                    aCount = 2;
                }
                if (aSum - aCount >= aResidue || 0 != inInfo.mRec.mOpposite[i].mCount) continue;
                aRet |= SolverRI_4.this.buildBridge(inInfo.mRec, 1, i);
                --aSum;
                --aResidue;
            }
            return aRet;
        }

        private int getEffectiveAroundMax(SolverInfo inInfo) {
            int aSum = 0;
            for (int i = 0; i < DIRECTIONS.length; ++i) {
                if (null == inInfo.mAroundPos[i]) continue;
                SolverRecord aAgainstRec = SolverRI_4.this.getSolverRecord(inInfo.mAroundPos[i]);
                int aCount = aAgainstRec.mMaxBuildCount;
                for (int j = 0; j < DIRECTIONS.length; ++j) {
                    if (null == aAgainstRec.mOpposite[j] || inInfo.mRec.mOpposite[i] == aAgainstRec.mOpposite[j]) continue;
                    aCount -= aAgainstRec.mOpposite[j].mCount;
                }
                if (aCount > 2) {
                    aCount = 2;
                }
                aSum += aCount;
            }
            return aSum;
        }
    }

    private class HashikakeSolverPattern3
    implements SolverPattern {
        private HashikakeSolverPattern3() {
        }

        public boolean build(SolverInfo inInfo) {
            List aList = SolverRI_4.this.getChainList(inInfo.mRec);
            boolean aRet = false;
            for (int i = 0; i < DIRECTIONS.length; ++i) {
                if (null == inInfo.mAroundPos[i]) continue;
                SolverRecord aAgainstRec = SolverRI_4.this.getSolverRecord(inInfo.mAroundPos[i]);
                if (inInfo.mAroundMax - aAgainstRec.mResidue != inInfo.mRec.mResidue) continue;
                aRet |= this.attemptBuildLater(i, aList, inInfo);
            }
            return aRet;
        }

        private boolean attemptBuildLater(int inIndex, List inChainList, SolverInfo inInfo) {
            int aSum = 0;
            int aSize = 1;
            for (int i = 0; i < DIRECTIONS.length; ++i) {
                if (null == inInfo.mAroundPos[i] || i == inIndex) continue;
                SolverRecord aAgainstRec = SolverRI_4.this.getSolverRecord(inInfo.mAroundPos[i]);
                List aAgainstList = SolverRI_4.this.getChainList(aAgainstRec);
                if (inInfo.mRec.mQueueRef == aAgainstRec.mQueueRef && inChainList.size() <= DIRECTIONS.length) {
                    ++aSize;
                    aSum += aAgainstRec.mResidue;
                    continue;
                }
                if (aAgainstList.size() != 1) continue;
                aSum += aAgainstRec.mResidue;
            }
            if (inChainList.size() == aSize && aSum == inInfo.mRec.mResidue) {
                return SolverRI_4.this.buildBridge(inInfo.mRec, 1, inIndex);
            }
            return false;
        }
    }

    private class HashikakeSolverPattern2
    implements SolverPattern {
        private HashikakeSolverPattern2() {
        }

        public boolean build(SolverInfo inInfo) {
            boolean aRet = false;
            for (int i = 0; i < DIRECTIONS.length; ++i) {
                if (null == inInfo.mRec.mOpposite[i] || 0 != inInfo.mRec.mOpposite[i].mCount) continue;
                SolverRecord aAgainstRec = SolverRI_4.this.getSolverRecord(inInfo.mAroundPos[i]);
                if (inInfo.mAroundMax - aAgainstRec.mResidue >= inInfo.mRec.mResidue) continue;
                aRet |= SolverRI_4.this.buildBridge(inInfo.mRec, 1, i);
            }
            return aRet;
        }
    }

    private class HashikakeSolverPattern1
    implements SolverPattern {
        private HashikakeSolverPattern1() {
        }

        public boolean build(SolverInfo inInfo) {
            int aOpposite = inInfo.mRec.mOppositeCount;
            int aResidue = inInfo.mRec.mResidue;
            int aNumPerDir = 2 - (aOpposite * 2 - aResidue);
            if (2 < aNumPerDir) {
                aNumPerDir = 1;
            }
            boolean aRet = false;
            for (int i = 0; i < DIRECTIONS.length; ++i) {
                if (null == inInfo.mRec.mOpposite[i] || null == inInfo.mAroundPos[i] || 0 >= aNumPerDir || aNumPerDir <= inInfo.mRec.mOpposite[i].mCount) continue;
                SolverRecord aAgainstRec = SolverRI_4.this.getSolverRecord(inInfo.mAroundPos[i]);
                if (aNumPerDir > aAgainstRec.mResidue) {
                    aNumPerDir = aAgainstRec.mResidue;
                }
                aRet |= SolverRI_4.this.buildBridge(inInfo.mRec, aNumPerDir, i);
            }
            return aRet;
        }
    }

    private static class FinishState
    implements State {
        private FinishState() {
        }

        public State onEnter(StateEventCode inEvent) {
            return this;
        }
    }

    private static class DisableState
    implements State {
        private DisableState() {
        }

        public State onEnter(StateEventCode inEvent) {
            return this;
        }
    }

    private static class StartState
    implements State {
        private StartState() {
        }

        public State onEnter(StateEventCode inEvent) {
            return this;
        }
    }

    private static class ProcessState
    implements State {
        private ProcessState() {
        }

        public State onEnter(StateEventCode inEvent) {
            return this;
        }
    }

    private static interface SolverPattern {
        public boolean build(SolverInfo var1);
    }

    private static class SolverInfo {
        SolverRecord mRec;
        int mAroundMax;
        Point[] mAroundPos;

        SolverInfo(SolverRecord inRec, int inAroundMax, Point[] inAroundPos) {
            this.mRec = inRec;
            this.mAroundMax = inAroundMax;
            this.mAroundPos = inAroundPos;
        }
    }

    static class SolverRecord {
        int mQueueRef;
        Point mPos;
        final int mMaxBuildCount;
        int mResidue;
        int mOppositeCount;
        OppositeRecord[] mOpposite = new OppositeRecord[SolverRI_4.access$100().length];
        State mState = SolverRI_4.access$000();
        int mPenalty = 0;
        boolean mValied;
        boolean mMostPriority;

        SolverRecord(int inQueueRef, Point inPos, int inCount) {
            this.mQueueRef = inQueueRef;
            this.mPos = inPos;
            this.mMaxBuildCount = this.mResidue = inCount;
        }

        public String toString() {
            return "count = " + this.mOppositeCount + ", residue = " + this.mResidue + ", priority = " + this.mMostPriority + ", pos = [x=" + this.mPos.x + ",y=" + this.mPos.y + "]";
        }
    }

    static class OppositeRecord {
        int mCount;
        State mState = SolverRI_4.access$000();

        OppositeRecord() {
        }
    }
}

