/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental;

import java.awt.Point;
import java.util.HashSet;
import java.util.Set;
import jp.gr.java_conf.ktz.puzzle.framework.AbstractDecoratedModel;
import jp.gr.java_conf.ktz.puzzle.framework.Model;
import jp.gr.java_conf.ktz.puzzle.framework.ModelConstants;
import jp.gr.java_conf.ktz.puzzle.framework.ModelState;
import jp.gr.java_conf.ktz.puzzle.framework.NullModel;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.HashikakeNumberState;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.AbstractSolverState;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.SolverFinishedState;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.SolverProcessingState;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.SolverStartState;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.HashikakeStateEventCode;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.ModelStateUtility;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;

public class SolverStateModel
extends AbstractDecoratedModel {
    private static final AbstractSolverState START_STATE = new SolverStartState();
    private static final AbstractSolverState PROCESSING_STATE = new SolverProcessingState();
    private static final AbstractSolverState FINISHED_STATE = new SolverFinishedState();
    private static final Point[] NO_MODIFIED = ModelConstants.EMPTIES;
    private Entry[] mSolverEntries = new Entry[0];
    private Set mLastModified = new HashSet();
    private boolean mIsAcceptModel;

    public SolverStateModel(boolean inIsAccept, Model inModel) {
        this.addModel(inModel);
        this.mIsAcceptModel = inIsAccept;
    }

    public SolverStateModel(boolean inIsAccept) {
        this(inIsAccept, NullModel.getInstance());
    }

    public SolverStateModel(Model inModel) {
        this(true, inModel);
    }

    protected void createBoardSelf(int inWidth, int inHeight) {
        this.mSolverEntries = new Entry[inWidth * inHeight];
    }

    public int setProblem(ProblemInfo inInfo) {
        if (this.getWidth() != inInfo.getWidth() || this.getHeight() != inInfo.getHeight()) {
            this.createBoard(inInfo.getWidth(), inInfo.getHeight());
        }
        if (inInfo.isMoreRead()) {
            int aReadPos = 0;
            if (inInfo.isDivideRead()) {
                aReadPos = inInfo.getOffset();
            }
            for (int i = aReadPos; i < aReadPos + inInfo.getReadOnce(); ++i) {
                try {
                    int aNum = Integer.parseInt((String)inInfo.getRecordAt(i));
                    this.mSolverEntries[i] = new Entry(aNum);
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        return this.getDecorated().setProblem(inInfo);
    }

    public void reset() {
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                this.resetAtSelf(x, y);
            }
        }
        this.getDecorated().reset();
    }

    protected void resetAtSelf(int inX, int inY) {
        if (this.isNumberAt(inX, inY)) {
            try {
                this.getEntryAt(inX, inY).reset();
            }
            catch (NullPointerException e) {
                System.out.println("illegal reset at " + new Point(inX, inY));
            }
        }
    }

    protected boolean acceptableModelState(ModelState inState) {
        return ModelStateUtility.isAcceptSolverModelState(inState);
    }

    protected void setModelStateSelf(ModelState inState) {
        this.mIsAcceptModel = ModelStateUtility.isAcceptSolverModelState(inState);
    }

    public State getCurStateAt(int inX, int inY) {
        State aState = this.getDecorated().getCurStateAt(inX, inY);
        if (this.mIsAcceptModel && this.mLastModified.contains(new Point(inX, inY)) && aState instanceof HashikakeNumberState) {
            HashikakeNumberState aNumState = (HashikakeNumberState)aState;
            AbstractSolverState aSolverState = this.getEntryAt(inX, inY).getState();
            aNumState.setColorState(aSolverState);
        }
        return aState;
    }

    protected boolean isAcceptableEvent(StateEventCode inCode) {
        return UtilityFuncs.isDeterminationType(inCode) || inCode instanceof HashikakeStateEventCode;
    }

    protected void nextStateAtSelf(int inX, int inY, StateEventCode inCode) {
        if (inCode == UtilityFuncs.createSpaceCode()) {
            this.mSolverEntries[this.toIndex((int)inX, (int)inY)] = null;
        } else if (inCode instanceof HashikakeStateEventCode) {
            int aNum = Integer.parseInt(inCode.getValue());
            Entry aEntry = null;
            aEntry = this.getEntryAt(inX, inY);
            if (null != aEntry && aNum == aEntry.getMaxNum()) {
                aEntry.reset();
            } else {
                this.mSolverEntries[this.toIndex((int)inX, (int)inY)] = new Entry(aNum);
            }
        } else {
            if (this.isNumberAt(inX, inY)) {
                this.getEntryAt(inX, inY).nextState();
            }
            this.mLastModified.add(new Point(inX, inY));
        }
    }

    private Entry getEntryAt(int inX, int inY) {
        if (!this.contains(inX, inY)) {
            throw new IllegalArgumentException("Specified position is out of the board.");
        }
        return this.mSolverEntries[this.toIndex(inX, inY)];
    }

    private int toIndex(int inX, int inY) {
        return inY * this.getWidth() + inX;
    }

    protected void prevStateAtSelf(int inX, int inY, StateEventCode inCode) {
    }

    protected Point[] lastModifiedSelf() {
        if (this.isModifiedSelf()) {
            return this.mLastModified.toArray(new Point[this.mLastModified.size()]);
        }
        return NO_MODIFIED;
    }

    protected boolean isModifiedSelf() {
        return !this.mLastModified.isEmpty();
    }

    protected void flushSelf() {
        if (!this.mLastModified.isEmpty()) {
            this.mLastModified = new HashSet();
        }
    }

    private static class Entry {
        private final int mMaxNum;
        private int mResidue;
        private AbstractSolverState mState;

        Entry(int inMaxNum) {
            this.mMaxNum = inMaxNum;
            this.reset();
        }

        void reset() {
            this.mResidue = this.mMaxNum;
            this.mState = START_STATE;
        }

        void nextState() {
            --this.mResidue;
            if (0 > this.mResidue) {
                throw new IllegalStateException("Too more building bridge tobuild !");
            }
            this.mState = 0 < this.mResidue ? PROCESSING_STATE : FINISHED_STATE;
        }

        int getMaxNum() {
            return this.mMaxNum;
        }

        AbstractSolverState getState() {
            return this.mState;
        }
    }
}

