/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.solver.view;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import jp.gr.java_conf.ktz.puzzle.framework.AbstractDecoratedModel;
import jp.gr.java_conf.ktz.puzzle.framework.DefaultRenderer;
import jp.gr.java_conf.ktz.puzzle.framework.Model;
import jp.gr.java_conf.ktz.puzzle.framework.NullModel;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.BoardModel;
import jp.gr.java_conf.ktz.puzzle.hashikake.command.BoardSizeCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.command.LoadCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.command.PieceSizeCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.AppColors;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.HashikakeSolverHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SolveDiscompleteException;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.SolverHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.model.experimental.SolverStateModel;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.view.SolverRendererFactory;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.Command;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.AWTDispatchCommandQueue;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.AbstractBottomUpCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.AlreadyMonitoredException;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.BoardView;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.Monitor;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.Mutex;

public final class Board
extends Canvas
implements BoardView {
    private static final int DEFAULT_BOARD_WIDTH = 9;
    private static final int DEFAULT_BOARD_HEIGHT = 9;
    private Model mModel = NullModel.getInstance();
    private SolverHandler mHandler;
    private DefaultRenderer mRenderer;
    private BoardView mParent;
    private Mutex mMutex = new Mutex();
    private Monitor mMonitor;
    private boolean mIsModified;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$command$BoardSizeCommand;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$command$LoadCommand;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$command$ResetCommand;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$solver$view$command$NextCommand;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$solver$view$command$NextAllCommand;

    public void initialize() {
        System.out.println("init");
        this.mRenderer = SolverRendererFactory.create(9, 9);
        this.setBackground(AppColors.BACK_COLOR);
        this.createBoard(9, 9);
        PieceSizeCommand aCommand = new PieceSizeCommand(this, this.getPieceSize());
        AWTDispatchCommandQueue.postCommand(aCommand);
    }

    public void addModel(AbstractDecoratedModel inModel) {
        inModel.addModel(this.mModel);
        this.mModel = inModel;
    }

    public void setRenderer(DefaultRenderer inRenderer) {
        this.mRenderer = inRenderer;
    }

    public void processCommand(Command inCommand) {
        if (!inCommand.isConsumed()) {
            this.processCommandImpl(inCommand);
        }
        if (!inCommand.isConsumed() && inCommand instanceof AbstractBottomUpCommand) {
            this.mParent.processCommand(inCommand);
        }
    }

    protected void processCommandImpl(Command inCommand) {
        Class<?> aClass = inCommand.getClass();
        if (aClass == (class$jp$gr$java_conf$ktz$puzzle$hashikake$command$BoardSizeCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$command$BoardSizeCommand = Board.class$("jp.gr.java_conf.ktz.puzzle.hashikake.command.BoardSizeCommand")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$command$BoardSizeCommand)) {
            int aWidth = ((BoardSizeCommand)inCommand).getComponentWidth();
            int aHeight = ((BoardSizeCommand)inCommand).getComponentHeight();
            this.setComponentSize(aWidth, aHeight);
        } else if (aClass == (class$jp$gr$java_conf$ktz$puzzle$hashikake$command$LoadCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$command$LoadCommand = Board.class$("jp.gr.java_conf.ktz.puzzle.hashikake.command.LoadCommand")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$command$LoadCommand)) {
            ProblemInfo aInfo = ((LoadCommand)inCommand).getProblem();
            this.load(aInfo);
            inCommand.consume();
        } else if (aClass == (class$jp$gr$java_conf$ktz$puzzle$hashikake$command$ResetCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$command$ResetCommand = Board.class$("jp.gr.java_conf.ktz.puzzle.hashikake.command.ResetCommand")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$command$ResetCommand)) {
            this.clear();
            inCommand.consume();
        } else if (aClass == (class$jp$gr$java_conf$ktz$puzzle$hashikake$solver$view$command$NextCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$solver$view$command$NextCommand = Board.class$("jp.gr.java_conf.ktz.puzzle.hashikake.solver.view.command.NextCommand")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$solver$view$command$NextCommand)) {
            this.nextSolute();
            inCommand.consume();
        } else if (aClass == (class$jp$gr$java_conf$ktz$puzzle$hashikake$solver$view$command$NextAllCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$solver$view$command$NextAllCommand = Board.class$("jp.gr.java_conf.ktz.puzzle.hashikake.solver.view.command.NextAllCommand")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$solver$view$command$NextAllCommand)) {
            this.nextSoluteAll();
            inCommand.consume();
        }
    }

    public void setParent(BoardView inBoard) {
        this.mParent = inBoard;
    }

    private void load(ProblemInfo inInfo) {
        if (null == inInfo) {
            throw new IllegalArgumentException("null object is passed to inInfo");
        }
        if (this.isMonitored()) {
            return;
        }
        try {
            class LoadRunner
            implements Runnable {
                private final int ONCE_READ_COUNT = 100;
                private final /* synthetic */ ProblemInfo val$inInfo;

                LoadRunner(ProblemInfo val$inInfo) {
                    this.val$inInfo = val$inInfo;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public synchronized void run() {
                    long t1 = System.currentTimeMillis();
                    System.out.println("set problem");
                    if (Board.this.mModel instanceof NullModel) {
                        Board.this.mModel = (Model)new SolverStateModel((Model)new BoardModel(Board.this.mModel));
                        Board.this.mHandler = new HashikakeSolverHandler(Board.this.mModel);
                    }
                    Board.this.createBoard(this.val$inInfo.getWidth(), this.val$inInfo.getHeight());
                    try {
                        int aOffset;
                        int aReadPos = 0;
                        do {
                            ProblemInfo aInfo = new ProblemInfo(aReadPos, 100, this.val$inInfo);
                            Mutex mutex = Board.this.mMutex;
                            synchronized (mutex) {
                                aOffset = Board.this.mModel.setProblem(aInfo);
                            }
                            aReadPos += aOffset;
                            Board.this.repaint();
                            while (Board.this.mModel.isModified()) {
                                Board.this.mMonitor.suspend();
                            }
                        } while (Integer.MIN_VALUE != aOffset);
                        Object var9_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_8 = null;
                        Mutex mutex = Board.this.mMutex;
                        synchronized (mutex) {
                            Board.this.setModified(false);
                            Board.this.mHandler.reset();
                        }
                        long t2 = System.currentTimeMillis();
                        System.out.println("ellapsed tile for load : " + (t2 - t1) + " msec\n");
                        throw throwable;
                    }
                    Mutex mutex = Board.this.mMutex;
                    synchronized (mutex) {
                        Board.this.setModified(false);
                        Board.this.mHandler.reset();
                    }
                    long t2 = System.currentTimeMillis();
                    System.out.println("ellapsed tile for load : " + (t2 - t1) + " msec\n");
                }
            }
            this.invokeInternalAction(new LoadRunner(inInfo), "Load Thread");
        }
        catch (AlreadyMonitoredException e) {
            System.out.println(e);
            return;
        }
    }

    private void createBoard(int inWidth, int inHeight) {
        this.mRenderer.setSize(inWidth, inHeight);
        this.mModel.createBoard(inWidth, inHeight);
        Dimension aSize = this.mRenderer.getBoardSize();
        BoardSizeCommand aCommand = new BoardSizeCommand(this, aSize.width, aSize.height);
        AWTDispatchCommandQueue.postCommand(aCommand);
    }

    public void save(File inFile) {
        throw new UnsupportedOperationException("This view isnot supported save method.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isModified() {
        Mutex mutex = this.mMutex;
        synchronized (mutex) {
            return this.mIsModified;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setModified(boolean inModified) {
        Mutex mutex = this.mMutex;
        synchronized (mutex) {
            this.mIsModified = inModified;
        }
    }

    public Component getComponent() {
        return this;
    }

    void invokeInternalAction(Runnable inAction, String inThreadName) throws AlreadyMonitoredException {
        if (this.isMonitored()) {
            throw new AlreadyMonitoredException(inThreadName);
        }
        this.mMutex.lock();
        this.mMonitor = new Monitor(this.mMutex);
        new Thread((Runnable)new ActionProxy(inAction), inThreadName).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isMonitored() {
        Mutex mutex = this.mMutex;
        synchronized (mutex) {
            return null != this.mMonitor;
        }
    }

    private int getPieceSize() {
        return this.mRenderer.getPieceSize().width;
    }

    private void setComponentSize(int inWidth, int inHeight) {
        this.setSize(inWidth, inHeight);
    }

    private void nextSolute() {
        if (this.isMonitored()) {
            return;
        }
        this.mHandler.nextSolute();
        if (this.mModel.isModified()) {
            this.repaint();
            this.setModified(true);
        }
    }

    private void nextSoluteAll() {
        if (this.isMonitored()) {
            return;
        }
        try {
            class SolveRunner
            implements Runnable {
                SolveRunner() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                public void run() {
                    boolean aResolved;
                    long t1 = System.currentTimeMillis();
                    try {
                        try {}
                        catch (SolveDiscompleteException e) {
                            System.out.println(e);
                            Object var7_6 = null;
                            Board.this.setModified(true);
                            long t2 = System.currentTimeMillis();
                            System.out.println("(" + (t2 - t1) + " msec elapsed)\n");
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        Board.this.setModified(true);
                        long t2 = System.currentTimeMillis();
                        System.out.println("(" + (t2 - t1) + " msec elapsed)\n");
                        throw throwable;
                    }
                    do {
                        aResolved = false;
                        Mutex mutex = Board.this.mMutex;
                        // MONITORENTER : mutex
                        aResolved = Board.this.mHandler.nextSoluteAll();
                        // MONITOREXIT : mutex
                        if (Board.this.mModel.isModified()) {
                            Board.this.repaint();
                        }
                        while (Board.this.mModel.isModified()) {
                            Board.this.mMonitor.suspend();
                        }
                    } while (!aResolved);
                    Object var7_5 = null;
                    Board.this.setModified(true);
                    long t2 = System.currentTimeMillis();
                    System.out.println("(" + (t2 - t1) + " msec elapsed)\n");
                }
            }
            this.invokeInternalAction(new SolveRunner(), "Solver Thread");
        }
        catch (AlreadyMonitoredException e) {
            System.out.println(e);
            return;
        }
    }

    public void setFocus(boolean inFocused) {
        this.mParent.setFocus(inFocused);
    }

    public boolean isFocused() {
        return this.mParent.isFocused();
    }

    private void clear() {
        if (this.isMonitored()) {
            return;
        }
        if (!this.mIsModified) {
            return;
        }
        try {
            class ClearRunner
            implements Runnable {
                private final int LOOP_LIMIT = 100;

                ClearRunner() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    int aLimit = 100;
                    try {
                        for (int y = 0; y < Board.this.mModel.getHeight(); ++y) {
                            for (int x = 0; x < Board.this.mModel.getWidth(); ++x) {
                                --aLimit;
                                Mutex mutex = Board.this.mMutex;
                                synchronized (mutex) {
                                    Board.this.mModel.resetAt(x, y);
                                }
                                if (0 != aLimit) continue;
                                Board.this.repaint();
                                aLimit = 100;
                                while (Board.this.mModel.isModified()) {
                                    Board.this.mMonitor.suspend();
                                }
                            }
                        }
                        Object var7_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        if (Board.this.mModel.isModified()) {
                            Board.this.repaint();
                        }
                        while (Board.this.mModel.isModified()) {
                            Board.this.mMonitor.suspend();
                        }
                        Mutex mutex = Board.this.mMutex;
                        synchronized (mutex) {
                            Board.this.setModified(false);
                            Board.this.mHandler.reset();
                        }
                        throw throwable;
                    }
                    if (Board.this.mModel.isModified()) {
                        Board.this.repaint();
                    }
                    while (Board.this.mModel.isModified()) {
                        Board.this.mMonitor.suspend();
                    }
                    Mutex mutex = Board.this.mMutex;
                    synchronized (mutex) {
                        Board.this.setModified(false);
                        Board.this.mHandler.reset();
                    }
                }
            }
            this.invokeInternalAction(new ClearRunner(), "Clear Thread");
        }
        catch (AlreadyMonitoredException e) {
            System.out.println(e);
            return;
        }
    }

    private Point calcPortToBoardPos(int inX, int inY) {
        return this.mRenderer.calcPortToBoardPos(inX, inY);
    }

    public void update(Graphics inGra) {
        this.paint(inGra);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics inGra) {
        Rectangle aBounds = inGra.getClipBounds();
        Mutex mutex = this.mMutex;
        synchronized (mutex) {
            if (this.mModel.isModified()) {
                aBounds = new Rectangle();
                Point[] aPos = this.mModel.lastModified();
                for (int i = 0; i < aPos.length; ++i) {
                    this.mRenderer.render(aPos[i].x, aPos[i].y, this.mModel.getCurStateAt(aPos[i].x, aPos[i].y));
                }
                aBounds = this.getClipBounds();
            }
            inGra.drawImage(this.mRenderer.getImage(), aBounds.x, aBounds.y, aBounds.x + aBounds.width, aBounds.y + aBounds.height, aBounds.x, aBounds.y, aBounds.x + aBounds.width, aBounds.y + aBounds.height, this);
            this.mModel.flush();
        }
        if (this.isMonitored()) {
            this.mMonitor.resume();
        }
    }

    private Rectangle getClipBounds() {
        return this.mRenderer.getClipBounds(this.mModel.lastModified());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ActionProxy
    implements Runnable {
        private Runnable mAction;

        ActionProxy(Runnable inAction) {
            this.mAction = inAction;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.mAction.run();
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                Mutex mutex = Board.this.mMutex;
                synchronized (mutex) {
                    Board.this.mMutex.unlock();
                    Board.this.mMonitor = null;
                }
                System.gc();
                throw throwable;
            }
            Mutex mutex = Board.this.mMutex;
            synchronized (mutex) {
                Board.this.mMutex.unlock();
                Board.this.mMonitor = null;
            }
            System.gc();
        }
    }
}

