/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.app.model;

import java.awt.Point;
import java.util.Arrays;
import java.util.HashSet;
import jp.gr.java_conf.ktz.puzzle.framework.AbstractDecoratedModel;
import jp.gr.java_conf.ktz.puzzle.framework.Model;
import jp.gr.java_conf.ktz.puzzle.framework.ModelConstants;
import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.NumberActiveState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.SelectionState;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;

public class BridgibleCheckModel
extends AbstractDecoratedModel {
    private static final Point EMPTY_POS = ModelConstants.ILLEGAL_POS;
    private static final Point[] NO_MODIFIED = ModelConstants.EMPTIES;
    private Point mPressedPos = EMPTY_POS;
    private Point mOppositePos = EMPTY_POS;
    private Point[] mSelectedPos = NO_MODIFIED;
    private Point[] mDeactivatedPos = NO_MODIFIED;
    private boolean mIsModified = false;
    private Direction mDirection = Direction.NO;

    public BridgibleCheckModel(Model inModel) {
        super(inModel);
    }

    public State getCurStateAt(int inX, int inY) {
        Point aPos = new Point(inX, inY);
        State aState = super.getCurStateAt(inX, inY);
        if (aPos.equals(this.mPressedPos)) {
            return new NumberActiveState(aState, this.mDirection);
        }
        if (aPos.equals(this.mOppositePos)) {
            Direction aInverse = UtilityFuncs.inverseDirection(this.mDirection);
            return new NumberActiveState(aState, aInverse);
        }
        Point[] aModifiedPos = this.mSelectedPos;
        for (int i = 0; i < aModifiedPos.length; ++i) {
            if (!aPos.equals(aModifiedPos[i])) continue;
            return new SelectionState(aState);
        }
        return aState;
    }

    protected void createBoardSelf(int inWidth, int inHeight) {
    }

    protected void resetAtSelf(int inX, int inY) {
    }

    protected Point[] lastModifiedSelf() {
        HashSet<Point> aSet = new HashSet<Point>();
        if (this.mDeactivatedPos != NO_MODIFIED) {
            aSet.addAll(Arrays.asList(this.mDeactivatedPos));
        }
        if (this.mSelectedPos != NO_MODIFIED) {
            aSet.addAll(Arrays.asList(this.mSelectedPos));
        }
        return aSet.toArray(new Point[aSet.size()]);
    }

    protected boolean isModifiedSelf() {
        return this.mIsModified;
    }

    public boolean isAcceptableEvent(StateEventCode inCode) {
        return UtilityFuncs.isSelectionType(inCode) || UtilityFuncs.isDeterminationType(inCode);
    }

    protected void nextStateAtSelf(int inX, int inY, StateEventCode inEvent) {
    }

    public void nextStateAt(int inX, int inY, StateEventCode inEvent) {
        if (this.isAcceptableEvent(inEvent)) {
            if (UtilityFuncs.isSelectionType(inEvent)) {
                this.changeSelection(inX, inY, inEvent);
            } else if (UtilityFuncs.isDeterminationType(inEvent)) {
                this.determine();
                if (this.mOppositePos != EMPTY_POS && new Point(inX, inY).equals(this.mOppositePos)) {
                    Direction aInverse = UtilityFuncs.inverseDirection(UtilityFuncs.resolveDirectionOf(inEvent));
                    StateEventCode aEvent = UtilityFuncs.getDetermineDirectionEventCode(aInverse);
                    this.getDecorated().nextStateAt(this.mOppositePos.x, this.mOppositePos.y, aEvent);
                    this.mOppositePos = EMPTY_POS;
                    return;
                }
            }
        }
        this.getDecorated().nextStateAt(inX, inY, inEvent);
    }

    private void changeSelection(int inX, int inY, StateEventCode inCode) {
        Direction aDirection = UtilityFuncs.resolveDirectionOf(inCode);
        if (aDirection == Direction.NO) {
            this.mPressedPos = new Point(inX, inY);
            this.mOppositePos = EMPTY_POS;
            this.mDeactivatedPos = this.mSelectedPos;
            this.mSelectedPos = new Point[]{this.mPressedPos};
            this.mDirection = aDirection;
            this.mIsModified = true;
            return;
        }
        if (aDirection == this.mDirection) {
            return;
        }
        this.mDirection = aDirection;
        this.activate(aDirection);
    }

    private void determine() {
        if (!this.mIsModified) {
            this.mDeactivatedPos = this.mSelectedPos;
            this.mSelectedPos = NO_MODIFIED;
            this.mPressedPos = EMPTY_POS;
            this.mDirection = Direction.NO;
            this.mIsModified = true;
        }
    }

    protected void prevStateAtSelf(int inX, int inY, StateEventCode inEvent) {
    }

    public void prevStateAt(int inX, int inY, StateEventCode inEvent) {
        if (this.isAcceptableEvent(inEvent)) {
            if (UtilityFuncs.isSelectionType(inEvent)) {
                this.changeSelection(inX, inY, inEvent);
            } else if (UtilityFuncs.isDeterminationType(inEvent)) {
                this.determine();
                if (this.mOppositePos != EMPTY_POS && new Point(inX, inY).equals(this.mOppositePos)) {
                    Direction aInverse = UtilityFuncs.inverseDirection(UtilityFuncs.resolveDirectionOf(inEvent));
                    StateEventCode aEvent = UtilityFuncs.getDetermineDirectionEventCode(aInverse);
                    this.getDecorated().prevStateAt(this.mOppositePos.x, this.mOppositePos.y, aEvent);
                    this.mOppositePos = EMPTY_POS;
                    return;
                }
            }
        }
        this.getDecorated().prevStateAt(inX, inY, inEvent);
    }

    private void activate(Direction inDirection) {
        this.mDeactivatedPos = this.mSelectedPos;
        if (!this.isBuildBridge(inDirection)) {
            this.mSelectedPos = NO_MODIFIED;
            return;
        }
        Point aDiff = inDirection.getDifference();
        Point aPos = new Point(this.mPressedPos);
        HashSet<Point> aSet = new HashSet<Point>();
        aSet.add(new Point(aPos));
        aPos.translate(aDiff.x, aDiff.y);
        do {
            aSet.add(new Point(aPos));
            aPos.translate(aDiff.x, aDiff.y);
        } while (!this.isNumberAt(aPos.x, aPos.y));
        this.mOppositePos = new Point(aPos);
        aSet.add(this.mOppositePos);
        this.mSelectedPos = aSet.toArray(new Point[aSet.size()]);
        this.mIsModified = true;
    }

    private boolean isBuildBridge(Direction inDirection) {
        Point aDiff = inDirection.getDifference();
        Point aPos = new Point(this.mPressedPos);
        StateEventCode aCode = UtilityFuncs.getDetermineDirectionEventCode(inDirection);
        aPos.translate(aDiff.x, aDiff.y);
        if (!this.isTransitAt(aPos.x, aPos.y, aCode)) {
            return false;
        }
        do {
            aPos.translate(aDiff.x, aDiff.y);
            if (!this.isNumberAt(aPos.x, aPos.y)) continue;
            return true;
        } while (this.contains(aPos.x, aPos.y) && this.isTransitAt(aPos.x, aPos.y, aCode));
        return false;
    }

    protected void flushSelf() {
        if (this.mIsModified) {
            this.mDeactivatedPos = NO_MODIFIED;
            this.mIsModified = false;
        }
    }
}

