/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.app.model;

import java.awt.Point;
import jp.gr.java_conf.ktz.puzzle.framework.Model;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.ModelChangeDispatcher;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.ModelChangeEvent;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.ModelChangeListener;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;

public class HashikakeModelChangeHandler
implements ModelChangeListener,
ModelChangeDispatcher {
    private Model mModel;

    public HashikakeModelChangeHandler(Model inModel) {
        this.mModel = inModel;
    }

    public void processModelChange(ModelChangeEvent inEvent) {
        switch (inEvent.getMode()) {
            case 0: {
                this.selectionChanged(inEvent);
                break;
            }
            case 1: {
                this.selectionDetermined(inEvent);
            }
        }
    }

    public void selectionChanged(ModelChangeEvent inEvent) {
        StateEventCode aCode = UtilityFuncs.getSelectDirectionEventCode(inEvent.getDirection());
        Point aPressed = inEvent.getPos();
        this.mModel.nextStateAt(aPressed.x, aPressed.y, aCode);
    }

    public void selectionDetermined(ModelChangeEvent inEvent) {
        Point[] aModified = this.mModel.lastModified();
        StateEventCode aEvent = UtilityFuncs.getDetermineDirectionEventCode(inEvent.getDirection());
        for (int i = 0; i < aModified.length; ++i) {
            if (inEvent.isTransitNext()) {
                this.mModel.nextStateAt(aModified[i].x, aModified[i].y, aEvent);
                continue;
            }
            this.mModel.prevStateAt(aModified[i].x, aModified[i].y, aEvent);
        }
    }
}

