/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.app.model;

import java.util.HashMap;
import java.util.Map;
import jp.gr.java_conf.ktz.puzzle.framework.DecoratedStateManagerImpl;
import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.StateManagerImpl;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.BigNSBridgeState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.BigWEBridgeState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.BranchState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.HashikakeNumberState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.NSBridgeState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.NumberState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.SpaceState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.WEBridgeState;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;

public class HashikakeStateManagerImpl
extends DecoratedStateManagerImpl {
    public static final String SPACE_ID = "s";
    public static final String NS_BRIDGE_ID = "i";
    public static final String BIG_NS_BRIDGE_ID = "ii";
    public static final String WE_BRIDGE_ID = "-";
    public static final String BIG_WE_BRIDGE_ID = "=";
    public static final String NULL_ID = "";
    private Map mStateMap = new HashMap();
    private Map mStateToIDMap = new HashMap();
    private Map mTransitMap = new HashMap();
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$NSBridgeState;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$WEBridgeState;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$BigNSBridgeState;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$BigWEBridgeState;

    public HashikakeStateManagerImpl() {
        this(null);
    }

    public HashikakeStateManagerImpl(StateManagerImpl inManager) {
        super(inManager);
        State aSpace = SpaceState.getInstance();
        NSBridgeState aNSBridge = new NSBridgeState();
        BigNSBridgeState aBigNSBridge = new BigNSBridgeState();
        WEBridgeState aWEBridge = new WEBridgeState();
        BigWEBridgeState aBigWEBridge = new BigWEBridgeState();
        StateEventCode aWest = UtilityFuncs.getDetermineDirectionEventCode(Direction.WEST);
        StateEventCode aEast = UtilityFuncs.getDetermineDirectionEventCode(Direction.EAST);
        StateEventCode aNorth = UtilityFuncs.getDetermineDirectionEventCode(Direction.NORTH);
        StateEventCode aSouth = UtilityFuncs.getDetermineDirectionEventCode(Direction.SOUTH);
        this.installStateMap(SPACE_ID, aSpace);
        this.installStateMap(NS_BRIDGE_ID, aNSBridge);
        this.installStateMap(BIG_NS_BRIDGE_ID, aBigNSBridge);
        this.installStateMap(WE_BRIDGE_ID, aWEBridge);
        this.installStateMap(BIG_WE_BRIDGE_ID, aBigWEBridge);
        this.installTransitMap((State)aNSBridge, aSpace, aBigNSBridge, new StateEventCode[]{aNorth, aSouth});
        this.installTransitMap((State)aBigNSBridge, (State)aNSBridge, aSpace, new StateEventCode[]{aNorth, aSouth});
        this.installTransitMap((State)aWEBridge, aSpace, aBigWEBridge, new StateEventCode[]{aWest, aEast});
        this.installTransitMap((State)aBigWEBridge, (State)aWEBridge, aSpace, new StateEventCode[]{aWest, aEast});
        this.installTransitMap(aSpace, aSpace, new BranchState.TransitHint[]{new BranchState.TransitHint(aNSBridge, new StateEventCode[]{aNorth, aSouth}), new BranchState.TransitHint(aWEBridge, new StateEventCode[]{aWest, aEast})}, new StateEventCode[]{aNorth, aSouth, aWest, aEast});
    }

    private void installTransitMap(State inCur, State inPrev, State inNext, StateEventCode[] inEvent) {
        this.mTransitMap.put(inCur, new TransitRecord(inPrev, inNext, inEvent));
    }

    private void installTransitMap(State inCur, State inPrev, BranchState.TransitHint[] inNext, StateEventCode[] inEvent) {
        this.installTransitMap(inCur, inPrev, new BranchState(inNext), inEvent);
    }

    private void installStateMap(String inID, State inState) {
        this.mStateMap.put(inID, inState);
        this.mStateToIDMap.put(inState, inID);
    }

    protected State createStateOfSelf(String inStateID) {
        String aID = inStateID.trim().toLowerCase();
        if (this.mStateMap.containsKey(aID)) {
            return (State)this.mStateMap.get(aID);
        }
        try {
            int aNum = Integer.parseInt(aID);
            NumberState aState = new NumberState(aNum);
            this.installStateMap(aID, aState);
            return aState;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Illegal State ID : " + inStateID);
        }
    }

    protected State createDefaultStateSelf() {
        return this.createStateOf(SPACE_ID);
    }

    protected String findIdentityOfSelf(State inState) {
        if (this.isNumberState(inState)) {
            return this.findIdentityOf(((HashikakeNumberState)inState).getNumberState());
        }
        if (!this.mStateToIDMap.containsKey(inState)) {
            throw new IllegalArgumentException("The ID corresponding to the state is no existance.");
        }
        return (String)this.mStateToIDMap.get(inState);
    }

    protected State getNextStateSelf(State inState) {
        throw new UnsupportedOperationException("The method getNextState(State) is not supported");
    }

    protected State getNextStateSelf(State inState, StateEventCode inEvent) {
        if (this.isNumberState(inState)) {
            return this.getNextNumberState(inState, inEvent);
        }
        if (!this.mTransitMap.containsKey(inState)) {
            throw new IllegalArgumentException("The next State is no existence.");
        }
        TransitRecord aRec = (TransitRecord)this.mTransitMap.get(inState);
        return aRec.mNext.onEnter(inEvent);
    }

    private State getNextNumberState(State inState, StateEventCode inEvent) {
        HashikakeNumberState aNumState = (HashikakeNumberState)inState;
        Direction aDirection = UtilityFuncs.resolveDirectionOf(inEvent);
        HashikakeNumberState.AdjacentState aAdjacent = aNumState.findAdjacentOf(aDirection);
        if (null != aAdjacent) {
            State aState = this.getNextState(aAdjacent.getState(), inEvent);
            aAdjacent.setState(aState);
        }
        return inState;
    }

    protected State getPrevStateSelf(State inState) {
        throw new UnsupportedOperationException("The method getPrevState(State) is not supported");
    }

    protected State getPrevStateSelf(State inState, StateEventCode inEvent) {
        if (this.isNumberState(inState)) {
            return this.getPrevNumberState(inState, inEvent);
        }
        if (!this.mTransitMap.containsKey(inState)) {
            throw new IllegalArgumentException("The next State is no existence.");
        }
        TransitRecord aRec = (TransitRecord)this.mTransitMap.get(inState);
        return aRec.mPrev.onEnter(inEvent);
    }

    private State getPrevNumberState(State inState, StateEventCode inEvent) {
        HashikakeNumberState aNumState = (HashikakeNumberState)inState;
        Direction aDirection = UtilityFuncs.resolveDirectionOf(inEvent);
        HashikakeNumberState.AdjacentState aAdjacent = aNumState.findAdjacentOf(aDirection);
        if (null != aAdjacent) {
            State aState = this.getPrevState(aAdjacent.getState(), inEvent);
            aAdjacent.setState(aState);
        }
        return inState;
    }

    protected boolean isNumberStateSelf(State inState) {
        return inState instanceof HashikakeNumberState;
    }

    protected boolean isSpaceStateSelf(State inState) {
        return inState instanceof SpaceState;
    }

    protected boolean isTransitSelf(State inState, StateEventCode inEvent) {
        if (this.isNumberState(inState)) {
            return true;
        }
        if (!this.mTransitMap.containsKey(inState)) {
            return false;
        }
        TransitRecord aRec = (TransitRecord)this.mTransitMap.get(inState);
        for (int i = 0; i < aRec.mEvent.length; ++i) {
            if (aRec.mEvent[i] != inEvent) continue;
            return true;
        }
        return false;
    }

    protected boolean isTransitSelf(State inState) {
        throw new UnsupportedOperationException("The method isTransit(State) is not supported");
    }

    protected boolean acceptableEventCode(StateEventCode inEvent) {
        return UtilityFuncs.isSelectionType(inEvent) || UtilityFuncs.isDeterminationType(inEvent);
    }

    public static int countBridge(State inState) {
        if ((class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$NSBridgeState == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$NSBridgeState = HashikakeStateManagerImpl.class$("jp.gr.java_conf.ktz.puzzle.hashikake.fsm.NSBridgeState")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$NSBridgeState).equals(inState.getClass()) || (class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$WEBridgeState == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$WEBridgeState = HashikakeStateManagerImpl.class$("jp.gr.java_conf.ktz.puzzle.hashikake.fsm.WEBridgeState")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$WEBridgeState).equals(inState.getClass())) {
            return 1;
        }
        if ((class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$BigNSBridgeState == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$BigNSBridgeState = HashikakeStateManagerImpl.class$("jp.gr.java_conf.ktz.puzzle.hashikake.fsm.BigNSBridgeState")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$BigNSBridgeState).equals(inState.getClass()) || (class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$BigWEBridgeState == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$BigWEBridgeState = HashikakeStateManagerImpl.class$("jp.gr.java_conf.ktz.puzzle.hashikake.fsm.BigWEBridgeState")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$fsm$BigWEBridgeState).equals(inState.getClass())) {
            return 2;
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class TransitRecord {
        final State mPrev;
        final State mNext;
        final StateEventCode[] mEvent;

        TransitRecord(State inPrev, State inNext, StateEventCode[] inEvent) {
            this.mPrev = inPrev;
            this.mNext = inNext;
            this.mEvent = inEvent;
        }
    }
}

