/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.app.view;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Map;
import jp.gr.java_conf.ktz.puzzle.framework.DefaultRenderer;
import jp.gr.java_conf.ktz.puzzle.framework.Model;
import jp.gr.java_conf.ktz.puzzle.framework.ModelConstants;
import jp.gr.java_conf.ktz.puzzle.framework.NullModel;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.BoardModel;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.BridgibleCheckModel;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.HashikakeModelChangeHandler;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.ModelChangeDispatcher;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.ModelChangeEvent;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.model.SolutionCheckModel;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.view.RendererFactory;
import jp.gr.java_conf.ktz.puzzle.hashikake.app.view.command.CheckResultCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.command.BoardSizeCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.command.LoadCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.command.PieceSizeCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.AppColors;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.Command;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.MenuManager;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.AWTDispatchCommandQueue;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.AbstractBottomUpCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.BoardView;

public class Board
extends Canvas
implements BoardView {
    private static final int DEFAULT_BOARD_WIDTH = 9;
    private static final int DEFAULT_BOARD_HEIGHT = 9;
    private static final Point NO_CLICKED = ModelConstants.ILLEGAL_POS;
    private Model mModel = NullModel.getInstance();
    private ModelChangeDispatcher mDispatcher = new ModelChangeDispatcher(){

        public void processModelChange(ModelChangeEvent inEvent) {
        }
    };
    private DefaultRenderer mRenderer;
    private Map mTable;
    private BoardView mParent;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$command$ResetCommand;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$app$view$command$CheckCommand;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$command$BoardSizeCommand;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$command$LoadCommand;

    public void initialize() {
        System.out.println("init");
        this.mModel = NullModel.getInstance();
        this.mRenderer = RendererFactory.create(9, 9);
        this.setBackground(AppColors.BACK_COLOR);
        this.createBoard(9, 9);
        MouseHandler aHandler = new MouseHandler();
        this.addMouseListener(aHandler);
        this.addMouseMotionListener(aHandler);
        PieceSizeCommand aCommand = new PieceSizeCommand(this, this.getPieceSize());
        AWTDispatchCommandQueue.postCommand(aCommand);
    }

    public void processCommand(Command inCommand) {
        if (!inCommand.isConsumed()) {
            this.processCommandImpl(inCommand);
        }
        if (!inCommand.isConsumed() && inCommand instanceof AbstractBottomUpCommand) {
            this.mParent.processCommand(inCommand);
        }
    }

    protected void processCommandImpl(Command inCommand) {
        Class<?> aClass = inCommand.getClass();
        if (aClass == (class$jp$gr$java_conf$ktz$puzzle$hashikake$command$ResetCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$command$ResetCommand = Board.class$("jp.gr.java_conf.ktz.puzzle.hashikake.command.ResetCommand")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$command$ResetCommand)) {
            this.clear();
            inCommand.consume();
        } else if (aClass == (class$jp$gr$java_conf$ktz$puzzle$hashikake$app$view$command$CheckCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$app$view$command$CheckCommand = Board.class$("jp.gr.java_conf.ktz.puzzle.hashikake.app.view.command.CheckCommand")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$app$view$command$CheckCommand)) {
            boolean aRes = this.check();
            inCommand.consume();
            CheckResultCommand aCommand = new CheckResultCommand(this, aRes);
            AWTDispatchCommandQueue.postCommand(aCommand);
        } else if (aClass == (class$jp$gr$java_conf$ktz$puzzle$hashikake$command$BoardSizeCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$command$BoardSizeCommand = Board.class$("jp.gr.java_conf.ktz.puzzle.hashikake.command.BoardSizeCommand")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$command$BoardSizeCommand)) {
            int aWidth = ((BoardSizeCommand)inCommand).getComponentWidth();
            int aHeight = ((BoardSizeCommand)inCommand).getComponentHeight();
            this.setComponentSize(aWidth, aHeight);
        } else if (aClass == (class$jp$gr$java_conf$ktz$puzzle$hashikake$command$LoadCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$command$LoadCommand = Board.class$("jp.gr.java_conf.ktz.puzzle.hashikake.command.LoadCommand")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$command$LoadCommand)) {
            ProblemInfo aInfo = ((LoadCommand)inCommand).getProblem();
            this.load(aInfo);
            inCommand.consume();
        }
    }

    public void setParent(BoardView inBoard) {
        this.mParent = inBoard;
    }

    private void load(ProblemInfo inInfo) {
        System.out.println("set problem");
        if (null == inInfo) {
            throw new IllegalArgumentException("pass null object to inInfo");
        }
        if (this.mModel instanceof NullModel) {
            this.mModel = new SolutionCheckModel((Model)new BridgibleCheckModel((Model)new BoardModel(this.mModel)));
            this.mDispatcher = new HashikakeModelChangeHandler(this.mModel);
        }
        this.createBoard(inInfo.getWidth(), inInfo.getHeight());
        this.mModel.setProblem(inInfo);
        if (this.mModel.isModified()) {
            Rectangle aBounds = this.getClipBounds();
            this.repaint(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
        }
    }

    private void createBoard(int inWidth, int inHeight) {
        this.mRenderer.setSize(inWidth, inHeight);
        this.mModel.createBoard(inWidth, inHeight);
        Dimension aSize = this.mRenderer.getBoardSize();
        BoardSizeCommand aCommand = new BoardSizeCommand(this, aSize.width, aSize.height);
        AWTDispatchCommandQueue.postCommand(aCommand);
    }

    private boolean check() {
        return this.mModel.check();
    }

    public boolean isModified() {
        return false;
    }

    public Component getComponent() {
        return this;
    }

    private int getPieceSize() {
        return this.mRenderer.getPieceSize().width;
    }

    private void setComponentSize(int inWidth, int inHeight) {
        this.setSize(inWidth, inHeight);
    }

    public void setFocus(boolean inFocused) {
        this.mParent.setFocus(inFocused);
    }

    public boolean isFocused() {
        return this.mParent.isFocused();
    }

    private void clear() {
        this.mModel.reset();
        MenuManager.currentMenuManager().setEnabledFor("Clear", false);
        if (this.mModel.isModified()) {
            Rectangle aBounds = this.getClipBounds();
            this.repaint(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
        }
    }

    private Point calcPortToBoardPos(int inX, int inY) {
        return this.mRenderer.calcPortToBoardPos(inX, inY);
    }

    public void update(Graphics inGra) {
        this.paint(inGra);
    }

    public void paint(Graphics inGra) {
        Rectangle aBounds = inGra.getClipBounds();
        if (this.mModel.isModified()) {
            aBounds = new Rectangle();
            Point[] aPos = this.mModel.lastModified();
            for (int i = 0; i < aPos.length; ++i) {
                this.mRenderer.render(aPos[i].x, aPos[i].y, this.mModel.getCurStateAt(aPos[i].x, aPos[i].y));
            }
            aBounds = this.getClipBounds();
        }
        inGra.drawImage(this.mRenderer.getImage(), aBounds.x, aBounds.y, aBounds.x + aBounds.width, aBounds.y + aBounds.height, aBounds.x, aBounds.y, aBounds.x + aBounds.width, aBounds.y + aBounds.height, this);
        this.mModel.flush();
    }

    private Rectangle getClipBounds() {
        return this.mRenderer.getClipBounds(this.mModel.lastModified());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MouseHandler
    implements MouseListener,
    MouseMotionListener {
        private Point mClickedPos = Board.access$100();

        private MouseHandler() {
        }

        public void mousePressed(MouseEvent inEvent) {
            Point aPos = Board.this.calcPortToBoardPos(inEvent.getX(), inEvent.getY());
            if (!Board.this.mModel.isNumberAt(aPos.x, aPos.y)) {
                return;
            }
            this.mClickedPos = aPos;
            ModelChangeEvent aEvent = ModelChangeEvent.createSelectionEvent(this.mClickedPos.x, this.mClickedPos.y, Direction.NO);
            Board.this.mDispatcher.processModelChange(aEvent);
            Rectangle aBounds = Board.this.getClipBounds();
            Board.this.repaint(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
        }

        public void mouseReleased(MouseEvent inEvent) {
            Direction aDirection = this.calcDirection(Board.this.calcPortToBoardPos(inEvent.getX(), inEvent.getY()));
            ModelChangeEvent aEvent = ModelChangeEvent.createDeterminationEvent(this.mClickedPos.x, this.mClickedPos.y, aDirection);
            if (inEvent.getModifiers() == 4 || inEvent.getModifiers() == 17) {
                aEvent.changeTransit(false);
            }
            Board.this.mDispatcher.processModelChange(aEvent);
            this.mClickedPos = NO_CLICKED;
            if (Board.this.mModel.isModified()) {
                MenuManager.currentMenuManager().setEnabledFor("Clear", true);
                Rectangle aBounds = Board.this.getClipBounds();
                Board.this.repaint(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
            }
        }

        public void mouseDragged(MouseEvent inEvent) {
            if (NO_CLICKED == this.mClickedPos) {
                return;
            }
            Direction aDirection = this.calcDirection(Board.this.calcPortToBoardPos(inEvent.getX(), inEvent.getY()));
            ModelChangeEvent aEvent = ModelChangeEvent.createSelectionEvent(this.mClickedPos.x, this.mClickedPos.y, aDirection);
            Board.this.mDispatcher.processModelChange(aEvent);
            if (Board.this.mModel.isModified()) {
                Rectangle aBounds = Board.this.getClipBounds();
                Board.this.repaint(aBounds.x, aBounds.y, aBounds.width, aBounds.height);
            }
        }

        public void mouseClicked(MouseEvent inEvent) {
        }

        public void mouseEntered(MouseEvent inEvent) {
        }

        public void mouseExited(MouseEvent inEvent) {
        }

        public void mouseMoved(MouseEvent inEvent) {
        }

        private Direction calcDirection(Point inToPos) {
            if (this.mClickedPos.equals(inToPos)) {
                return Direction.NO;
            }
            if (inToPos.x == this.mClickedPos.x) {
                if (inToPos.y > this.mClickedPos.y) {
                    return Direction.SOUTH;
                }
                return Direction.NORTH;
            }
            if (inToPos.y == this.mClickedPos.y) {
                if (inToPos.x > this.mClickedPos.x) {
                    return Direction.EAST;
                }
                return Direction.WEST;
            }
            return Direction.NO;
        }
    }
}

