/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.JiBXException;

public abstract class BindingDirectory {
    public static final String BINDINGLIST_NAME = "JiBX_bindingList";
    public static final String BINDINGFACTORY_PREFIX = "JiBX_";
    public static final String BINDINGFACTORY_SUFFIX = "Factory";
    public static final String FACTORY_INSTMETHOD = "getInstance";
    public static final Class[] EMPTY_ARGS = new Class[0];

    private static IBindingFactory getFactoryFromName(String name, Class clas) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> factory = clas.getClassLoader().loadClass(name);
        Method method = factory.getMethod(FACTORY_INSTMETHOD, EMPTY_ARGS);
        return (IBindingFactory)method.invoke(null, null);
    }

    public static IBindingFactory getFactory(String name, Class clas) throws JiBXException {
        try {
            Field field = clas.getDeclaredField(BINDINGLIST_NAME);
            try {
                field.setAccessible(true);
            }
            catch (Exception ex) {
                // empty catch block
            }
            String list = (String)field.get(null);
            String match = BINDINGFACTORY_PREFIX + name + BINDINGFACTORY_SUFFIX + '|';
            int index = list.indexOf(match);
            if (index >= 0) {
                int mark = list.lastIndexOf(124, index);
                String fact = list.substring(mark + 1, index + match.length() - 1);
                return BindingDirectory.getFactoryFromName(fact, clas);
            }
        }
        catch (Exception ex) {
            throw new JiBXException("Unable to access binding information for class " + clas.getName(), ex);
        }
        throw new JiBXException("Binding " + name + " not found for class " + clas.getName());
    }

    public static IBindingFactory getFactory(Class clas) throws JiBXException {
        try {
            String fact;
            Field field = clas.getDeclaredField(BINDINGLIST_NAME);
            try {
                field.setAccessible(true);
            }
            catch (Exception ex) {
                // empty catch block
            }
            String list = (String)field.get(null);
            if (list != null && list.length() > 2 && (fact = list.substring(1, list.length() - 1)).indexOf(124) < 0) {
                return BindingDirectory.getFactoryFromName(fact, clas);
            }
        }
        catch (Exception ex) {
            throw new JiBXException("Unable to access binding information for class " + clas.getName(), ex);
        }
        throw new JiBXException("Multiple bindings defined for class " + clas.getName());
    }
}

