/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.fsm;

import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.AbstractState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.ColorState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.DefaultColorState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.NumberState;

public class HashikakeNumberState
implements State {
    private State mNumberState;
    private AdjacentState[] mAdjacent;
    private State mColorState = new DefaultColorState();

    public HashikakeNumberState(State inState, State inAdjacent) {
        if (!(inState instanceof NumberState)) {
            throw new IllegalArgumentException("A specifiying state should be NumberState(passed state : " + inState.getClass() + ")");
        }
        this.mNumberState = inState;
        this.mAdjacent = new AdjacentState[]{new AdjacentState(inAdjacent, Direction.NORTH), new AdjacentState(inAdjacent, Direction.SOUTH), new AdjacentState(inAdjacent, Direction.WEST), new AdjacentState(inAdjacent, Direction.EAST)};
    }

    public State getNumberState() {
        return this.mNumberState;
    }

    public AdjacentState getAdjacentAt(int inIndex) {
        return this.mAdjacent[inIndex];
    }

    public AdjacentState findAdjacentOf(Direction inDirection) {
        for (int i = 0; i < this.mAdjacent.length; ++i) {
            if (this.mAdjacent[i].getDirection() != inDirection) continue;
            return this.mAdjacent[i];
        }
        return null;
    }

    public int getAdjacentCount() {
        return this.mAdjacent.length;
    }

    public void setColorState(ColorState inState) {
        this.mColorState = inState;
    }

    public State getColorState() {
        return this.mColorState;
    }

    public State onEnter(StateEventCode inEvent) {
        return this;
    }

    public static class AdjacentState
    extends AbstractState {
        private State mState;
        private Direction mDirection;

        public AdjacentState(State inState, Direction inDirection) {
            this.mState = inState;
            this.mDirection = inDirection;
        }

        public State getState() {
            return this.mState;
        }

        public void setState(State inState) {
            this.mState = inState;
        }

        public Direction getDirection() {
            return this.mDirection;
        }
    }
}

