/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.util;

import java.util.HashMap;
import java.util.Map;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;

class DirectionStateEventCode
implements StateEventCode {
    private static final int TYPE_ILLEGAL = Integer.MIN_VALUE;
    private static final int TYPE_SELECT = 0;
    private static final int TYPE_DETERMINE = 1;
    private static Map sSelectDirMap;
    private static Map sDetermineDirMap;
    private static final DirectionStateEventCode ILLEGAL_CODE;
    private Direction mDirection;
    private int mType;

    public static StateEventCode createSelectDirectionCode(Direction inDirection) {
        if (sSelectDirMap.containsKey(inDirection.getName())) {
            return (StateEventCode)sSelectDirMap.get(inDirection.getName());
        }
        return ILLEGAL_CODE;
    }

    public static StateEventCode createDetermineDirectionCode(Direction inDirection) {
        if (sDetermineDirMap.containsKey(inDirection.getName())) {
            return (StateEventCode)sDetermineDirMap.get(inDirection.getName());
        }
        return ILLEGAL_CODE;
    }

    public static boolean isDeterminationType(DirectionStateEventCode inEventCode) {
        return inEventCode.mType == 1;
    }

    public static boolean isSelectionType(DirectionStateEventCode inEventCode) {
        return inEventCode.mType == 0;
    }

    private DirectionStateEventCode(Direction inDirection, int inType) {
        this.mDirection = inDirection;
        this.mType = inType;
    }

    public Direction getDirection() {
        return this.mDirection;
    }

    public String getValue() {
        return this.mDirection.getName();
    }

    static {
        TYPE_ILLEGAL = Integer.MIN_VALUE;
        TYPE_SELECT = 0;
        TYPE_DETERMINE = 1;
        sSelectDirMap = new HashMap();
        sDetermineDirMap = new HashMap();
        sSelectDirMap.put(Direction.NORTH.getName(), new DirectionStateEventCode(Direction.NORTH, 0));
        sSelectDirMap.put(Direction.SOUTH.getName(), new DirectionStateEventCode(Direction.SOUTH, 0));
        sSelectDirMap.put(Direction.EAST.getName(), new DirectionStateEventCode(Direction.EAST, 0));
        sSelectDirMap.put(Direction.WEST.getName(), new DirectionStateEventCode(Direction.WEST, 0));
        sSelectDirMap.put(Direction.NO.getName(), new DirectionStateEventCode(Direction.NO, 0));
        sDetermineDirMap.put(Direction.NORTH.getName(), new DirectionStateEventCode(Direction.NORTH, 1));
        sDetermineDirMap.put(Direction.SOUTH.getName(), new DirectionStateEventCode(Direction.SOUTH, 1));
        sDetermineDirMap.put(Direction.EAST.getName(), new DirectionStateEventCode(Direction.EAST, 1));
        sDetermineDirMap.put(Direction.WEST.getName(), new DirectionStateEventCode(Direction.WEST, 1));
        sDetermineDirMap.put(Direction.NO.getName(), new DirectionStateEventCode(Direction.NO, 1));
        ILLEGAL_CODE = new DirectionStateEventCode(Direction.NO, Integer.MIN_VALUE);
    }
}

