/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.util;

import java.awt.Point;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.DirectionStateEventCode;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.HashikakeStateEventCode;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.SelectionStateEventCode;

public class UtilityFuncs {
    private static final Direction[] DIRECTIONS = new Direction[]{Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH};

    public static StateEventCode createSpaceCode() {
        return HashikakeStateEventCode.createSpaceCode();
    }

    public static StateEventCode createNumberCodeOf(int inNum) {
        return HashikakeStateEventCode.createNumberCodeOf(inNum);
    }

    public static StateEventCode getSelectDirectionEventCode(Direction inDirection) {
        return DirectionStateEventCode.createSelectDirectionCode(inDirection);
    }

    public static StateEventCode getDetermineDirectionEventCode(Direction inDirection) {
        return DirectionStateEventCode.createDetermineDirectionCode(inDirection);
    }

    public static boolean isSelectionType(StateEventCode inEventCode) {
        if (inEventCode instanceof DirectionStateEventCode) {
            return DirectionStateEventCode.isSelectionType((DirectionStateEventCode)inEventCode);
        }
        return false;
    }

    public static boolean isDeterminationType(StateEventCode inEventCode) {
        if (inEventCode instanceof DirectionStateEventCode) {
            return DirectionStateEventCode.isDeterminationType((DirectionStateEventCode)inEventCode);
        }
        return false;
    }

    public static StateEventCode getSelectionEventCode() {
        return SelectionStateEventCode.getInstance();
    }

    public static Direction resolveDirectionOf(int inKeyCode) {
        if (inKeyCode == 37) {
            return Direction.WEST;
        }
        if (inKeyCode == 39) {
            return Direction.EAST;
        }
        if (inKeyCode == 38) {
            return Direction.NORTH;
        }
        if (inKeyCode == 40) {
            return Direction.SOUTH;
        }
        return Direction.NO;
    }

    public static Direction resolveDirectionOf(StateEventCode inEventCode) {
        if (inEventCode instanceof DirectionStateEventCode) {
            return ((DirectionStateEventCode)inEventCode).getDirection();
        }
        return Direction.NO;
    }

    public static Direction inverseDirection(Direction inDirection) {
        if (Direction.WEST == inDirection) {
            return Direction.EAST;
        }
        if (Direction.EAST == inDirection) {
            return Direction.WEST;
        }
        if (Direction.NORTH == inDirection) {
            return Direction.SOUTH;
        }
        if (Direction.SOUTH == inDirection) {
            return Direction.NORTH;
        }
        if (Direction.NORTH_WEST == inDirection) {
            return Direction.SOUTH_EAST;
        }
        if (Direction.NORTH_EAST == inDirection) {
            return Direction.SOUTH_WEST;
        }
        if (Direction.SOUTH_WEST == inDirection) {
            return Direction.NORTH_EAST;
        }
        if (Direction.SOUTH_EAST == inDirection) {
            return Direction.NORTH_WEST;
        }
        return Direction.NO;
    }

    public static Direction[] getUnitDirection(Direction inDirection) {
        Direction[] aUnit = new Direction[]{Direction.NO, Direction.NO};
        Point aDiff = inDirection.getDifference();
        for (int i = 0; i < DIRECTIONS.length; ++i) {
            Point aUnitDiff = DIRECTIONS[i].getDifference();
            if (aDiff.x != 0 && aDiff.x == aUnitDiff.x) {
                aUnit[0] = DIRECTIONS[i];
            }
            if (aDiff.y == 0 || aDiff.y != aUnitDiff.y) continue;
            aUnit[1] = DIRECTIONS[i];
        }
        return aUnit;
    }
}

