/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.creator.model;

import java.awt.Point;
import java.util.HashSet;
import jp.gr.java_conf.ktz.puzzle.framework.AbstractDecoratedModel;
import jp.gr.java_conf.ktz.puzzle.framework.ModelConstants;
import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;

public class CellActivationModel
extends AbstractDecoratedModel {
    private static Point EMPTY_POS = ModelConstants.ILLEGAL_POS;
    private Point mActivePos = EMPTY_POS;
    private Point mReleasePos = EMPTY_POS;
    private boolean mIsModified = false;

    protected boolean isAcceptableEvent(StateEventCode inEvent) {
        return inEvent == UtilityFuncs.getSelectionEventCode();
    }

    protected void createBoardSelf(int inWidth, int inHeight) {
    }

    protected void resetAtSelf(int inX, int inY) {
    }

    protected void nextStateAtSelf(int inX, int inY, StateEventCode inCode) {
        if (!this.contains(this.mActivePos.x + inX, this.mActivePos.y + inY)) {
            return;
        }
        this.mActivePos = new Point(this.mActivePos);
        this.mActivePos.translate(inX, inY);
        this.mIsModified = true;
    }

    public void nextStateAt(int inX, int inY) {
        super.nextStateAt(inX, inY);
        if (!this.contains(inX, inY)) {
            return;
        }
        Point aPos = new Point(inX, inY);
        if (aPos.equals(this.mActivePos)) {
            return;
        }
        this.mActivePos = aPos;
        this.mIsModified = true;
    }

    protected void prevStateAtSelf(int inX, int inY, StateEventCode inCode) {
    }

    public State getCurStateAt(int inX, int inY) {
        State aState = super.getCurStateAt(inX, inY);
        if (inX == this.mActivePos.x && inY == this.mActivePos.y) {
            aState = StateManager.getInstance().getNextState(aState, UtilityFuncs.getSelectionEventCode());
        }
        return aState;
    }

    protected Point[] lastModifiedSelf() {
        HashSet<Point> aSet = new HashSet<Point>();
        if (EMPTY_POS != this.mActivePos) {
            aSet.add(this.mActivePos);
        }
        if (EMPTY_POS != this.mReleasePos) {
            aSet.add(this.mReleasePos);
        }
        return aSet.toArray(new Point[aSet.size()]);
    }

    protected boolean isModifiedSelf() {
        return this.mIsModified;
    }

    protected void flushSelf() {
        this.mReleasePos = this.mActivePos;
        this.mIsModified = false;
    }
}

