/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.creator.model;

import java.awt.Dimension;
import java.awt.Point;
import java.util.HashSet;
import java.util.Set;
import jp.gr.java_conf.ktz.puzzle.framework.AbstractDecoratedModel;
import jp.gr.java_conf.ktz.puzzle.framework.ModelConstants;
import jp.gr.java_conf.ktz.puzzle.framework.ModelState;
import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;
import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.StateManager;
import jp.gr.java_conf.ktz.puzzle.hashikake.constants.Direction;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.HashikakeStateEventCode;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.ModelStateUtility;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;

public class CreatorBoardModel
extends AbstractDecoratedModel {
    private static final Point[] NO_MODIFIED = ModelConstants.EMPTIES;
    private static final Direction[] DIRECTIONS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    private static final ModelState DEFAULT_MODEL_STATE = new ModelState(){};
    private Cell[] mCells;
    private int mWidth;
    private int mHeight;
    private Set mLastModified = new HashSet();
    private ModelState mModelState;

    protected void createBoardSelf(int inWidth, int inHeight) {
        this.mWidth = inWidth;
        this.mHeight = inHeight;
        this.mCells = new Cell[inWidth * inHeight];
        for (int y = 0; y < this.mHeight; ++y) {
            for (int x = 0; x < this.mWidth; ++x) {
                this.mCells[this.toIndex((int)x, (int)y)] = new Cell();
                this.mLastModified.add(new Point(x, y));
            }
        }
    }

    private int toIndex(int inX, int inY) {
        return inY * this.mWidth + inX;
    }

    public int setProblem(ProblemInfo inProblem) {
        if (this.mWidth != inProblem.getWidth() || this.mHeight != inProblem.getHeight()) {
            this.createBoard(inProblem.getWidth(), inProblem.getHeight());
        }
        StateManager aManager = StateManager.getInstance();
        int i = 0;
        for (int y = 0; y < this.mHeight; ++y) {
            for (int x = 0; x < this.mWidth; ++x) {
                StateEventCode aCode = null;
                try {
                    int aNum = Integer.parseInt((String)inProblem.getRecordAt(i++));
                    aCode = UtilityFuncs.createNumberCodeOf(aNum);
                }
                catch (NumberFormatException e) {
                    aCode = UtilityFuncs.createSpaceCode();
                }
                Cell aCell = this.getCellAt(x, y);
                State aState = aManager.getNextState(aCell.getCurState(), aCode);
                aCell.setCurState(aState);
                this.mLastModified.add(new Point(x, y));
            }
        }
        return this.mCells.length;
    }

    public boolean check() {
        return false;
    }

    public void reset() {
        if (!this.acceptableModelState(this.mModelState)) {
            return;
        }
        for (int y = 0; y < this.mHeight; ++y) {
            for (int x = 0; x < this.mWidth; ++x) {
                if (ModelStateUtility.isClearAllState(this.mModelState)) {
                    this.resetAtSelf(x, y);
                    continue;
                }
                this.resetSolvedStateAt(x, y);
            }
        }
    }

    protected void resetAtSelf(int inX, int inY) {
        if (!this.isSpaceAt(inX, inY)) {
            this.getCellAt(inX, inY).reset();
            this.mLastModified.add(new Point(inX, inY));
        }
    }

    protected boolean acceptableModelState(ModelState inState) {
        return ModelStateUtility.isClearAllState(inState) || ModelStateUtility.isAcceptSolverModelState(inState);
    }

    private void resetSolvedStateAt(int inX, int inY) {
        if (this.isNumberAt(inX, inY)) {
            Cell aCell = this.getCellAt(inX, inY);
            State aState = aCell.getCurState();
            StateManager aManager = StateManager.getInstance();
            String aID = aManager.findIdentityOf(aState);
            StateEventCode aCode = HashikakeStateEventCode.createNumberCodeOf(aID);
            aState = aManager.getNextState(aCell.getCurState(), aCode);
            aCell.setCurState(aState);
            this.mLastModified.add(new Point(inX, inY));
        } else {
            this.resetAt(inX, inY);
        }
    }

    protected void setModelStateSelf(ModelState inState) {
        this.mModelState = inState;
    }

    public Dimension getSize() {
        return new Dimension(this.mWidth, this.mHeight);
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public State getCurStateAt(int inX, int inY) {
        return this.getCellAt(inX, inY).getCurState();
    }

    public State getCorrectStateAt(int inX, int inY) {
        throw new UnsupportedOperationException();
    }

    public boolean isAcceptableEvent(StateEventCode inCode) {
        if (UtilityFuncs.isDeterminationType(inCode)) {
            return true;
        }
        if (inCode == HashikakeStateEventCode.createSpaceCode()) {
            return true;
        }
        try {
            int aVal = Integer.parseInt(inCode.getValue());
            if (aVal > 0 && aVal < 9) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    public void nextStateAt(int inX, int inY) {
    }

    protected void nextStateAtSelf(int inX, int inY, StateEventCode inCode) {
        if (!this.contains(inX, inY)) {
            return;
        }
        if (!this.isTransitAt(inX, inY, inCode)) {
            return;
        }
        Cell aCell = this.getCellAt(inX, inY);
        State aState = StateManager.getInstance().getNextState(aCell.getCurState(), inCode);
        aCell.setCurState(aState);
        this.mLastModified.add(new Point(inX, inY));
    }

    public void prevStateAt(int inX, int inY) {
    }

    protected void prevStateAtSelf(int inX, int inY, StateEventCode inCode) {
        if (!this.contains(inX, inY)) {
            return;
        }
        if (!this.isTransitAt(inX, inY, inCode)) {
            return;
        }
        State aState = this.getCurStateAt(inX, inY);
        aState = StateManager.getInstance().getPrevState(aState, inCode);
        this.getCellAt(inX, inY).setCurState(aState);
        this.mLastModified.add(new Point(inX, inY));
    }

    private boolean checkSpaceForNeighborAt(int inX, int inY) {
        StateManager aManager = StateManager.getInstance();
        for (int i = 0; i < DIRECTIONS.length; ++i) {
            Point aPos = new Point(inX, inY);
            Point aDiff = DIRECTIONS[i].getDifference();
            aPos.translate(aDiff.x, aDiff.y);
            if (!this.isNumberAt(aPos.x, aPos.y)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(int inX, int inY) {
        return inX < this.mWidth && inX >= 0 && inY < this.mHeight && inY >= 0;
    }

    private Cell getCellAt(int inX, int inY) {
        if (inX > this.mWidth || inX < 0 || inY > this.mHeight || inY < 0) {
            throw new IllegalArgumentException("Must be 0 <= inX < " + this.mWidth + ", 0 <= inY < " + this.mHeight + " (was inX = " + inX + ", inY = " + inY + ")");
        }
        return this.mCells[this.toIndex(inX, inY)];
    }

    public boolean isNumberAt(int inX, int inY) {
        if (!this.contains(inX, inY)) {
            return false;
        }
        return this.getCellAt(inX, inY).isNumber();
    }

    public boolean isSpaceAt(int inX, int inY) {
        if (!this.contains(inX, inY)) {
            return false;
        }
        return this.getCellAt(inX, inY).isSpace();
    }

    public boolean isTransitAt(int inX, int inY) {
        return false;
    }

    public boolean isTransitAt(int inX, int inY, StateEventCode inCode) {
        Cell aCell = this.getCellAt(inX, inY);
        if (inCode == HashikakeStateEventCode.createSpaceCode()) {
            return aCell.isNumber();
        }
        if (UtilityFuncs.isDeterminationType(inCode)) {
            State aState = aCell.getCurState();
            return StateManager.getInstance().isTransit(aState, inCode);
        }
        return this.checkSpaceForNeighborAt(inX, inY);
    }

    protected Point[] lastModifiedSelf() {
        return this.mLastModified.toArray(new Point[this.mLastModified.size()]);
    }

    protected boolean isModifiedSelf() {
        return this.mLastModified.size() > 0;
    }

    protected void flushSelf() {
        this.mLastModified.clear();
        this.mLastModified = new HashSet();
    }

    private static class Cell {
        State mState;

        Cell() {
            this.reset();
        }

        void reset() {
            this.mState = StateManager.getInstance().createDefaultState();
        }

        boolean isSpace() {
            return StateManager.getInstance().isSpaceState(this.mState);
        }

        boolean isNumber() {
            return StateManager.getInstance().isNumberState(this.mState);
        }

        State getCurState() {
            return this.mState;
        }

        void setCurState(State inState) {
            this.mState = inState;
        }

        void setCurState(String inStateID) {
            this.mState = StateManager.getInstance().createStateOf(inStateID);
        }
    }
}

