/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.creator.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jp.gr.java_conf.ktz.puzzle.framework.DecoratedStateManagerImpl;
import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.StateManagerImpl;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.BranchState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.HashikakeNumberState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.NumberState;
import jp.gr.java_conf.ktz.puzzle.hashikake.fsm.SpaceState;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.HashikakeStateEventCode;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.UtilityFuncs;

public class HashiCreStateManagerImpl
extends DecoratedStateManagerImpl {
    public static final String SPACE_ID = "s";
    private Map mStateMap = new HashMap();
    private State mTransit;

    public HashiCreStateManagerImpl() {
        this(null);
    }

    public HashiCreStateManagerImpl(StateManagerImpl inManager) {
        super(inManager);
        this.initTable();
    }

    private void initTable() {
        State[] aStates = new State[]{SpaceState.getInstance(), new NumberState(1), new NumberState(2), new NumberState(3), new NumberState(4), new NumberState(5), new NumberState(6), new NumberState(7), new NumberState(8)};
        BranchState.TransitHint[] aHint = new BranchState.TransitHint[aStates.length];
        this.mStateMap.put(SPACE_ID, aStates[0]);
        aHint[0] = new BranchState.TransitHint(aStates[0], new StateEventCode[]{UtilityFuncs.createSpaceCode()});
        for (int i = 1; i < aStates.length; ++i) {
            String aStr = String.valueOf(i);
            this.mStateMap.put(aStr, aStates[i]);
            aHint[i] = new BranchState.TransitHint(aStates[i], new StateEventCode[]{UtilityFuncs.createNumberCodeOf(i)});
        }
        this.mTransit = new BranchState(aHint);
    }

    protected State createStateOfSelf(String inStateID) {
        if (!this.mStateMap.containsKey(inStateID)) {
            throw new IllegalArgumentException("The inStateID : " + inStateID + " is illegal.");
        }
        return (State)this.mStateMap.get(inStateID);
    }

    protected State createDefaultStateSelf() {
        return this.createStateOfSelf(SPACE_ID);
    }

    protected String findIdentityOfSelf(State inState) {
        Iterator aIt = this.mStateMap.entrySet().iterator();
        while (aIt.hasNext()) {
            Map.Entry aEntry = aIt.next();
            if (!aEntry.getValue().equals(inState)) continue;
            return (String)aEntry.getKey();
        }
        return SPACE_ID;
    }

    protected State dewrapState(State inState) {
        if (inState instanceof HashikakeNumberState) {
            return ((HashikakeNumberState)inState).getNumberState();
        }
        return inState;
    }

    protected State getNextStateSelf(State inState) {
        throw new UnsupportedOperationException("getNextStateSelf(State) method is not supported.");
    }

    protected State getNextStateSelf(State inState, StateEventCode inEvent) {
        return this.getTransitedState(inState, inEvent);
    }

    protected State getPrevStateSelf(State inState) {
        throw new UnsupportedOperationException("getPrevStateSelf(State) method is not supported.");
    }

    protected State getPrevStateSelf(State inState, StateEventCode inEvent) {
        return this.getTransitedState(inState, inEvent);
    }

    private State getTransitedState(State inState, StateEventCode inEvent) {
        State aState = this.mTransit.onEnter(inEvent);
        if (!this.isSpaceStateSelf(aState)) {
            aState = new HashikakeNumberState((NumberState)aState, this.createDefaultState());
        }
        return aState;
    }

    protected boolean isNumberStateSelf(State inState) {
        return inState instanceof HashikakeNumberState;
    }

    protected boolean isSpaceStateSelf(State inState) {
        return inState instanceof SpaceState;
    }

    protected boolean isTransitSelf(State inState) {
        throw new UnsupportedOperationException("isTransitSelf(State) method is not supported.");
    }

    protected boolean isTransitSelf(State inState, StateEventCode inEvent) {
        State aState = null;
        try {
            aState = this.mTransit.onEnter(inEvent);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return aState != inState;
    }

    protected boolean acceptableEventCode(StateEventCode inEvent) {
        return inEvent instanceof HashikakeStateEventCode;
    }
}

