/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.ktz.puzzle.hashikake.creator.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.view.PositiveIntFormatter;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.view.ValidDocumentat;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.view.command.ResizeCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.view.command.ResizeResultCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.Command;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.PropertyBundle;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.AWTDispatchCommandQueue;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.BoardView;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.CommandContainer;

public class SizeChangeDialog
extends JFrame
implements CommandContainer {
    private BoardView mOwnerFrame;
    private JTextField mWidthField;
    private JTextField mHeightField;
    static /* synthetic */ Class class$jp$gr$java_conf$ktz$puzzle$hashikake$creator$view$command$ResizeResultCommand;

    public static void showDialog(final BoardView inOwner) {
        if (EventQueue.isDispatchThread()) {
            SizeChangeDialog aDialog = new SizeChangeDialog();
            aDialog.initialize(inOwner);
            aDialog.show();
        } else {
            Runnable aAction = new Runnable(){

                public void run() {
                    SizeChangeDialog.showDialog(inOwner);
                }
            };
            EventQueue.invokeLater(aAction);
        }
    }

    public void initialize(BoardView inOwner) {
        this.mOwnerFrame = inOwner;
        AWTDispatchCommandQueue.postCommand(new ResizeCommand(this.mOwnerFrame, this));
    }

    protected void frameInit() {
        super.frameInit();
        String aI18NName = PropertyBundle.getInstance().getString("resize_dialog_title");
        this.setTitle(aI18NName);
        Container aPane = this.getContentPane();
        JPanel aPanel = new JPanel(new GridLayout(2, 2));
        aPane.add((Component)aPanel, "Center");
        aI18NName = PropertyBundle.getInstance().getString("width :");
        aPanel.add(new JLabel(aI18NName, 4));
        this.mWidthField = new JTextField();
        this.mWidthField.setDocument(new ValidDocumentat(new PositiveIntFormatter(2)));
        class FocusHandler
        implements FocusListener {
            FocusHandler() {
            }

            public void focusGained(FocusEvent inEvent) {
                JTextField aField = (JTextField)inEvent.getSource();
                aField.selectAll();
            }

            public void focusLost(FocusEvent inEvent) {
            }
        }
        this.mWidthField.addFocusListener(new FocusHandler());
        class ApproveHandler
        implements KeyListener {
            ApproveHandler() {
            }

            public void keyPressed(KeyEvent inEvent) {
                int aPressedKey = inEvent.getKeyCode();
                switch (aPressedKey) {
                    case 27: {
                        SizeChangeDialog.this.cancelAction();
                        break;
                    }
                    case 10: {
                        SizeChangeDialog.this.approveAction();
                    }
                }
            }

            public void keyReleased(KeyEvent inEvent) {
            }

            public void keyTyped(KeyEvent inEvent) {
            }
        }
        this.mWidthField.addKeyListener(new ApproveHandler());
        aPanel.add(this.mWidthField);
        aI18NName = PropertyBundle.getInstance().getString("height :");
        aPanel.add(new JLabel(aI18NName, 4));
        this.mHeightField = new JTextField();
        this.mHeightField.setDocument(new ValidDocumentat(new PositiveIntFormatter(2)));
        this.mHeightField.addFocusListener(new FocusHandler());
        this.mHeightField.addKeyListener(new ApproveHandler());
        aPanel.add(this.mHeightField);
        aPanel = new JPanel();
        aPane.add((Component)aPanel, "South");
        aI18NName = PropertyBundle.getInstance().getString("OK");
        JButton aButton = new JButton(aI18NName);
        aPanel.add(aButton);
        aButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent inEvent) {
                SizeChangeDialog.this.approveAction();
            }
        });
        aButton.addKeyListener(new ApproveHandler());
        aI18NName = PropertyBundle.getInstance().getString("Cancel");
        aButton = new JButton(aI18NName);
        aPanel.add(aButton);
        aButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent inEvent) {
                SizeChangeDialog.this.cancelAction();
            }
        });
        class CancelHandler
        implements KeyListener {
            CancelHandler() {
            }

            public void keyPressed(KeyEvent inEvent) {
                int aPressedKey = inEvent.getKeyCode();
                switch (aPressedKey) {
                    case 27: {
                        SizeChangeDialog.this.cancelAction();
                        break;
                    }
                    case 10: {
                        SizeChangeDialog.this.cancelAction();
                    }
                }
            }

            public void keyReleased(KeyEvent inEvent) {
            }

            public void keyTyped(KeyEvent inEvent) {
            }
        }
        aButton.addKeyListener(new CancelHandler());
        this.pack();
    }

    private void approveAction() {
        try {
            int aWidth = Integer.parseInt(this.mWidthField.getText());
            int aHeight = Integer.parseInt(this.mHeightField.getText());
            ResizeResultCommand aCommand = new ResizeResultCommand(this.mOwnerFrame, aWidth, aHeight);
            AWTDispatchCommandQueue.postCommand(aCommand);
            this.dispose();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void cancelAction() {
        this.dispose();
    }

    public void processCommand(Command inCommand) {
        Class<?> aClass = inCommand.getClass();
        if (aClass == (class$jp$gr$java_conf$ktz$puzzle$hashikake$creator$view$command$ResizeResultCommand == null ? (class$jp$gr$java_conf$ktz$puzzle$hashikake$creator$view$command$ResizeResultCommand = SizeChangeDialog.class$("jp.gr.java_conf.ktz.puzzle.hashikake.creator.view.command.ResizeResultCommand")) : class$jp$gr$java_conf$ktz$puzzle$hashikake$creator$view$command$ResizeResultCommand)) {
            int aWidth = ((ResizeResultCommand)inCommand).getWidth();
            int aHeight = ((ResizeResultCommand)inCommand).getHeight();
            this.mWidthField.setText(String.valueOf(aWidth));
            this.mHeightField.setText(String.valueOf(aHeight));
        }
    }

    private SizeChangeDialog() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

