// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		HashiCreatorRoot.java 
//	DATE:		2003.6.16	initial version
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.creator.view;

import java.awt.Component;
import java.awt.Frame;

import java.awt.event.WindowListener;
import java.awt.event.WindowEvent;

import java.io.File;

import jp.gr.java_conf.ktz.puzzle.hashikake.view.BoardContainer;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.RootBoardContainer;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.AWTDispatchCommandQueue;

import jp.gr.java_conf.ktz.puzzle.hashikake.constants.CreatorMenuID;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.marshal.SaveCanceledException;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.GUIUtility;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.TerminateManager;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.OpenProblemDialog;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.MenuManager;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.ComponentUsher;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.Command;

import jp.gr.java_conf.ktz.puzzle.hashikake.command.NewCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.command.BoardSizeCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.command.LoadSelectCommand;

import jp.gr.java_conf.ktz.puzzle.hashikake.creator.view.command.ResizeResultCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.creator.view.command.SaveIssueCommand;

/**
 *	FrameAroot viewKw
 */
public class HashiCreatorRoot extends RootBoardContainer {
	/** ftHg̔Ֆʂ̕ */
	private static final int DEFAULT_BOARD_WIDTH = 9;

	/** ftHg̔Ֆʂ̍ */
	private static final int DEFAULT_BOARD_HEIGHT = 9;
	
	/** ^Cg */
	static final String INITIAL_TITLE = GUIUtility.INITIAL_TITLE;
	
	/** vO */
	static final String APP_NAME = "hashicreator";
	
	public static RootBoardContainer showRootBoard() {
		RootBoardContainer aRoot = createRootBard();
		
		// TCYύX˗
		ResizeResultCommand aCommand
			 = new ResizeResultCommand(aRoot, DEFAULT_BOARD_WIDTH, DEFAULT_BOARD_WIDTH);
		AWTDispatchCommandQueue.postCommand(aCommand);
		
		aRoot.show();
		
		return aRoot;
	}
	
	private static RootBoardContainer createRootBard() {
		RootBoardContainer aRoot
			 = new HashiCreatorRoot(new java.awt.Frame());
		aRoot.initialize();
		
		return aRoot;
	}	
	
	private HashiCreatorRoot(Frame inComponent) {
		super(inComponent);
	}
	
	/**
	 *	̃R|[lg
	 */
	 
	protected void initializeSelf() {
		// ^Cg̎w
		setTitle(INITIAL_TITLE);
		
		Frame aComponent = (Frame)getComponent();
		
		// j[̍\z
		java.awt.MenuBar aMenuBar = MenuManager.createMenuManager(this);
		aComponent.setMenuBar(aMenuBar);
		
		// Menu itemdimĂ
		MenuManager.currentMenuManager(this).setEnabledFor(CreatorMenuID.ITEM_SAVE, false);
		MenuManager.currentMenuManager(this).setEnabledFor(CreatorMenuID.ITEM_CLEAR, false);
		
		// ComponentUsherɓo^
		ComponentUsher.getInstance().install(this);	
		
		// Component Tree̍\z
		java.awt.ScrollPane aScroller = new java.awt.ScrollPane(java.awt.ScrollPane.SCROLLBARS_ALWAYS);
		BoardContainer aContainer = new BoardScroller(aScroller);
		addBoard(aContainer);
		
		// ̃vOł́Aۑ\Ƃ
		setMarshalAware();
	}

	/**
	 *	^CgƂăZbg镶ɏC
	 *
	 *	@param inOldTitle CO̕
	 *	@return	C̕
	 */
	protected String modifiyTitleString(String inOldTitle) {
		return inOldTitle  + " - " + APP_NAME;
	}

	/**
	 *	Command̎
	 *
	 *	@param	inCommand	Command
	 */
	protected void processCommandImpl(Command inCommand) {
		final Class aClass = inCommand.getClass();
		
		if (aClass == BoardSizeCommand.class) {
			final int aWidth = ((BoardSizeCommand)inCommand).getComponentWidth();
			final int aHeight = ((BoardSizeCommand)inCommand).getComponentHeight();
			
			setComponentSize(aWidth, aHeight);
			inCommand.consume();
		}
		else if (aClass == NewCommand.class) {
			HashiCreatorRoot.showRootBoard();		
			inCommand.consume();
		}
		else if (aClass == SaveIssueCommand.class) {
			try {
				if (((SaveIssueCommand)inCommand).isSaveAs()) {
					saveProblemAs();
				}
				else {
					// t@C̎擾
					String aFileName = parseTitleToFileName(getTitle());
					
					String aExt = ".xml";				
					// gqA".xml" ĂȂꍇA̎ł̓t@C̍Ō ".xml" ǉ
					if (aFileName.length() != aFileName.toLowerCase().lastIndexOf(aExt) + aExt.length()) {
						aFileName += aExt;
					}
				
					saveProblem(new java.io.File(aFileName));
				}
			}
			catch(SaveCanceledException e) {
				System.out.println(e);
			}	
			
			inCommand.consume();		
		}
		else if (aClass == LoadSelectCommand.class) {
			// ՖʂɕύXĂƂ́AVKFrame쐬
			RootBoardContainer aRoot = this;
			
			if (isModified()) {
				aRoot = createRootBard();
			}			
			OpenProblemDialog.showLoadDialog(aRoot);	
		}
	}
	
	protected String parseTitleToFileName(String inTitle) {
		String aFileName = INITIAL_TITLE;
		String aTitle = inTitle;
		
		final int aIndex
				 = aTitle.lastIndexOf(" - " + APP_NAME);
		if (0 < aIndex) {
			aFileName = aTitle.substring(0, aIndex);
		}	
		
		return aFileName;
	}
}