// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or 
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		HashiSolverRoot.java 
//	DATE:		2003.7.15	initial version
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.solver.view;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Button;
import java.awt.BorderLayout;
import java.awt.FlowLayout;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import java.io.File;

import jp.gr.java_conf.ktz.puzzle.framework.ProblemInfo;

import jp.gr.java_conf.ktz.puzzle.hashikake.view.BoardContainer;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.RootBoardContainer;
import jp.gr.java_conf.ktz.puzzle.hashikake.view.AWTDispatchCommandQueue;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.Command;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.marshal.SaveCanceledException;

import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.GUIUtility;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.OpenProblemDialog;
import jp.gr.java_conf.ktz.puzzle.hashikake.util.gui.ComponentUsher;

import jp.gr.java_conf.ktz.puzzle.hashikake.command.BoardSizeCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.command.ResetCommand;

import jp.gr.java_conf.ktz.puzzle.hashikake.solver.view.command.NextCommand;
import jp.gr.java_conf.ktz.puzzle.hashikake.solver.view.command.NextAllCommand;

import jp.gr.java_conf.ktz.puzzle.hashikake.constants.AppColors;

/**
 *	FrameAroot viewKw
 */
public class HashiSolverRoot extends RootBoardContainer {
	/** application name */
	private static final String APP_NAME = "Hashkake solver";
	
	/**
	 *	Factory method
	 */
	public static RootBoardContainer showRootBoard() {
		RootBoardContainer aRoot = new HashiSolverRoot(new java.awt.Frame());
		aRoot.initialize();
	
		aRoot.show();
		
		return aRoot;
	}
	
	/**
	 *	RXgN^
	 *
	 *	@param	inContainer	wrapawt component
	 */	
	private HashiSolverRoot(Frame inComponent) {
		super(inComponent);
	}
	
	/**
	 *	̃R|[lg
	 */
	protected void initializeSelf() {
		Frame aFrame = (Frame)getComponent();
		
		// ^Cg̎w
		setTitle(APP_NAME);
		
		// Menubar̍쐬
//		aFrame.setMenuBar(MenuDispatcher.createMenu());
		
		// Control Panel̍쐬
		aFrame.add(createControlPanel(), BorderLayout.NORTH);

		// ComponentUsherɓo^
		ComponentUsher.getInstance().install(this);	
		
		// Component Tree̍\z
		java.awt.ScrollPane aScroller = new java.awt.ScrollPane(java.awt.ScrollPane.SCROLLBARS_ALWAYS);
		BoardScroller aContainer = new BoardScroller(aScroller);
		addBoard(aContainer);
		

	}
	
	/**
	 *	Command̎
	 *
	 *	@param	inCommand	Command
	 */
	protected void processCommandImpl(Command inCommand) {
		final Class aClass = inCommand.getClass();
		
		if (aClass == BoardSizeCommand.class) {
			final int aWidth = ((BoardSizeCommand)inCommand).getComponentWidth();
			final int aHeight = ((BoardSizeCommand)inCommand).getComponentHeight();
			
			setComponentSize(aWidth, aHeight);
			inCommand.consume();
		}
	}
	
	/**
	 *	^CgƂăZbg镶ɏC
	 *
	 *	@param inOldTitle CO̕
	 *	@return	C̕
	 */
	protected String modifiyTitleString(String inOldTitle) {
		return inOldTitle  + " - " + APP_NAME;
	}
	
	private java.awt.Panel createControlPanel() {
		java.awt.Panel aPanel = new java.awt.Panel();
		aPanel.setBackground(java.awt.Color.lightGray);
		
		Button aButton;
		
		aButton = new Button("Clear");
		aButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent inEvent) {
				AWTDispatchCommandQueue.postCommand(new ResetCommand(HashiSolverRoot.this));
				getComponent().repaint();
			}
		});
		aPanel.add(aButton, FlowLayout.LEFT);
		
		aButton = new Button("next");
		aButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent inEvent) {
				AWTDispatchCommandQueue.postCommand(new NextCommand(HashiSolverRoot.this));
				getComponent().repaint();
			}
		});
		aPanel.add(aButton, FlowLayout.LEFT);

		aButton = new Button("nextAll");
		aButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent inEvent) {
				AWTDispatchCommandQueue.postCommand(new NextAllCommand(HashiSolverRoot.this));
				getComponent().repaint();
			}
		});
		aPanel.add(aButton, FlowLayout.LEFT);

		aButton = new Button("load");
		aButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent inEvent) {
				OpenProblemDialog.showLoadDialog(HashiSolverRoot.this);
			}
		});
		aPanel.add(aButton, FlowLayout.LEFT);
		
		return aPanel;
	}
}

