// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This program is free software; you can redistribute it and/or
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 
//	NAME:		ComponentUsher.java
//	DATE:		2003.6.12	initial version
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.util.gui;

import java.awt.Component;

import jp.gr.java_conf.ktz.puzzle.hashikake.view.BoardView;

/**	
 *	ANeBuȃt[ǗIuWFNg 
 *
 *	@see	Usherable
 */
public final class ComponentUsher {
	/**	݃ANeBuȃR|[lg */
	private Usherable mActiveComponent = null;
	
	/**	o^ꂽR|[lg̏W */
	private java.util.Map mAllComponents = new java.util.HashMap();
	
	/**
	 * 	̃IuWFNginitialize-on-demand Holder class
	 */
	private static class Holder {
		/**	̃IuWFNg̗B̃CX^X */
		static ComponentUsher sInstance = new ComponentUsher();
	}
	
// ------------------- public interfaces ---------------------- //
	
	/**
	 *	̃IuWFNg̗B̃CX^XԂB
	 *
	 *	@return	̃IuWFNg̗B̃CX^X
	 */
	public static ComponentUsher getInstance() {
		return Holder.sInstance;
	}
	
	/**
	 *	݃ANeBuȃR|[lg擾B
	 *
	 *	@return	ANeBuȃR|[lg
	 */
	public synchronized Usherable getActiveComponent() {
		return mActiveComponent;
	}
	
	/**
	 *	w肳ꂽR|[lgANeBuɂB
	 *
	 *	@param	inComp	ANeBuɂR|[lg
	 */
	public synchronized void setActiveComponent(java.awt.Component inComp) {
		lostFocus(mActiveComponent);
		gainFocus((Usherable)mAllComponents.get(inComp));
	}
	
	/**
	 *	w肳ꂽR|[lgANeBuɂB
	 *	
	 *
	 *	@param	inComp	ANeBuɂR|[lg
	 */
	public synchronized void setActiveComponent(BoardView inComp) {
		lostFocus(mActiveComponent);
		gainFocus((Usherable)inComp);
	}
	
	public synchronized boolean isActiveComponent(Usherable inComp) {
		return (mActiveComponent == inComp);
	}
	
	/**
	 *	activeȃR|[lgfocuslostB
	 *	
	 *
	 *	@param	inComp	ANeBuɂR|[lg
	 */
	public synchronized void setActiveComponent() {
		lostFocus(mActiveComponent);
		mActiveComponent = null;
	}
	
	private void lostFocus(Usherable inComp) {
		if (null != inComp) {
			inComp.setFocus(false);
		}
	}
	
	private void gainFocus(Usherable inComp) {
		if (null != inComp) {
			inComp.setFocus(true);
		}
		mActiveComponent = inComp;
	}
	/**
	 *	ݓo^ĂR|[lg̐𐔂B
	 *
	 *	@return	o^ĂR|[lg
	 */
	public int getComponentCount() {
		return mAllComponents.size();
	}
	
	/**
	 *	ݓo^ĂSR|[lgԂ
	 *
	 *	@return	o^ĂSR|[lg
	 */
	public Usherable[] getAllComponents() {
		Usherable[] aComp = new Usherable[mAllComponents.size()];
		mAllComponents.values().toArray(aComp);
		
		return aComp;
	}
	
	/**
	 *	w肳ꂽR|[lgo^B
	 *
	 *	@param	o^R|[lg
	 */
	public void install(Usherable inComp) {
		if (inComp instanceof BoardView) {
			mAllComponents.put(((BoardView)inComp).getComponent(), inComp);
			setActiveComponent((BoardView)inComp);
		}
		else if (inComp instanceof Component) {
			mAllComponents.put(inComp, inComp);
			setActiveComponent((Component)inComp);
		}
		
	}		

	/**
	 *	w肳ꂽR|[lgjB
	 *
	 *	@param	jR|[lg
	 */
	public void uninstall(Usherable inComp) {
		if (inComp instanceof BoardView) {
			mAllComponents.remove(((BoardView)inComp).getComponent());
		}
		else if (inComp instanceof Component) {
			mAllComponents.remove(inComp);
		}
	}

	/**	
	 *	RXgN^B
	 *	ڍ쐬邱Ƃ͂AgetInstance()\bhĂ 
	 */
	private ComponentUsher() {}
};
