// ***************************************************************************************
//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	modify it under the terms of the GNU General Public License
//	as published by the Free Software Foundation; either version 2
//	of the License, or (at your option) any later version.
//
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//	NAME:		TerminateManager.java
//	DATE:		2003.6.9
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.hashikake.util.gui;

import java.awt.event.WindowEvent;

/**
 *	AvP[V̏IAo^WIndowEvent𔭍sB
 *	ʏAۑ̖蕶ۑ邩ǂq˂悤ɂ邽߁A
 *	event typeWINDOW_CLOSINGłB
 *
 *	[usage]
 *	1) TerminateManager.start()ĂԁB
 *	2) KvȐAWindowEvent쐬ATerminateManager.pushEvent()Ă
 *	3) TerminateManager.waitTermination()ĂсÂ҂B
 *
 *	ILZƂ́ATerminateManager.cancel()KĂԁB
 *
 *	[note!!!]
 *	TerminateManager.waitTermination()̌ĂяóAevent dispatch thredł
 *	sȂƁB́ATerminateManager.waitTermination()threadubN
 *	邽߁B
 *	WindowListeneřĂяoTerminate-ThreadōsBWindowListener̃\bh
 *	awt componentswing componentɊւĂяóAEventQueue.invokeLater()
 *	EventQueue.invokeAndWaitČĂԕKvB
 *
 *	(example)
 *	public void windowClosing(WindowEvent inEvent) {
 *		class CloseAction implements Runnable {
 *			public void run() {
 *				// 炩̏
 *			}
 *		}
 *		
 *		Runnable aAction = new CloseAction();
 *		
 *		if (EventQueue.isDispatchThread()) {
 *			aAction.run();
 *		}
 *		else {
 *			try {
 *				EventQueue.invokeAndWait(aAction);
 *			}
 *			catch (InterruptedException e) {
 *			}
 *			catch (InvocationTargetException e) {
 *			}
 *		}
 *	}
 */
public final class TerminateManager {
	private static class Holder {
		static TerminateManager sInstance = new TerminateManager();
	}
	
	public static TerminateManager getInstance() {
		return Holder.sInstance;
	}
	
	private java.util.List mQueue; // List<WindowEvent>
	
	private boolean mIsStopped = true;
	
	private Thread mTerminateThread;
	
	/**
	 *	IXbhJn
	 */
	public void start() {
		// X^[g͂Ȃ
		if (! mIsStopped) return;
		
		mQueue = new java.util.LinkedList();
		mIsStopped = false;
		mTerminateThread = new Thread(new TerminateLoop(), "Terminate-Thread");
		mTerminateThread.start();
	}
	
	/**
	 *	ILZ
	 */
	public void cancel() {
		synchronized (mQueue) {
			mIsStopped = true;
			mTerminateThread = null;
			mQueue.notify();
		}
	}
	
	public void waitTermination() {
		synchronized (mQueue) {
			try {
				while(! mIsStopped) {
					mQueue.wait();
				}
			}
			catch (InterruptedException e) {
				cancel();
				return;
			}
		}	
	}
	
	public void pushEvent(WindowEvent inEvent) {
		if (null == inEvent) return;
		
		synchronized (mQueue) {
			mQueue.add(inEvent);
			mQueue.notify();
		}
	}
	
	/**
	 *	̃XbhIXbhł邩ǂ`FbN
	 */
	public boolean isTerminateThread() {
		return Thread.currentThread() == mTerminateThread;
	}
	
	private class TerminateLoop implements Runnable {
		public void run() {
			while(true) {
				WindowEvent aEvent = null;
				
				synchronized (mQueue) {
					try {
						while(mQueue.isEmpty() && ! mIsStopped) {
							mQueue.wait();
						}
					}
					catch (InterruptedException e) {
						cancel();
						return;
					}
					
					if (mIsStopped) return;
					
					aEvent = (WindowEvent)mQueue.remove(0);
				}
					
				aEvent.getWindow().dispatchEvent(aEvent);
					
				synchronized (mQueue) {
					if (mIsStopped) return;
				}
			}
		}	
	}
}