//
//	Copyright (C) 2003 Kazuhiko TAMURA. All rights reserved.
//
//	This library is free software; you can redistribute it and/or
//	modify it under the terms of the GNU Lesser General Public
//	License as published by the Free Software Foundation; either
//	version 2.1 of the License, or (at your option) any later version.
//
//	This library is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//	Lesser General Public License for more details.
//
//	You should have received a copy of the GNU Lesser General Public
//	License along with this library; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//	NAME:		NullModel.java
//	DATE:		2003.5.27
//	CREATOR:	Kazuhiko TAMURA
//
// ***************************************************************************************

package jp.gr.java_conf.ktz.puzzle.framework;


import jp.gr.java_conf.ktz.puzzle.framework.State;
import jp.gr.java_conf.ktz.puzzle.framework.StateEventCode;
import jp.gr.java_conf.ktz.puzzle.framework.ModelConstants;

/**
 *	ȂԂ\ĂȂModelB
 *	{IɁÃIuWFNgɑ삪`dȂ悤B
 *	ڍ쐬邱Ƃ͂łA<code>NullModel.getInstance()</code>\bhĂԁB
 */
public class NullModel implements Model {
	// initialized-on-demand holder class
	private static class Holder {
		static Model sInstance = new NullModel();
	}
	
	public static Model getInstance() {
		return Holder.sInstance;
	}
	
	/**
	 *	w肳ꂽTCỸ{[h쐬
	 *	̎ł́A쐬Ȃ
	 *
	 *	@param	inWidth	̌
	 *	@param	inHeight	č
	 */
	public void createBoard(final int inWidth, final int inHeight) {
		// empty
	}
	
	/**
	 *	ݒ肷
	 *	̎ł́Aݒ肵Ȃ
	 *
	 * 	@param	inProblem	̏
	 *	@return	ǂ݂񂾗vf
	 */
	public int setProblem(ProblemInfo inProblem) {
		return 0;
	}
	
	/**
	 *	݂̏Ԃǂ`FbN
	 *	̎ł́AfalseԂ
	 *
	 *	@return ȂtrueԂ
	 */
	public boolean check() {
		return false;
	}
	
	/**
	 *	Ԃɖ߂
	 *	̎ł́AύXȂ
	 */
	public void reset() {
		// empty
	}
	
	/**
	 *	w肵ʒuԂɖ߂
	 */
	public void resetAt(final int inX, final int inY) {
		// empty
	}

	/*
	 *	Model̏ԂύX(optional operation)
	 *
	 *	@param	inState	ύX̏
	 */
	public void setModelState(ModelState inState) {
	}
	
	/**
	 *	{[h̃TCYԂ 
	 *	̎ł́A{[h̎̂ĂȂ߁AO𑗏o
	 *
	 *	@throws	UnsupportedOperationException
	 */
	public java.awt.Dimension getSize() {
		throw new UnsupportedOperationException("getSize() method is unsupported");
	}
	
	/**
	 *	{[h̕Ԃ 
	 *	̎ł́A{[h̎̂ĂȂ߁AO𑗏o
	 *
	 *	@throws	UnsupportedOperationException
	 */
	public int getWidth() {
		throw new UnsupportedOperationException("getWidth() method is unsupported");
	}
	
	/**
	 *	{[h̍Ԃ 
	 *	̎ł́A{[h̎̂ĂȂ߁AO𑗏o
	 *
	 *	@throws	UnsupportedOperationException
	 */
	public int getHeight() {
		throw new UnsupportedOperationException("getHeight() method is unsupported");
	}
	
	/**
	 *	w肳ꂽʒu̖ʂ̏ԂԂB
	 *	̎ł́AO𑗏o
	 *
	 *	@param	inX	XW
	 *	@param	inY	YW
	 *	@throws	UnsupportedOperationException
	 */
	public State getCurStateAt(final int inX, final int inY) {
		throw new UnsupportedOperationException("getCurStateAt() method is unsupported");
	}
	
	/**
	 *	w肳ꂽʒu̖ʂ̐ԂB
	 *	̎ł́AO𑗏o
	 *
	 *	@param	inX	XW
	 *	@param	inY	YW
	 *	@throws	UnsupportedOperationException
	 */	
	public State getCorrectStateAt(final int inX, final int inY) {
		throw new UnsupportedOperationException("getCorrectStateAt() method is unsupported");
	}
	
	/**
	 *	w肳ꂽStateEventCodẽfŏł邩ǂ`FbNB
	 *	̎ł́AfalseԂB
	 *
	 *	@param	inCode`FbNStateEventCode
	 *	@return	̃fŏł̂ł΁AtrueԂ
	 */
	public boolean isAcceptableEvent(StateEventCode inCode) {
		return false;
	}

	/** 
	 *	w肳ꂽʒu̖ʂ̏Ԃ1i߂ 
	 *	̎ł́AȂ
	 *
	 *	@param	inX	XW
	 *	@param	inY	YW
	 */
	public void nextStateAt(final int inX, final int inY) {
		// empty
	}
	
	/**
	 *	w肵Ֆʂ̈ʒȕԂɑJڂB
	 *	inCodelɏ]ēJڂԂƂȂĂB
	 *	̎ł́AȂ
	 *
	 *	@param	inX XWiBoardWnj
	 *	@param	inY YWiBoardWnj
	 *	@param	inCode ԂJڂ邽߂̃CxgR[h
	 */
	public void nextStateAt(final int inX, final int inY, StateEventCode inCode) {
		// empty
	}
	
	/** 
	 *	w肳ꂽʒu̖ʂ̏Ԃ1߂ 
	 *	̎ł́AȂ
	 *
	 *	@param	inX	XW
	 *	@param	inY	YW
	 */
	public void prevStateAt(final int inX, final int inY) {
		// empty
	}

	/** 
	 *	w肳ꂽʒu̖ʂ̏Ԃ1߂
	 *	inCodelɏ]ēJڂԂƂȂĂB
	 *	̎ł́AȂ
	 *
	 *	@param	inX XWiBoardWnj
	 *	@param	inY YWiBoardWnj
	 *	@param	inCode ԂJڂ邽߂̃CxgR[h
	 */
	public void prevStateAt(final int inX, final int inY, StateEventCode inCode) {
		// empty
	}
	
	/** 
	 *	@return ŌɏCʂ̈ʒuԂ
	 *	̎ł́ATCY0̔zԂ
	 */
	public java.awt.Point[] lastModified() {
		return ModelConstants.EMPTIES;
	}
	
	/**
	 *	w肳ꂽʒu{[ḧǂׂ 
	 *	̎ł́AfalseԂ
	 *
	 *	@param	inX	XWiBoardWnj
	 *	@param	inY	YWiBoardWnj
	 *	@return	{[ḧȂtrue
	 */
	public boolean contains(final int inX, final int inY) {
		return false;
	}
	
	/**
	 *	w肳ꂽʒu̖ʂǂׂ 
	 *	̎ł́AfalseԂ
	 *
	 *	@param	inX	XWiBoardWnj
	 *	@param	inY	YWiBoardWnj
	 *	@return	Ȃtrue
	 */
	public boolean isNumberAt(final int inX, final int inY) {
		return false;
	}
	
	/**
	 *	w肳ꂽʒu̖ʂ󔒂ǂׂB
	 *	̎ł́AfalseԂ
	 *
	 *	@param inX	XWiBoardWnj
	 *	@param	inY	YWiBoardWnj
	 *	@return	󔒂Ȃtrue
	 */
	public boolean isSpaceAt(final int inX, final int inY) {
		return false;
	}

	/**
	 *	w肳ꂽʒu̖ʂJڂł邩ǂׂB
	 *	̎ł́AfalseԂ
	 *
	 *	@param inX	XWiBoardWnj
	 *	@param	inY	YWiBoardWnj
	 *	@return	Jڂł̂ł΁AtrueԂB
	 */
	public boolean isTransitAt(final int inX, final int inY) {
		return false;
	}

	/**
	 *	w肳ꂽʒu̖ʂJڂł邩ǂׂB
	 *	Jڂ܂Ŋł邩ǂׂB
	 *	̎ł́AfalseԂ
	 *
	 *	@param	inCode JڂɊւl
	 *	@param inX	XWiBoardWnj
	 *	@param	inY	YWiBoardWnj
	 *	@return	Jڂł̂ł΁AtrueԂB
	 */
	public boolean isTransitAt(final int inX, final int inY, StateEventCode inCode) {
		return false;
	}

	/**
	 *	ModelύXꂽǂ𒲂ׂB
	 *	̎ł́AfalseԂ
	 *
	 *	@return	ύXĂtrueԂB
	 */
	public boolean isModified() {
		return false;
	}
	
	/**
	 *	Model̕ύXNA
	 *	̎ł́AȂ
	 */
	public void flush() {
		// empty
	}
	
	private NullModel() {
	}
}	
	