<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:xh="http://www.w3.org/1999/xhtml"
                              xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:sdf="http://www.arielworks.net/works/codeyard/sdf"
                              xmlns:s3="http://www.arielworks.net/works/codeyard/sdf/s3"
                              xmlns:hml="http://www.arielworks.net/works/codeyard/himmel"
                              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                              xmlns:dc="http://purl.org/dc/elements/1.1/"
                              xmlns:dcterms="http://purl.org/dc/terms/">
<xsl:import href="./settings.xsl"/>

<xsl:param name="processorRoot" select="''"/>

<xsl:param name="modifiedDatetime">
    <xsl:for-each select="//sdf:meta/dcterms:modified">
        <xsl:sort select="." order="descending"/>
        <xsl:if test="position() = 1">
            <xsl:value-of select="."/>
        </xsl:if>
    </xsl:for-each>
</xsl:param>
<xsl:param name="s3:modifiedDatetime" select="$modifiedDatetime"/>

<xsl:param name="debugMode" select="'no'"/>
<xsl:param name="s3:debugMode" select="$debugMode"/>

<!-- sdf:document into basic structure -->
<xsl:template match="/sdf:document">
    <html>
        <xsl:call-template name="s3:add_xhtml_attributes"/>
        <xsl:apply-templates select="./sdf:meta"/>
        <xsl:apply-templates select="./sdf:body"/>
    </html>
</xsl:template>

<xsl:template match="/sdf:document/sdf:meta">
    <head>
        <xsl:choose>
            <xsl:when test="./dc:title">
                <title><xsl:value-of select="./dc:title"/></title>
            </xsl:when>
            <xsl:otherwise>
                <xsl:message terminate="yes">Not found element for "title" element. At least one {<xsl:value-of select="namespace-uri(dc:*)"/>}title required.</xsl:message>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates select="xh:*"/>
        <xsl:call-template name="s3:meta_basic"/>
        <xsl:call-template name="s3:meta_extended"/>
    </head>
</xsl:template>

<xsl:template match="/sdf:document/sdf:body">
    <body class="{normalize-space(concat('un', translate($s3:debugMode, '/', '-'), ' ', ../@xh:class))}">
        <xsl:call-template name="s3:show_head"/>
        <xsl:if test="../sdf:meta/dc:title">
            <h1>
                <xsl:apply-templates select="../sdf:meta/dc:title/node()"/>
            </h1>
        </xsl:if>
        <xsl:call-template name="s3:show_meta"/>
        <xsl:apply-templates/>
        <xsl:call-template name="s3:show_foot"/>
    </body>
</xsl:template>

<xsl:template name="s3:meta_basic">
    <meta name="WWWC" content="{substring($s3:modifiedDatetime, 0, 5)}/{substring($s3:modifiedDatetime, 6, 2)}/{substring($s3:modifiedDatetime, 9, 2)} {substring($s3:modifiedDatetime, 12, 5)}"/>
</xsl:template>


<!-- sdf:section into div.section -->
<xsl:template match="sdf:section">
    <div class="{normalize-space(concat('section ', ./@xh:class))}">
        <xsl:attribute name="id">
            <xsl:choose>
                <xsl:when test="./@xml:id">
                    <xsl:value-of select="./@xml:id"/>
                </xsl:when>
                <xsl:when test="./@xh:id">
                    <xsl:value-of select="./@xh:id"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>AuTOC_</xsl:text>
                    <xsl:number level="multiple" count="sdf:section" format="1-1"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:attribute>
        <xsl:call-template name="s3:add_xhtml_attributes"/>
        <xsl:if test="not(./@xml:id or ./@xh:id)">
            <xsl:comment> Note: IDs named "AuTOC" are generated automatically. They are NOT permanent. </xsl:comment>
        </xsl:if>
        <xsl:apply-templates select="./sdf:meta"/>
        <xsl:apply-templates select="./sdf:body"/>
    </div>
</xsl:template>

<xsl:template match="sdf:meta">
    <xsl:if test="../sdf:meta/dc:title">
        <xsl:element name="{concat('h', count(./ancestor::node()) div 2)}">
            <xsl:apply-templates select="../sdf:meta/dc:title/node()"/>
        </xsl:element>
    </xsl:if>
</xsl:template>

<xsl:template match="sdf:body">
    <xsl:apply-templates/>
</xsl:template>



<!-- sdf:documentとsdf:sectionについていた属性のうち、必要なものだけコピーするテンプレート -->
<!-- SDML関係は消去（上2つ）、xh:classは上位テンプレートで付けてあるので除外、名前空間宣言は消去、スキーマもあり得ないので消去 -->
<xsl:template name="s3:add_xhtml_attributes">
    <xsl:copy-of select="./@*[not(namespace-uri(.) = 'http://www.arielworks.net/works/codeyard/sdf'
                                  or namespace-uri(.) = ''
                                  or (namespace-uri(.) = 'http://www.w3.org/XML/1998/namespace' and local-name() = 'id')
                                  or (namespace-uri(.) = 'http://www.w3.org/1999/xhtml' and local-name() = 'class')
                                  or namespace-uri(.) = 'http://www.w3.org/2000/xmlns/'
                                  or namespace-uri(.) = 'http://www.w3.org/2001/XMLSchema-instance'
                                  )]"/>
</xsl:template>


<!-- メタデータ表示用テンプレート -->
<xsl:template name="s3:show_meta">
    <xsl:if test="not(/sdf:document/sdf:meta/@s3:visibility = 'hidden')">
        <dl class="meta">
            <xsl:call-template name="s3:show_status"/><!-- 状態挿入 -->
            <xsl:call-template name="s3:show_toc"/><!-- 目次挿入 -->
        </dl>
    </xsl:if>
</xsl:template>


<!-- sdf:doumentのメタデータをXHTML要素に変換するテンプレート群 -->
<!-- 最外部の構造を定義 -->
<xsl:template name="s3:show_status">
    <dt class="status">
        <xsl:choose>
            <xsl:when test="lang('ja')">ページ情報</xsl:when>
            <xsl:otherwise>Page Info.</xsl:otherwise>
        </xsl:choose>
    </dt>
    <dd class="status">
        <xsl:call-template name="s3:show_status_item"/>
    </dd>
</xsl:template>

<xsl:template name="s3:get_dir_name">
    <xsl:param name="s3:name"/>

    <xsl:choose>
        <xsl:when test="contains(substring-after($s3:name, '/'), '/')">
            <xsl:call-template name="s3:get_dir_name">
                <xsl:with-param name="s3:name" select="substring-after($s3:name, '/')"/>
            </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
            <xsl:value-of select="substring-after($s3:name, '/')"/>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>


<!-- 目次挿入用のテンプレート群 -->
<xsl:template name="s3:show_toc">
    <xsl:if test="count(/sdf:document/sdf:body/sdf:section) &gt; 3 and not(/sdf:document/sdf:meta/@s3:toc_level = 0)">
        <dt class="toc">
            <xsl:choose>
                <xsl:when test="lang('ja')">ページ内目次</xsl:when>
                <xsl:otherwise>TOC</xsl:otherwise>
            </xsl:choose>
        </dt>
        <dd class="toc">
            <ul>
                <xsl:apply-templates select="/sdf:document/sdf:body/sdf:section" mode="s3:show_toc_item"/>
            </ul>
        </dd>
    </xsl:if>
</xsl:template>

<xsl:template match="sdf:section" mode="s3:show_toc_item">
    <li>
        <a>
            <xsl:attribute name="href">
                <xsl:choose>
                    <xsl:when test="./@xml:id">
                        <xsl:value-of select="concat('#', ./@xml:id)"/>
                    </xsl:when>
                    <xsl:when test="./@xh:id">
                        <xsl:value-of select="concat('#', ./@xh:id)"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>#AuTOC_</xsl:text>
                        <xsl:number level="multiple" count="sdf:section" format="1-1"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:attribute>
            <xsl:value-of select="./sdf:meta/dc:title"/>
        </a>
        <xsl:if test="./sdf:body/sdf:section">
            <xsl:if test="not(/sdf:document/sdf:meta/@s3:toc_level)
                          or count(./ancestor::sdf:section) + 1 &lt; /sdf:document/sdf:meta/@s3:toc_level">
                <ul>
                    <xsl:apply-templates select="./sdf:body/sdf:section" mode="s3:show_toc_item"/>
                </ul>
            </xsl:if>
        </xsl:if>
    </li>
</xsl:template>



<!-- 要素は基本的にコピー -->
<xsl:template match="*">
    <xsl:element name="{local-name()}" namespace="{namespace-uri(.)}">
        <xsl:apply-templates select="@*"/>
        <xsl:apply-templates/>
    </xsl:element>
</xsl:template>

<!-- 属性は基本的にコピー -->
<xsl:template match="@*">
    <xsl:copy-of select="."/>
</xsl:template>

<!-- ソースXMLファイルのコメントはコピー -->
<xsl:template match="comment()">
    <xsl:copy-of select="."/>
</xsl:template>

</xsl:stylesheet>