/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.util;

import com.clustercontrol.accesscontrol.action.GetUserInfo;
import com.clustercontrol.bean.Property;
import com.clustercontrol.monitor.core.MonitorCorePlugin;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.util.ReportGenerator;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class EventReportGenerator {
    public static final String JASPER_FILE_PDF = "conf/EventLogReportPdf.jasper";
    public static final String JASPER_FILE_CSV = "conf/EventLogReportCsv.jasper";
    public static final String REPORT_OUTPUT_DATE = "REPORT_OUTPUT_DATE";
    public static final String REPORT_OUTPUT_USER = "REPORT_OUTPUT_USER";
    public static final String PRIORITY = "PRIORITY";
    public static final String OUTPUT_DATE = "OUTPUT_DATE";
    public static final String GENERATION_DATE = "GENERATION_DATE";
    public static final String FACILITY_ID = "FACILITY_ID";
    public static final String APPLICATION = "APPLICATION";
    public static final String CONFIRM_FLG = "CONFIRM_FLG";
    public static final String MESSAGE = "MESSAGE";

    public boolean run(String facilityId, Property condition, ArrayList list, int outputForm, String redirect) {
        ArrayList values = null;
        String priority = null;
        Date outputFromDate = null;
        Date outputToDate = null;
        Date generationFromDate = null;
        Date generationToDate = null;
        String application = null;
        String confirmFlg = null;
        String message = null;
        values = PropertyUtil.getPropertyValue((Property)condition, (String)"priority");
        if (!"".equals((String)values.get(0))) {
            priority = (String)values.get(0);
        }
        if ((values = PropertyUtil.getPropertyValue((Property)condition, (String)"outputFromDate")).get(0) instanceof Date) {
            outputFromDate = (Date)values.get(0);
        }
        if ((values = PropertyUtil.getPropertyValue((Property)condition, (String)"outputToDate")).get(0) instanceof Date) {
            outputToDate = (Date)values.get(0);
        }
        if ((values = PropertyUtil.getPropertyValue((Property)condition, (String)"generationFromDate")).get(0) instanceof Date) {
            generationFromDate = (Date)values.get(0);
        }
        if ((values = PropertyUtil.getPropertyValue((Property)condition, (String)"generationToDate")).get(0) instanceof Date) {
            generationToDate = (Date)values.get(0);
        }
        if (!"".equals((String)(values = PropertyUtil.getPropertyValue((Property)condition, (String)"application")).get(0))) {
            application = (String)values.get(0);
        }
        if (!"".equals((String)(values = PropertyUtil.getPropertyValue((Property)condition, (String)"confirmed")).get(0))) {
            confirmFlg = (String)values.get(0);
        }
        if (!"".equals((String)(values = PropertyUtil.getPropertyValue((Property)condition, (String)"message")).get(0))) {
            message = (String)values.get(0);
        }
        String userName = new GetUserInfo().getName();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put(REPORT_OUTPUT_DATE, DateFormat.getDateTimeInstance().format(new Date()));
        paramMap.put(REPORT_OUTPUT_USER, userName);
        paramMap.put(PRIORITY, priority);
        paramMap.put(OUTPUT_DATE, this.getDateText(outputFromDate, outputToDate));
        paramMap.put(GENERATION_DATE, this.getDateText(generationFromDate, generationToDate));
        paramMap.put(FACILITY_ID, facilityId);
        paramMap.put(APPLICATION, application);
        paramMap.put(CONFIRM_FLG, confirmFlg);
        paramMap.put(MESSAGE, message);
        String jasperPath = null;
        if (outputForm == 0) {
            jasperPath = JASPER_FILE_PDF;
        } else if (outputForm == 1) {
            jasperPath = JASPER_FILE_CSV;
        }
        URL url = MonitorCorePlugin.getDefault().find((IPath)new Path(jasperPath));
        try {
            url = Platform.asLocalURL((URL)url);
            jasperPath = url.getPath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        ReportGenerator report = new ReportGenerator(jasperPath, outputForm);
        return report.run(redirect, paramMap, (Collection)list);
    }

    private String getDateText(Date fromDate, Date toDate) {
        StringBuffer test = new StringBuffer();
        if (fromDate != null) {
            test.append(DateFormat.getDateTimeInstance().format(fromDate));
        }
        if (fromDate != null || toDate != null) {
            test.append(" - ");
        }
        if (toDate != null) {
            test.append(DateFormat.getDateTimeInstance().format(toDate));
        }
        return test.toString();
    }
}

