/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.factory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.notify.bean.NotifyInfoContext;
import com.clustercontrol.notify.ejb.entity.NotifyEventInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyInfoUtil;
import com.clustercontrol.notify.util.SendQueue;
import com.clustercontrol.util.apllog.AplLogger;
import java.io.Serializable;
import java.util.Collection;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeleteNotify {
    protected static Log m_log = LogFactory.getLog(DeleteNotify.class);

    public boolean delete(String notifyId) throws FinderException, RemoveException, NamingException, JMSException {
        AccessLock.lock((String)"NOTIFY");
        NotifyInfoLocal notify = null;
        SendQueue queue = null;
        try {
            notify = NotifyInfoUtil.getLocalHome().findByPrimaryKey(notifyId);
            Collection ct = notify.getNotifyEventInfo();
            this.deleteEvents(ct);
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            Object[] args = new String[]{notifyId};
            apllog.put("SYS", "003", args);
            m_log.debug((Object)("delete():" + e.getMessage()));
            throw e;
        }
        catch (RemoveException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            Object[] args = new String[]{notifyId};
            apllog.put("SYS", "003", args);
            m_log.debug((Object)("delete():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            Object[] args = new String[]{notifyId};
            apllog.put("SYS", "003", args);
            m_log.debug((Object)("delete():" + e.getMessage()));
            throw e;
        }
        try {
            notify.remove();
            NotifyInfoContext context = new NotifyInfoContext(2, notifyId, null);
            queue = new SendQueue("queue/clustercontrol/Monitor/EventLog");
            queue.put((Serializable)context);
            queue.terminate();
        }
        catch (RemoveException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            Object[] args = new String[]{notifyId};
            apllog.put("SYS", "003", args);
            m_log.debug((Object)("getNotify():" + e.getMessage()));
            throw e;
        }
        catch (JMSException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            Object[] args = new String[]{notifyId};
            apllog.put("SYS", "003", args);
            m_log.debug((Object)("add():" + e.getMessage()));
            throw e;
        }
        finally {
            if (queue != null) {
                queue.terminate();
            }
        }
        return true;
    }

    public boolean deleteEvents(Collection ct) throws RemoveException {
        if (ct != null && ct.size() > 0) {
            Object[] eventArray = ct.toArray();
            for (int j = 0; j < eventArray.length; ++j) {
                NotifyEventInfoLocal event = (NotifyEventInfoLocal)eventArray[j];
                if (event == null) continue;
                event.remove();
            }
        }
        return true;
    }
}

