/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.calendar.composite;

import com.clustercontrol.calendar.action.GetCalendarSchedule;
import com.clustercontrol.calendar.action.GetCalendarScheduleTableDefine;
import com.clustercontrol.calendar.composite.CalendarTableViewer;
import com.clustercontrol.calendar.composite.action.VerticalBarSelectionListener;
import com.clustercontrol.util.Messages;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class CalendarScheduleComposite
extends Composite {
    protected CalendarTableViewer m_viewer = null;
    protected Table m_table = null;
    protected Label m_labelCount = null;
    protected String m_calendarId = null;
    protected Date m_base = null;

    public CalendarScheduleComposite(Composite parent, int style, Date base) {
        super(parent, style);
        this.m_base = base;
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.m_table = new Table((Composite)this, 68356);
        this.m_table.setHeaderVisible(true);
        this.m_table.setLinesVisible(true);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        this.m_table.setLayoutData((Object)gridData);
        this.m_labelCount = new Label((Composite)this, 131072);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.m_labelCount.setLayoutData((Object)gridData);
        this.m_viewer = new CalendarTableViewer(this.m_table);
        this.m_viewer.createTableColumn(GetCalendarScheduleTableDefine.get((Date)this.m_base), 0, 1);
        this.m_viewer.getTable().getVerticalBar().addSelectionListener((SelectionListener)new VerticalBarSelectionListener(this));
    }

    public void update() {
        ArrayList info = null;
        GetCalendarSchedule getCalendarSchedule = new GetCalendarSchedule();
        info = getCalendarSchedule.getAll(this.m_base);
        if (info == null) {
            info = new ArrayList();
        }
        this.m_viewer.setInput(info);
        Object[] args = new Object[]{DateFormat.getDateInstance().format(this.m_base)};
        this.m_labelCount.setText(Messages.getString((String)"specified.period", (Object[])args));
    }

    public TableViewer getTableViewer() {
        return this.m_viewer;
    }

    public Table getTable() {
        return this.m_viewer.getTable();
    }

    public String getCalendarId() {
        return this.m_calendarId;
    }

    public void setCalendarId(String calendarId) {
        this.m_calendarId = calendarId;
    }

    public Date getBaseDate() {
        return this.m_base;
    }

    public void setCalendarId(Date base) {
        this.m_base = base;
    }
}

