/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.calendar.dialog;

import com.clustercontrol.bean.Property;
import com.clustercontrol.calendar.action.AddCalendarProperty;
import com.clustercontrol.calendar.action.GetCalendarProperty;
import com.clustercontrol.composite.PropertySheet;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class CalendarDialog
extends CommonDialog {
    private String id = "";
    private int mode;
    private PropertySheet propertySheet = null;

    public CalendarDialog(Shell parent, String uid, int mode) {
        super(parent);
        this.id = uid;
        this.mode = mode;
    }

    protected Point getInitialSize() {
        return new Point(500, 600);
    }

    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString((String)"dialog.calendar.calendar.create.modify"));
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        parent.setLayout((Layout)layout);
        Label label = new Label(parent, 16384);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"attribute")) + " : ");
        TableTree table = new TableTree(parent, 68354);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData((Object)gridData);
        this.propertySheet = new PropertySheet(table);
        Property property = null;
        if (this.mode == 1) {
            property = new GetCalendarProperty().getProperty(this.id, 1);
        } else if (this.mode == 0) {
            property = new GetCalendarProperty().getProperty(this.id, 0);
        } else if (this.mode == 2) {
            property = new GetCalendarProperty().getProperty(this.id, 2);
        }
        this.propertySheet.setInput(property);
        this.propertySheet.expandAll();
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        line.setLayoutData((Object)gridData);
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
    }

    protected ValidateResult validate() {
        return super.validate();
    }

    public Property getInputData() {
        return (Property)this.propertySheet.getInput();
    }

    public void setInputData(Property property) {
        this.propertySheet.setInput(property);
    }

    public String getUid() {
        return this.id;
    }

    protected String getOkButtonText() {
        if (this.mode == 1) {
            return Messages.getString((String)"modify");
        }
        if (this.mode == 0) {
            return Messages.getString((String)"register");
        }
        return Messages.getString((String)"ok");
    }

    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }

    protected void okPressed() {
        ValidateResult result = this.validate();
        if (result == null || result.isValid()) {
            if (this.mode == 0) {
                Property addProperty = PropertyUtil.copy(this.getInputData());
                PropertyUtil.deletePropertyDefine(addProperty);
                if (new AddCalendarProperty().add(addProperty)) {
                    MessageBox box = new MessageBox(this.getShell(), 2);
                    box.setText(Messages.getString((String)"successful"));
                    box.setMessage(Messages.getString((String)"message.calendar.1"));
                    box.open();
                } else {
                    MessageBox box = new MessageBox(this.getShell(), 1);
                    box.setText(Messages.getString((String)"failed"));
                    box.setMessage(Messages.getString((String)"message.calendar.2"));
                    box.open();
                }
            } else {
                super.okPressed();
            }
        } else {
            this.displayError(result);
        }
    }
}

