/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.run.composite;

import com.clustercontrol.composite.PositiveNumberVerifyListener;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.composite.MonitorRuleComposite;
import com.clustercontrol.util.Messages;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MonitorRuleTimeoutComposite
extends MonitorRuleComposite {
    protected Text m_textTimeout = null;
    private String m_timeoutText = Messages.getString((String)"time.out.sec");

    public MonitorRuleTimeoutComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    public MonitorRuleTimeoutComposite(Composite parent, int style, String label) {
        super(parent, style);
        this.m_timeoutText = label;
        this.initialize();
    }

    private void initialize() {
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 15;
        this.setLayout((Layout)layout);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(this.m_timeoutText) + " : ");
        this.m_textTimeout = new Text((Composite)this, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textTimeout.addVerifyListener((VerifyListener)new PositiveNumberVerifyListener());
        this.m_textTimeout.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
    }

    public void setInputData(MonitorInfo info) {
        super.setInputData(info);
        if (info != null) {
            this.m_textTimeout.setText(Integer.toString(info.getTimeout()));
        }
    }

    public ValidateResult createInputData(MonitorInfo info) {
        ValidateResult validateResult = super.createInputData(info);
        if (validateResult != null) {
            return validateResult;
        }
        if (this.m_textTimeout.getText() != null && !"".equals(this.m_textTimeout.getText().trim())) {
            int timeout = -1;
            try {
                timeout = Integer.valueOf(this.m_textTimeout.getText());
                if (timeout > info.getRunInterval()) {
                    return this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.43"));
                }
                info.setTimeout(timeout);
            }
            catch (NumberFormatException numberFormatException) {
                return this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.42"));
            }
        } else {
            return this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.42"));
        }
        return null;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_textTimeout.setEnabled(enabled);
    }

    protected ValidateResult setValidateResult(String id, String message) {
        ValidateResult validateResult = new ValidateResult();
        validateResult.setValid(false);
        validateResult.setID(id);
        validateResult.setMessage(message);
        return validateResult;
    }
}

