/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.toc;

import org.eclipse.help.internal.model.ILinkElement;
import org.eclipse.help.internal.toc.HrefUtil;
import org.eclipse.help.internal.toc.ITocNode;
import org.eclipse.help.internal.toc.Toc;
import org.eclipse.help.internal.toc.TocBuilder;
import org.eclipse.help.internal.toc.TocFile;
import org.eclipse.help.internal.toc.TocNode;
import org.xml.sax.Attributes;

class Link
extends TocNode
implements ILinkElement {
    protected Toc parentToc;
    protected String toc;

    protected Link(TocFile tocFile, Attributes attrs) {
        if (attrs == null) {
            return;
        }
        this.toc = attrs.getValue("toc");
        this.toc = HrefUtil.normalizeHref(tocFile.getPluginID(), this.toc);
        this.parentToc = tocFile.getToc();
    }

    public void build(TocBuilder builder) {
        builder.buildLink(this);
    }

    protected String getToc() {
        return this.toc;
    }

    public void addChild(ITocNode child) {
        super.addChild(child);
        if (child instanceof Toc && this.parentToc != null) {
            this.parentToc.getChildrenTocs().add(child);
        }
    }
}

