/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.collectiverun.factory;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.bean.Property;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdParamMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunEndMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunEndMstPK;
import com.clustercontrol.collectiverun.ejb.entity.CRunEndMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamSelectMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamSelectMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionDetailLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionDetailPK;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionDetailUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionParamLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionParamPK;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionParamUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunSessionUtil;
import com.clustercontrol.collectiverun.message.CollectiveRunInstructionInfo;
import com.clustercontrol.collectiverun.util.SendQueue;
import com.clustercontrol.jobmanagement.message.RunResultInfo;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.util.apllog.AplLogger;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OperationRun {
    protected static Log m_log = LogFactory.getLog(OperationRun.class);
    protected static String SHELL_COMMAND = "sh";

    public void run(String sessionId) throws CreateException, FinderException, NamingException, IOException {
        m_log.debug((Object)("run() : sessionId=" + sessionId));
        CRunSessionLocal session = CRunSessionUtil.getLocalHome().findByPrimaryKey(sessionId);
        String command = this.getCommand(session);
        if (session.getStatus() == 0) {
            session.setStatus(new Integer(100));
            session.setStart_date(new Date());
        }
        this.startNode(session, command);
    }

    protected void startNode(CRunSessionLocal session, String command) throws FinderException, NamingException {
        m_log.debug((Object)("startNode() start: sessionId=" + session.getSession_id()));
        String sessionId = session.getSession_id();
        CRunCmdMstLocal cmd = CRunCmdMstUtil.getLocalHome().findByPrimaryKey(session.getCommand_id());
        int commandType = cmd.getCommand_type();
        String password = null;
        try {
            CRunSessionParamLocal param = CRunSessionParamUtil.getLocalHome().findByPrimaryKey(new CRunSessionParamPK(sessionId, "PASSWORD"));
            password = param.getParam_value();
        }
        catch (Exception e1) {
            // empty catch block
        }
        Collection collection = session.getSessionDetail();
        if (collection != null && collection.size() > 0) {
            SendQueue send = null;
            try {
                send = new SendQueue("queue/clustercontrol/CollectiveRun/execute");
            }
            catch (Exception e) {
                m_log.debug((Object)("startNode() : \u5b9f\u884c\u6307\u793a\u9001\u4fe1\u30a8\u30e9\u30fc : " + e.getMessage()));
            }
            for (CRunSessionDetailLocal sessionDetail : collection) {
                CollectiveRunInstructionInfo info = new CollectiveRunInstructionInfo();
                info.setSessionId(sessionId);
                info.setFacilityId(sessionDetail.getFacility_id());
                if (commandType == 1) {
                    info.setCommand(SHELL_COMMAND);
                    info.setInputFile(command);
                } else {
                    info.setCommand(command);
                }
                info.setCommandType(0);
                info.setPassword(password);
                try {
                    send.put(info);
                }
                catch (Exception e) {
                    AplLogger apllog = new AplLogger("CR", "cr");
                    Object[] args = new String[]{info.getSessionId(), info.getFacilityId()};
                    apllog.put("SYS", "003", args);
                    m_log.debug((Object)("startNode() : \u5b9f\u884c\u6307\u793a\u9001\u4fe1\u30a8\u30e9\u30fc : " + e.getMessage()));
                }
            }
            try {
                send.close();
            }
            catch (Exception e) {
                m_log.debug((Object)("startNode() : \u5b9f\u884c\u6307\u793a\u9001\u4fe1\u30a8\u30e9\u30fc : " + e.getMessage()));
            }
        }
        m_log.debug((Object)("startNode() end: sessionId=" + session.getSession_id()));
    }

    public void endNode(RunResultInfo info) throws FinderException, NamingException {
        m_log.debug((Object)("endNode() start: sessionId=" + info.getSessionId() + ", facilityId=" + info.getFacilityId() + ", status=" + info.getStatus()));
        CRunSessionLocal session = CRunSessionUtil.getLocalHome().findByPrimaryKey(info.getSessionId());
        if (info.getCommandType() == 0) {
            CRunSessionDetailLocal sessionDetail = CRunSessionDetailUtil.getLocalHome().findByPrimaryKey(new CRunSessionDetailPK(info.getSessionId(), info.getFacilityId()));
            if (info.getStatus() == 0) {
                if (sessionDetail.getStart_date() == null) {
                    sessionDetail.setStatus(new Integer(100));
                    sessionDetail.setStart_date(info.getTime());
                    session.setRunning_cnt(new Integer(session.getRunning_cnt() + 1));
                    session.setWait_cnt(new Integer(session.getWait_cnt() - 1));
                } else {
                    AplLogger apllog = new AplLogger("CR", "cr");
                    Object[] args = new String[]{info.getSessionId(), info.getFacilityId()};
                    apllog.put("SYS", "004", args);
                    m_log.debug((Object)("endNode() : \u53d7\u4fe1\u6e08\u307f\u306e\u5b9f\u884c\u958b\u59cb\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u53d7\u4fe1\u3057\u307e\u3057\u305f\u3002 \u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u7834\u68c4\u3057\u307e\u3059\u3002 SessionId=" + info.getSessionId() + ", FacilityId=" + info.getFacilityId()));
                }
                sessionDetail = null;
            } else {
                if (sessionDetail.getStatus() == 100) {
                    session.setRunning_cnt(new Integer(session.getRunning_cnt() - 1));
                }
                if (info.getStatus() == 1) {
                    if (sessionDetail.getStatus() == 100) {
                        sessionDetail.setStatus(new Integer(300));
                        sessionDetail.setEnd_date(info.getTime());
                        sessionDetail.setEnd_value(new Integer(info.getEndValue()));
                        sessionDetail.setMessage(info.getMessage());
                        sessionDetail.setError_message(info.getErrorMessage());
                        this.setEndStatus(session, sessionDetail);
                    }
                } else if (info.getStatus() == 2 && sessionDetail.getStatus() == 100) {
                    sessionDetail.setStatus(new Integer(400));
                    sessionDetail.setMessage(info.getMessage());
                    sessionDetail.setError_message(info.getErrorMessage());
                    session.setEnd_abnomal_cnt(new Integer(session.getEnd_abnomal_cnt() + 1));
                }
                sessionDetail = null;
                if (this.checkAllNodeEnd(session)) {
                    this.setNodeCount(session);
                    if (session.getStatus() == 100) {
                        session.setStatus(new Integer(300));
                        session.setEnd_date(info.getTime());
                    }
                }
            }
        }
        m_log.debug((Object)("endNode() end: sessionId=" + info.getSessionId() + ", facilityId=" + info.getFacilityId() + ", status=" + info.getStatus()));
    }

    protected void setNodeCount(CRunSessionLocal session) throws FinderException, NamingException {
        m_log.debug((Object)("setNodeCount() : sessionId=" + session.getSession_id()));
        int normal = 0;
        int warning = 0;
        int abnormal = 0;
        int running = 0;
        int waiting = 0;
        Collection collection = session.getSessionDetail();
        if (collection != null && collection.size() > 0) {
            for (CRunSessionDetailLocal sessionDetail : collection) {
                if (sessionDetail.getStatus() == 100) {
                    ++running;
                } else if (sessionDetail.getStatus() == 0) {
                    ++waiting;
                } else if (sessionDetail.getStatus() == 400) {
                    ++abnormal;
                }
                if (sessionDetail.getEnd_status() == null) continue;
                if (sessionDetail.getEnd_status() == 0) {
                    ++normal;
                    continue;
                }
                if (sessionDetail.getEnd_status() == 1) {
                    ++warning;
                    continue;
                }
                if (sessionDetail.getEnd_status() != 2) continue;
                ++abnormal;
            }
        }
        session.setRunning_cnt(new Integer(running));
        session.setWait_cnt(new Integer(waiting));
        session.setEnd_nomal_cnt(new Integer(normal));
        session.setEnd_warning_cnt(new Integer(warning));
        session.setEnd_abnomal_cnt(new Integer(abnormal));
    }

    protected void setEndStatus(CRunSessionLocal session, CRunSessionDetailLocal sessionDetail) throws FinderException, NamingException {
        m_log.debug((Object)("setEndStatus() : sessionId=" + session.getSession_id() + ", facilityId=" + sessionDetail.getFacility_id()));
        CRunEndMstLocal endInfoNormal = null;
        try {
            endInfoNormal = CRunEndMstUtil.getLocalHome().findByPrimaryKey(new CRunEndMstPK(session.getCommand_id(), new Integer(0)));
        }
        catch (FinderException e) {
            m_log.debug((Object)("setEndStatus() : EndMst normal find error" + e.getMessage()));
        }
        CRunEndMstLocal endInfoWarning = null;
        try {
            endInfoWarning = CRunEndMstUtil.getLocalHome().findByPrimaryKey(new CRunEndMstPK(session.getCommand_id(), new Integer(1)));
        }
        catch (FinderException e) {
            m_log.debug((Object)("setEndStatus() : EndMst warning find error" + e.getMessage()));
        }
        Integer endValue = sessionDetail.getEnd_value();
        if (endValue instanceof Integer) {
            if (endInfoNormal != null && endValue.compareTo(endInfoNormal.getEnd_value_from()) >= 0 && endValue.compareTo(endInfoNormal.getEnd_value_to()) <= 0) {
                sessionDetail.setEnd_status(new Integer(0));
                session.setEnd_nomal_cnt(new Integer(session.getEnd_nomal_cnt() + 1));
            } else if (endInfoWarning != null && endValue.compareTo(endInfoWarning.getEnd_value_from()) >= 0 && endValue.compareTo(endInfoWarning.getEnd_value_to()) <= 0) {
                sessionDetail.setEnd_status(new Integer(1));
                session.setEnd_warning_cnt(new Integer(session.getEnd_warning_cnt() + 1));
            } else {
                sessionDetail.setEnd_status(new Integer(2));
                session.setEnd_abnomal_cnt(new Integer(session.getEnd_abnomal_cnt() + 1));
            }
        }
    }

    protected boolean checkAllNodeEnd(CRunSessionLocal session) throws FinderException, NamingException {
        m_log.debug((Object)("checkAllNodeEnd() start: sessionId=" + session.getSession_id()));
        boolean end = false;
        boolean runNode = false;
        if (session.getRunning_cnt() > 0 || session.getWait_cnt() > 0) {
            runNode = true;
        }
        if (!runNode) {
            end = true;
        }
        m_log.debug((Object)("checkAllNodeEnd() end: sessionId=" + session.getSession_id()));
        return end;
    }

    public String getCommand(CRunSessionLocal session) throws FinderException, NamingException, IOException {
        m_log.debug((Object)("getCommand() : sessionId=" + session.getSession_id()));
        String command = null;
        CRunCmdMstLocal cmd = CRunCmdMstUtil.getLocalHome().findByPrimaryKey(session.getCommand_id());
        StringBuffer argument = new StringBuffer();
        Collection cmdPramList = cmd.getCmdParamMst();
        if (cmdPramList != null && cmdPramList.size() > 0) {
            for (CRunCmdParamMstLocal cmdParam : cmdPramList) {
                CRunSessionParamLocal sessionParam = CRunSessionParamUtil.getLocalHome().findByPrimaryKey(new CRunSessionParamPK(session.getSession_id(), cmdParam.getParam_id()));
                if (sessionParam.getParam_value() == null || sessionParam.getParam_value().length() <= 0) continue;
                if (cmdParam.getParam_prefix() != null && cmdParam.getParam_prefix().length() > 0) {
                    argument.append(cmdParam.getParam_prefix());
                    argument.append(" ");
                }
                argument.append(sessionParam.getParam_value());
                argument.append(" ");
            }
        }
        command = cmd.getCommand_type() == 1 ? "set - " + argument.toString() + "\n" + this.readShellFile(cmd.getCommand()) : cmd.getCommand() + " " + argument.toString();
        m_log.debug((Object)("getCommand() : command=" + command));
        return command;
    }

    public String readShellFile(String fileName) throws IOException {
        m_log.debug((Object)("readShellFile() : fileName=" + fileName));
        StringBuffer filePath = new StringBuffer();
        filePath.append(fileName);
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        StringBuffer fileData = new StringBuffer();
        try {
            String lineData;
            fileInputStream = new FileInputStream(filePath.toString());
            inputStreamReader = new InputStreamReader(fileInputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((lineData = bufferedReader.readLine()) != null) {
                fileData.append(lineData);
                fileData.append("\n");
            }
        }
        catch (FileNotFoundException e) {
            AplLogger apllog = new AplLogger("CR", "cr");
            Object[] args = new String[]{fileName};
            apllog.put("SYS", "005", args);
            m_log.debug((Object)("readShellFile() : \u30b7\u30a7\u30eb\u30b9\u30af\u30ea\u30d7\u30c8\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002 : " + e.getMessage()));
            throw e;
        }
        catch (IOException e) {
            AplLogger apllog = new AplLogger("CR", "cr");
            Object[] args = new String[]{fileName};
            apllog.put("SYS", "006", args);
            m_log.debug((Object)("readShellFile() : \u30b7\u30a7\u30eb\u30b9\u30af\u30ea\u30d7\u30c8\u30d5\u30a1\u30a4\u30eb\u8aad\u307f\u8fbc\u307f\u30a8\u30e9\u30fc : " + e.getMessage()));
            throw e;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException e) {}
        }
        return fileData.toString();
    }

    public String createSession(String typeId, Property property, Locale locale) throws CreateException, FinderException, NamingException {
        Collection cmdPramList;
        m_log.debug((Object)("createSession() : typeId=" + typeId));
        RepositoryControllerLocal repository = RepositoryControllerUtil.getLocalHome().create();
        ArrayList values = null;
        values = PropertyUtil.getPropertyValue((Property)property, (String)"scope");
        String facilityId = null;
        if (values.get(0) instanceof FacilityTreeItem) {
            facilityId = ((FacilityTreeItem)values.get(0)).getData().getFacilityId();
        } else if (values.get(0) instanceof String && ((String)values.get(0)).length() > 0) {
            facilityId = (String)values.get(0);
        }
        values = PropertyUtil.getPropertyValue((Property)property, (String)"name");
        String commandId = null;
        if (values.get(0) instanceof String && ((String)values.get(0)).length() > 0) {
            String nameString = (String)values.get(0);
            commandId = this.getCommandId(typeId, nameString, locale);
        }
        CRunCmdMstLocal cmd = CRunCmdMstUtil.getLocalHome().findByPrimaryKey(commandId);
        boolean createFlg = false;
        String sessionId = null;
        Date createTime = new Date();
        CRunSessionLocal session = null;
        int i = 0;
        while (!createFlg) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                sessionId = dateFormat.format(createTime);
                DecimalFormat format = new DecimalFormat("-000");
                sessionId = sessionId + format.format(i);
                session = CRunSessionUtil.getLocalHome().create(sessionId, null, null, cmd.getType_id(), cmd.getCommand_id(), facilityId, repository.getFacilityPath(facilityId, null), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0));
                createFlg = true;
            }
            catch (DuplicateKeyException e) {
                // empty catch block
            }
            ++i;
        }
        ArrayList nodeIdList = null;
        if (repository.isNode(session.getFacility_id())) {
            nodeIdList = new ArrayList();
            nodeIdList.add(session.getFacility_id());
        } else {
            nodeIdList = repository.getNodeFacilityIdList(session.getFacility_id(), 0);
        }
        if (nodeIdList instanceof ArrayList) {
            for (int i2 = 0; i2 < nodeIdList.size(); ++i2) {
                ArrayList<String> Attribute2 = new ArrayList<String>();
                Attribute2.add("cn");
                HashMap map = repository.getNodeDetail((String)nodeIdList.get(i2), Attribute2);
                CRunSessionDetailUtil.getLocalHome().create(sessionId, (String)nodeIdList.get(i2), null, null, (String)map.get("cn"), null, null, new Integer(0), null, null);
            }
            session.setNode_cnt(new Integer(nodeIdList.size()));
            session.setWait_cnt(new Integer(nodeIdList.size()));
        }
        if ((cmdPramList = cmd.getCmdParamMst()) != null && cmdPramList.size() > 0) {
            for (CRunCmdParamMstLocal cmdParam : cmdPramList) {
                int paramType = cmdParam.getParamMst().getParam_type();
                values = PropertyUtil.getPropertyValue((Property)property, (String)cmdParam.getParam_id());
                String value = null;
                if (values.get(0) instanceof String && ((String)values.get(0)).length() > 0) {
                    value = (String)values.get(0);
                }
                if (paramType == 2) {
                    value = this.getParamSelectValue(cmdParam.getParam_id(), value, locale);
                }
                CRunSessionParamUtil.getLocalHome().create(sessionId, cmdParam.getParam_id(), value);
            }
        }
        return sessionId;
    }

    protected String getCommandId(String typeId, String name, Locale locale) throws FinderException, NamingException {
        m_log.debug((Object)("getCommandId() : typeId=" + typeId + ", name=" + name));
        String commandId = null;
        Collection cmdList = CRunCmdMstUtil.getLocalHome().findByTypeId(typeId);
        if (cmdList != null && cmdList.size() > 0) {
            for (CRunCmdMstLocal cmd : cmdList) {
                String nameValue = Messages.getString((String)cmd.getName_id(), (Locale)locale);
                if (!nameValue.equals(name)) continue;
                commandId = cmd.getCommand_id();
                break;
            }
        }
        return commandId;
    }

    protected String getParamSelectValue(String paramId, String name, Locale locale) throws FinderException, NamingException {
        m_log.debug((Object)("getParamSelectValue() : paramId=" + paramId + ", name=" + name));
        String value = null;
        Collection paramSelectList = CRunParamSelectMstUtil.getLocalHome().findByParamId(paramId);
        if (paramSelectList != null && paramSelectList.size() > 0) {
            for (CRunParamSelectMstLocal paramSelect : paramSelectList) {
                String nameValue = Messages.getString((String)paramSelect.getName_id(), (Locale)locale);
                if (!nameValue.equals(name)) continue;
                value = paramSelect.getParam_value();
                break;
            }
        }
        return value;
    }

    public void checkEndSession() throws FinderException, NamingException {
        m_log.debug((Object)"checkEndSession()");
        Collection collection = CRunSessionUtil.getLocalHome().findByStatus(new Integer(100));
        if (collection != null && collection.size() > 0) {
            for (CRunSessionLocal session : collection) {
                this.setNodeCount(session);
                if (!this.checkAllNodeEnd(session) || session.getStatus() != 100) continue;
                session.setStatus(new Integer(300));
                session.setEnd_date(new Date());
            }
        }
    }
}

