/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.components.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.internal.components.Assert;
import org.eclipse.ui.internal.components.framework.ComponentException;
import org.eclipse.ui.internal.components.framework.IServiceProvider;

public final class ServiceMap
implements IServiceProvider {
    private IServiceProvider parent = null;
    private Map overriddenInstances = null;

    public ServiceMap() {
    }

    public ServiceMap(IServiceProvider parent) {
        Assert.isNotNull(parent);
        this.parent = parent;
    }

    public Object getService(Object key) throws ComponentException {
        if (this.overriddenInstances != null && this.overriddenInstances.containsKey(key)) {
            return this.overriddenInstances.get(key);
        }
        if (this.parent != null) {
            return this.parent.getService(key);
        }
        return null;
    }

    public ServiceMap map(Object key, Object instance) {
        if (this.overriddenInstances == null) {
            this.overriddenInstances = new HashMap();
        }
        this.overriddenInstances.put(key, instance);
        return this;
    }

    public ServiceMap unmap(Object key) {
        if (this.overriddenInstances == null) {
            return this;
        }
        this.overriddenInstances.remove(key);
        if (this.overriddenInstances.isEmpty()) {
            this.overriddenInstances = null;
        }
        return this;
    }

    public boolean hasService(Object key) {
        if (this.overriddenInstances != null && this.overriddenInstances.containsKey(key)) {
            return this.overriddenInstances.get(key) != null;
        }
        if (this.parent != null) {
            return this.parent.hasService(key);
        }
        return false;
    }
}

