/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.composite;

import com.clustercontrol.jobmanagement.action.GetRunScheduleList;
import com.clustercontrol.jobmanagement.action.GetRunScheduleListTableDefine;
import com.clustercontrol.jobmanagement.composite.RunScheduleTableViewer;
import com.clustercontrol.jobmanagement.composite.action.RunScheduleSelectionChangedListener;
import com.clustercontrol.jobmanagement.composite.action.VerticalBarSelectionListener;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class RunScheduleListComposite
extends Composite {
    protected RunScheduleTableViewer m_viewer = null;
    protected Table m_table = null;
    protected Label m_labelCount = null;
    protected String m_scheduleId = null;

    public RunScheduleListComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.m_table = new Table((Composite)this, 68356);
        this.m_table.setHeaderVisible(true);
        this.m_table.setLinesVisible(true);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.m_table.setLayoutData((Object)gridData);
        this.m_labelCount = new Label((Composite)this, 131072);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.m_labelCount.setLayoutData((Object)gridData);
        this.m_viewer = new RunScheduleTableViewer(this.m_table);
        this.m_viewer.createTableColumn(GetRunScheduleListTableDefine.get(), 0, 1);
        this.m_viewer.addSelectionChangedListener(new RunScheduleSelectionChangedListener(this));
        this.m_viewer.getTable().getVerticalBar().addSelectionListener((SelectionListener)new VerticalBarSelectionListener(this));
    }

    public void update() {
        ArrayList info = null;
        GetRunScheduleList getList = new GetRunScheduleList();
        info = getList.get();
        if (info == null) {
            info = new ArrayList();
        }
        this.m_viewer.setInput(info);
        this.selectSchedule(info);
        Object[] args = new Object[]{new Integer(info.size())};
        this.m_labelCount.setText(Messages.getString((String)"records", (Object[])args));
    }

    public void selectSchedule(ArrayList info) {
        if (this.m_scheduleId != null && this.m_scheduleId.length() > 0) {
            int index = -1;
            int i = 0;
            while (i < info.size()) {
                ArrayList line = (ArrayList)info.get(i);
                String scheduleId = (String)line.get(0);
                if (this.m_scheduleId.compareTo(scheduleId) == 0) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index == -1) {
                this.m_scheduleId = null;
            } else {
                this.m_viewer.setSelection((ISelection)new StructuredSelection(info.get(index)), true);
            }
        }
    }

    public TableViewer getTableViewer() {
        return this.m_viewer;
    }

    public Table getTable() {
        return this.m_viewer.getTable();
    }

    public String getScheduleId() {
        return this.m_scheduleId;
    }

    public void setScheduleId(String scheduleId) {
        this.m_scheduleId = scheduleId;
    }
}

