/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.composite;

import com.clustercontrol.bean.FacilityPath;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.performance.bean.GraphProperty;
import com.clustercontrol.performance.composite.RecordGraphComposite;
import com.clustercontrol.performance.util.Messages;
import com.clustercontrol.performanceMGR.ejb.bmp.RecordCollectorData;
import java.util.List;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RecordGraphHolderComposite
extends Composite {
    private Label idLabel;
    private Label scopeLabel;
    private Composite baseCcomposite = null;
    private RecordGraphComposite[] composite = null;
    private String collectorID;
    private String currentPath;
    private GraphProperty[] graphPropertys;
    private RecordCollectorData collectorData;
    private List itemInfoList;
    private FacilityTreeItem facilityTree;

    public RecordGraphHolderComposite(Composite parent, int style, int maxGraphSize) {
        super(parent, style);
        this.composite = new RecordGraphComposite[maxGraphSize];
        this.initialize();
    }

    private void initialize() {
        GridData gridData1 = new GridData();
        this.idLabel = new Label((Composite)this, 0);
        this.idLabel.setLayoutData((Object)gridData1);
        GridData gridData2 = new GridData();
        this.scopeLabel = new Label((Composite)this, 0);
        this.scopeLabel.setLayoutData((Object)gridData2);
        this.baseCcomposite = new Composite((Composite)this, 0);
        this.baseCcomposite.setLayout((Layout)new FillLayout(512));
        GridData gridData3 = new GridData();
        gridData3.grabExcessVerticalSpace = true;
        gridData3.horizontalAlignment = 4;
        gridData3.verticalAlignment = 4;
        this.baseCcomposite.setLayoutData((Object)gridData3);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
    }

    public void setMasterData(RecordCollectorData collectorData, List itemInfoList, FacilityTreeItem facilityTree) {
        this.collectorData = collectorData;
        this.itemInfoList = itemInfoList;
        this.facilityTree = facilityTree;
        this.collectorID = collectorData.getCollectorID();
        if (this.graphPropertys != null) {
            int i = 0;
            while (i < this.graphPropertys.length) {
                this.disposeGraph(i);
                ++i;
            }
        }
    }

    public void redrawGraph(GraphProperty[] graphProperty) {
        this.graphPropertys = graphProperty;
        FacilityPath fp = new FacilityPath(Messages.getString("SEPARATOR"));
        this.currentPath = fp.getPath(graphProperty[0].getTargetFacility());
        this.setLabel();
        int i = 0;
        while (i < this.graphPropertys.length) {
            if (graphProperty[i].getGraphType() != 0 && (graphProperty[i].getGraphType() != 3 || graphProperty[i].getTargetFacility().getChildren().length != 0)) {
                this.getGraph(i).drawGraph(graphProperty[i]);
            }
            ++i;
        }
    }

    private RecordGraphComposite getGraph(int graphIndex) {
        if (this.composite[graphIndex] == null) {
            this.composite[graphIndex] = new RecordGraphComposite(this.baseCcomposite);
            if (this.collectorData != null) {
                this.composite[graphIndex].setMasterData(this.collectorData, this.itemInfoList, this.facilityTree);
            }
        }
        return this.composite[graphIndex];
    }

    private void disposeGraph(int graphIndex) {
        if (this.composite[graphIndex] != null) {
            this.composite[graphIndex].dispose();
            this.composite[graphIndex] = null;
        }
    }

    private void setLabel() {
        this.idLabel.setText(String.valueOf(Messages.getString("COLLECTION_ID")) + " : " + this.collectorID);
        this.scopeLabel.setText(String.valueOf(Messages.getString("SCOPE")) + " : " + this.currentPath);
    }

    public GraphProperty[] getGraphPropertys() {
        return this.graphPropertys;
    }

    public String getCollectorID() {
        return this.collectorID;
    }
}

