/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.io.File;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.ide.dialogs.ResourceEncodingFieldEditor;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.LineDelimiterEditor;

public class ResourceInfoPage
extends PropertyPage {
    private Button editableBox;
    private Button executableBox;
    private Button archiveBox;
    private Button derivedBox;
    private boolean previousReadOnlyValue;
    private boolean previousExecutableValue;
    private boolean previousArchiveValue;
    private boolean previousDerivedValue;
    private IContentDescription cachedContentDescription;
    private ResourceEncodingFieldEditor encodingEditor;
    private LineDelimiterEditor lineDelemiterEditor;
    private static String READ_ONLY = IDEWorkbenchMessages.ResourceInfo_readOnly;
    private static String EXECUTABLE = IDEWorkbenchMessages.ResourceInfo_executable;
    private static String ARCHIVE = IDEWorkbenchMessages.ResourceInfo_archive;
    private static String DERIVED = IDEWorkbenchMessages.ResourceInfo_derived;
    private static String TYPE_TITLE = IDEWorkbenchMessages.ResourceInfo_type;
    private static String LOCATION_TITLE = IDEWorkbenchMessages.ResourceInfo_location;
    private static String RESOLVED_LOCATION_TITLE = IDEWorkbenchMessages.ResourceInfo_resolvedLocation;
    private static String SIZE_TITLE = IDEWorkbenchMessages.ResourceInfo_size;
    private static String BYTES_LABEL = IDEWorkbenchMessages.ResourceInfo_bytes;
    private static String FILE_LABEL = IDEWorkbenchMessages.ResourceInfo_file;
    private static String FILE_TYPE_FORMAT = IDEWorkbenchMessages.ResourceInfo_fileTypeFormat;
    private static String FOLDER_LABEL = IDEWorkbenchMessages.ResourceInfo_folder;
    private static String PROJECT_LABEL = IDEWorkbenchMessages.ResourceInfo_project;
    private static String LINKED_FILE_LABEL = IDEWorkbenchMessages.ResourceInfo_linkedFile;
    private static String LINKED_FOLDER_LABEL = IDEWorkbenchMessages.ResourceInfo_linkedFolder;
    private static String UNKNOWN_LABEL = IDEWorkbenchMessages.ResourceInfo_unknown;
    private static String NOT_LOCAL_TEXT = IDEWorkbenchMessages.ResourceInfo_notLocal;
    private static String MISSING_PATH_VARIABLE_TEXT = IDEWorkbenchMessages.ResourceInfo_undefinedPathVariable;
    private static String NOT_EXIST_TEXT = IDEWorkbenchMessages.ResourceInfo_notExist;
    private static String PATH_TITLE = IDEWorkbenchMessages.ResourceInfo_path;
    private static String TIMESTAMP_TITLE = IDEWorkbenchMessages.ResourceInfo_lastModified;
    private static String FILE_NOT_EXIST_TEXT = IDEWorkbenchMessages.ResourceInfo_fileNotExist;
    private static String FILE_ENCODING_TITLE = IDEWorkbenchMessages.WorkbenchPreference_encoding;
    private static String CONTAINER_ENCODING_TITLE = IDEWorkbenchMessages.ResourceInfo_fileEncodingTitle;
    private static final int MAX_VALUE_WIDTH = 80;

    private Composite createBasicInfoGroup(Composite parent, IResource resource) {
        Font font = parent.getFont();
        Composite basicInfoComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        basicInfoComposite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        basicInfoComposite.setLayoutData((Object)data);
        basicInfoComposite.setFont(font);
        Label pathLabel = new Label(basicInfoComposite, 0);
        pathLabel.setText(PATH_TITLE);
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        pathLabel.setLayoutData((Object)gd);
        pathLabel.setFont(font);
        Text pathValueText = new Text(basicInfoComposite, 72);
        pathValueText.setText(resource.getFullPath().toString());
        gd = new GridData();
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        pathValueText.setLayoutData((Object)gd);
        pathValueText.setFont(font);
        pathValueText.setBackground(pathValueText.getDisplay().getSystemColor(22));
        Label typeTitle = new Label(basicInfoComposite, 16384);
        typeTitle.setText(TYPE_TITLE);
        typeTitle.setFont(font);
        Text typeValue = new Text(basicInfoComposite, 16392);
        typeValue.setText(this.getTypeString(resource));
        typeValue.setBackground(typeValue.getDisplay().getSystemColor(22));
        typeValue.setFont(font);
        Label locationTitle = new Label(basicInfoComposite, 16384);
        locationTitle.setText(LOCATION_TITLE);
        gd = new GridData();
        gd.verticalAlignment = 128;
        locationTitle.setLayoutData((Object)gd);
        locationTitle.setFont(font);
        Text locationValue = new Text(basicInfoComposite, 72);
        locationValue.setText(this.getLocationText(resource));
        gd = new GridData();
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        locationValue.setLayoutData((Object)gd);
        locationValue.setFont(font);
        locationValue.setBackground(locationValue.getDisplay().getSystemColor(22));
        if (this.isPathVariable(resource)) {
            Label resolvedLocationTitle = new Label(basicInfoComposite, 16384);
            resolvedLocationTitle.setText(RESOLVED_LOCATION_TITLE);
            gd = new GridData();
            gd.verticalAlignment = 128;
            resolvedLocationTitle.setLayoutData((Object)gd);
            resolvedLocationTitle.setFont(font);
            Text resolvedLocationValue = new Text(basicInfoComposite, 72);
            resolvedLocationValue.setText(this.getResolvedLocationText(resource));
            gd = new GridData();
            gd.widthHint = this.convertWidthInCharsToPixels(80);
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            resolvedLocationValue.setLayoutData((Object)gd);
            resolvedLocationValue.setFont(font);
            resolvedLocationValue.setBackground(resolvedLocationValue.getDisplay().getSystemColor(22));
        }
        if (resource.getType() == 1) {
            Label sizeTitle = new Label(basicInfoComposite, 16384);
            sizeTitle.setText(SIZE_TITLE);
            sizeTitle.setFont(font);
            Text sizeValue = new Text(basicInfoComposite, 16392);
            sizeValue.setText(this.getSizeString((IFile)resource));
            gd = new GridData();
            gd.widthHint = this.convertWidthInCharsToPixels(80);
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            sizeValue.setLayoutData((Object)gd);
            sizeValue.setFont(font);
            sizeValue.setBackground(sizeValue.getDisplay().getSystemColor(22));
        }
        return basicInfoComposite;
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.ide.resource_info_property_page_context");
        IResource resource = (IResource)this.getElement();
        if (resource.getType() != 4) {
            ResourceAttributes attrs = resource.getResourceAttributes();
            if (attrs != null) {
                this.previousReadOnlyValue = attrs.isReadOnly();
                this.previousExecutableValue = attrs.isExecutable();
                this.previousArchiveValue = attrs.isArchive();
            } else {
                this.previousArchiveValue = false;
                this.previousExecutableValue = false;
                this.previousReadOnlyValue = false;
            }
            this.previousDerivedValue = resource.isDerived();
        }
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        this.createBasicInfoGroup(composite, resource);
        this.createSeparator(composite);
        this.createStateGroup(composite, resource);
        new Label(composite, 0);
        this.encodingEditor = new ResourceEncodingFieldEditor(this.getFieldEditorLabel(resource), composite, resource);
        this.encodingEditor.setPage((DialogPage)this);
        this.encodingEditor.load();
        this.encodingEditor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("field_editor_is_valid")) {
                    ResourceInfoPage.this.setValid(ResourceInfoPage.this.encodingEditor.isValid());
                }
            }
        });
        if (resource.getType() == 4) {
            this.lineDelemiterEditor = new LineDelimiterEditor(composite, resource.getProject());
            this.lineDelemiterEditor.doLoad();
        }
        return composite;
    }

    private String getFieldEditorLabel(IResource resource) {
        if (resource instanceof IContainer) {
            return CONTAINER_ENCODING_TITLE;
        }
        return FILE_ENCODING_TITLE;
    }

    private void createEditableButton(Composite composite) {
        this.editableBox = new Button(composite, 131104);
        this.editableBox.setAlignment(16384);
        this.editableBox.setText(READ_ONLY);
        this.editableBox.setSelection(this.previousReadOnlyValue);
        this.editableBox.setFont(composite.getFont());
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this.editableBox.setLayoutData((Object)data);
    }

    private void createExecutableButton(Composite composite) {
        this.executableBox = new Button(composite, 131104);
        this.executableBox.setAlignment(16384);
        this.executableBox.setText(EXECUTABLE);
        this.executableBox.setSelection(this.previousExecutableValue);
        this.executableBox.setFont(composite.getFont());
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this.executableBox.setLayoutData((Object)data);
    }

    private void createArchiveButton(Composite composite) {
        this.archiveBox = new Button(composite, 131104);
        this.archiveBox.setAlignment(16384);
        this.archiveBox.setText(ARCHIVE);
        this.archiveBox.setSelection(this.previousArchiveValue);
        this.archiveBox.setFont(composite.getFont());
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this.archiveBox.setLayoutData((Object)data);
    }

    private void createDerivedButton(Composite composite) {
        this.derivedBox = new Button(composite, 131104);
        this.derivedBox.setAlignment(16384);
        this.derivedBox.setText(DERIVED);
        this.derivedBox.setSelection(this.previousDerivedValue);
        this.derivedBox.setFont(composite.getFont());
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this.derivedBox.setLayoutData((Object)data);
    }

    private void createSeparator(Composite composite) {
        Label separator = new Label(composite, 258);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)gridData);
    }

    private void createStateGroup(Composite parent, IResource resource) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        composite.setFont(font);
        Label timeStampLabel = new Label(composite, 0);
        timeStampLabel.setText(TIMESTAMP_TITLE);
        timeStampLabel.setFont(font);
        Text timeStampValue = new Text(composite, 8);
        timeStampValue.setText(this.getDateStringValue(resource));
        timeStampValue.setFont(font);
        timeStampValue.setBackground(timeStampValue.getDisplay().getSystemColor(22));
        timeStampValue.setLayoutData((Object)new GridData(768));
        if (resource.getType() != 4) {
            this.createEditableButton(composite);
            this.createExecutableButton(composite);
            this.createArchiveButton(composite);
            this.createDerivedButton(composite);
        }
    }

    private String getContentTypeString(IFile file) {
        IContentType contentType;
        IContentDescription description = this.getContentDescription(file);
        if (description != null && (contentType = description.getContentType()) != null) {
            return contentType.getName();
        }
        return null;
    }

    private IContentDescription getContentDescription(IFile file) {
        if (this.cachedContentDescription == null) {
            try {
                this.cachedContentDescription = file.getContentDescription();
            }
            catch (CoreException coreException) {}
        }
        return this.cachedContentDescription;
    }

    private String getDateStringValue(IResource resource) {
        if (!resource.isLocal(0)) {
            return NOT_LOCAL_TEXT;
        }
        IPath location = resource.getLocation();
        if (location == null) {
            if (resource.isLinked()) {
                return MISSING_PATH_VARIABLE_TEXT;
            }
            return NOT_EXIST_TEXT;
        }
        File localFile = location.toFile();
        if (localFile.exists()) {
            DateFormat format = DateFormat.getDateTimeInstance(1, 2);
            return format.format(new Date(localFile.lastModified()));
        }
        return NOT_EXIST_TEXT;
    }

    private String getLocationText(IResource resource) {
        File file;
        IPath resolvedLocation;
        if (!resource.isLocal(0)) {
            return NOT_LOCAL_TEXT;
        }
        IPath location = resolvedLocation = resource.getLocation();
        if (resource.isLinked()) {
            location = resource.getRawLocation();
        }
        if (location == null) {
            return NOT_EXIST_TEXT;
        }
        String locationString = location.toOSString();
        if (resolvedLocation != null && !this.isPathVariable(resource) && !(file = resolvedLocation.toFile()).exists()) {
            locationString = String.valueOf(locationString) + " " + FILE_NOT_EXIST_TEXT;
        }
        return locationString;
    }

    private String getResolvedLocationText(IResource resource) {
        if (!resource.isLocal(0)) {
            return NOT_LOCAL_TEXT;
        }
        IPath location = resource.getLocation();
        if (location == null) {
            if (resource.isLinked()) {
                return MISSING_PATH_VARIABLE_TEXT;
            }
            return NOT_EXIST_TEXT;
        }
        String locationString = location.toOSString();
        File file = location.toFile();
        if (!file.exists()) {
            locationString = String.valueOf(locationString) + " " + FILE_NOT_EXIST_TEXT;
        }
        return locationString;
    }

    private String getSizeString(IFile file) {
        if (!file.isLocal(0)) {
            return NOT_LOCAL_TEXT;
        }
        IPath location = file.getLocation();
        if (location == null) {
            if (file.isLinked()) {
                return MISSING_PATH_VARIABLE_TEXT;
            }
            return NOT_EXIST_TEXT;
        }
        File localFile = location.toFile();
        if (localFile.exists()) {
            String bytesString = Long.toString(localFile.length());
            return MessageFormat.format(BYTES_LABEL, bytesString);
        }
        return NOT_EXIST_TEXT;
    }

    private String getTypeString(IResource resource) {
        if (resource.getType() == 1) {
            String contentType;
            if (resource.isLinked()) {
                return LINKED_FILE_LABEL;
            }
            if (resource instanceof IFile && (contentType = this.getContentTypeString((IFile)resource)) != null) {
                return MessageFormat.format(FILE_TYPE_FORMAT, contentType);
            }
            return FILE_LABEL;
        }
        if (resource.getType() == 2) {
            if (resource.isLinked()) {
                return LINKED_FOLDER_LABEL;
            }
            return FOLDER_LABEL;
        }
        if (resource.getType() == 4) {
            return PROJECT_LABEL;
        }
        return UNKNOWN_LABEL;
    }

    private boolean isPathVariable(IResource resource) {
        if (!resource.isLinked()) {
            return false;
        }
        IPath resolvedLocation = resource.getLocation();
        if (resolvedLocation == null) {
            return true;
        }
        IPath rawLocation = resource.getRawLocation();
        return !resolvedLocation.equals((Object)rawLocation);
    }

    protected void performDefaults() {
        if (this.editableBox != null) {
            this.editableBox.setSelection(false);
        }
        if (this.executableBox != null) {
            this.executableBox.setSelection(false);
        }
        if (this.derivedBox != null) {
            this.derivedBox.setSelection(false);
        }
        this.encodingEditor.loadDefault();
        if (this.lineDelemiterEditor != null) {
            this.lineDelemiterEditor.loadDefault();
        }
    }

    public boolean performOk() {
        IResource resource = (IResource)this.getElement();
        this.encodingEditor.store();
        if (this.lineDelemiterEditor != null) {
            this.lineDelemiterEditor.store();
        }
        try {
            boolean localDerivedValue;
            if (this.editableBox != null && this.executableBox != null && this.archiveBox != null) {
                boolean localReadOnlyValue = this.editableBox.getSelection();
                boolean localExecutableValue = this.executableBox.getSelection();
                boolean localArchiveValue = this.archiveBox.getSelection();
                ResourceAttributes attrs = resource.getResourceAttributes();
                if (attrs != null) {
                    attrs.setExecutable(localExecutableValue);
                    attrs.setReadOnly(localReadOnlyValue);
                    attrs.setArchive(localArchiveValue);
                    if (this.previousReadOnlyValue != localReadOnlyValue || this.previousExecutableValue != localExecutableValue || this.previousArchiveValue != localArchiveValue) {
                        resource.setResourceAttributes(attrs);
                        attrs = resource.getResourceAttributes();
                        if (attrs != null) {
                            this.previousReadOnlyValue = attrs.isReadOnly();
                            this.previousExecutableValue = attrs.isExecutable();
                            this.previousArchiveValue = attrs.isArchive();
                            this.editableBox.setSelection(attrs.isReadOnly());
                            this.executableBox.setSelection(attrs.isExecutable());
                            this.archiveBox.setSelection(attrs.isArchive());
                        }
                    }
                }
            }
            if (this.derivedBox != null && this.previousDerivedValue != (localDerivedValue = this.derivedBox.getSelection())) {
                boolean isDerived;
                resource.setDerived(localDerivedValue);
                this.previousDerivedValue = isDerived = resource.isDerived();
                this.derivedBox.setSelection(isDerived);
            }
        }
        catch (CoreException exception) {
            ErrorDialog.openError((Shell)this.getShell(), (String)IDEWorkbenchMessages.InternalError, (String)exception.getLocalizedMessage(), (IStatus)exception.getStatus());
            return false;
        }
        return true;
    }
}

