/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.marshal;

import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.marshal.MarshallLoaderFactory;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.MarshallerLoaderClient;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.marshal.http.HTTPMarshaller;
import org.jboss.remoting.marshal.http.HTTPUnMarshaller;
import org.jboss.remoting.marshal.rmi.RMIMarshaller;
import org.jboss.remoting.marshal.rmi.RMIUnMarshaller;
import org.jboss.remoting.marshal.serializable.SerializableMarshaller;
import org.jboss.remoting.marshal.serializable.SerializableUnMarshaller;

public class MarshalFactory {
    private static Map marshallers = new HashMap();
    private static Map unmarshallers = new HashMap();
    private static Map classMarshallers = new HashMap();
    private static Map classUnmarshallers = new HashMap();
    protected static final Logger log = Logger.getLogger(class$org$jboss$remoting$marshal$MarshalFactory == null ? (class$org$jboss$remoting$marshal$MarshalFactory = MarshalFactory.class$("org.jboss.remoting.marshal.MarshalFactory")) : class$org$jboss$remoting$marshal$MarshalFactory);
    static /* synthetic */ Class class$org$jboss$remoting$marshal$MarshalFactory;

    public static void addMarshaller(Class classType, Marshaller marshaller, UnMarshaller unMarshaller) {
        classMarshallers.put(classType, marshaller);
        classUnmarshallers.put(classType, unMarshaller);
    }

    public static void addMarshaller(String dataType, Marshaller marshaller, UnMarshaller unMarshaller) {
        marshallers.put(dataType, marshaller);
        unmarshallers.put(dataType, unMarshaller);
    }

    public static Marshaller getMarshaller(Class classType) {
        Marshaller marshaller = null;
        Object obj = classMarshallers.get(classType);
        if (obj != null && obj instanceof Marshaller) {
            marshaller = (Marshaller)obj;
            try {
                marshaller = marshaller.cloneMarshaller();
            }
            catch (CloneNotSupportedException e) {
                log.warn("Could not clone " + marshaller);
            }
        } else {
            log.warn("Could not find marshaller for class type '" + classType + "'.  Object in collection is " + obj);
        }
        return marshaller;
    }

    public static UnMarshaller getUnMarshaller(Class classType) {
        UnMarshaller unmarshaller = null;
        Object obj = classUnmarshallers.get(classType);
        if (obj != null && obj instanceof UnMarshaller) {
            unmarshaller = (UnMarshaller)obj;
            try {
                unmarshaller = unmarshaller.cloneUnMarshaller();
            }
            catch (CloneNotSupportedException e) {
                log.warn("Could not clone " + unmarshaller);
            }
        } else {
            log.warn("Could not find unmarshaller for class type '" + classType + "'.  Object in collection is " + obj);
        }
        return unmarshaller;
    }

    public static Marshaller getMarshaller(String dataType) {
        Marshaller marshaller = null;
        Object obj = marshallers.get(dataType);
        if (obj != null && obj instanceof Marshaller) {
            marshaller = (Marshaller)obj;
            try {
                marshaller = marshaller.cloneMarshaller();
            }
            catch (CloneNotSupportedException e) {
                log.warn("Could not clone " + marshaller);
            }
        } else {
            log.warn("Could not find marshaller for data type '" + dataType + "'.  Object in collection is " + obj);
        }
        return marshaller;
    }

    public static UnMarshaller getUnMarshaller(String dataType) {
        UnMarshaller unmarshaller = null;
        Object obj = unmarshallers.get(dataType);
        if (obj != null && obj instanceof UnMarshaller) {
            unmarshaller = (UnMarshaller)obj;
            try {
                unmarshaller = unmarshaller.cloneUnMarshaller();
            }
            catch (CloneNotSupportedException e) {
                log.warn("Could not clone " + unmarshaller);
            }
        } else {
            log.warn("Could not find unmarshaller for data type '" + dataType + "'.  Object in collection is " + obj);
        }
        return unmarshaller;
    }

    public static Marshaller getMarshaller(InvokerLocator locator, ClassLoader classLoader) {
        Map params;
        Marshaller marshaller = null;
        if (locator != null && (params = locator.getParameters()) != null) {
            InvokerLocator loaderLocator;
            String dataType = (String)params.get("datatype");
            if (dataType == null) {
                dataType = (String)params.get("dataType");
            }
            if (dataType != null) {
                marshaller = MarshalFactory.getMarshaller(dataType);
            }
            if (marshaller == null) {
                log.debug("Could not find data type to lookup by marshaller class");
                String marshallerFQN = (String)params.get("marshaller");
                marshaller = MarshalFactory.loadMarshaller(marshallerFQN);
                if (marshaller != null) {
                    log.debug("Found marshaller by loading locally.");
                    String unmarshallerFQN = (String)params.get("unmarshaller");
                    UnMarshaller unmarshaller = MarshalFactory.loadUnMarshaller(unmarshallerFQN);
                    if (unmarshaller != null) {
                        MarshalFactory.addMarshaller(dataType, marshaller, unmarshaller);
                    }
                }
            }
            if (marshaller == null) {
                log.debug("Tried to find marshaller from locator by both data type and class name but was unsuccessful.  Will try to load it from remote server.");
            }
            if (marshaller == null && dataType != null && (loaderLocator = MarshallLoaderFactory.convertLocator(locator)) != null) {
                marshaller = MarshallerLoaderClient.getMarshaller(loaderLocator, dataType, classLoader);
                UnMarshaller unmarshaller = MarshallerLoaderClient.getUnMarshaller(loaderLocator, dataType, classLoader);
                if (unmarshaller != null) {
                    unmarshaller.setClassLoader(classLoader);
                }
                log.debug("Remotely loaded marshaller: " + marshaller);
                log.debug("Remotely loaded unmarshaller: " + unmarshaller);
                if (marshaller != null && unmarshaller != null) {
                    MarshalFactory.addMarshaller(dataType, marshaller, unmarshaller);
                }
            }
        }
        if (marshaller != null) {
            try {
                marshaller = marshaller.cloneMarshaller();
            }
            catch (CloneNotSupportedException e) {
                log.warn("Could not clone " + marshaller);
            }
        }
        return marshaller;
    }

    private static Marshaller loadMarshaller(String marshallerFQN) {
        Marshaller marshaller = null;
        if (marshallerFQN != null) {
            try {
                Class<?> marshallerClass = Class.forName(marshallerFQN);
                marshaller = (Marshaller)marshallerClass.newInstance();
            }
            catch (Exception e) {
                log.warn("Found marshaller fully qualified class name within locator parameters, but was unable to load class: " + marshallerFQN);
            }
        }
        return marshaller;
    }

    public static UnMarshaller getUnMarshaller(InvokerLocator locator, ClassLoader classLoader) {
        Map params;
        UnMarshaller unmarshaller = null;
        if (locator != null && (params = locator.getParameters()) != null) {
            String dataType = (String)params.get("datatype");
            if (dataType != null) {
                unmarshaller = MarshalFactory.getUnMarshaller(dataType);
            }
            if (unmarshaller == null) {
                String marshallerFQN;
                Marshaller marshaller;
                log.debug("Could not find data type to lookup by unmarshaller class");
                String unmarshallerFQN = (String)params.get("unmarshaller");
                unmarshaller = MarshalFactory.loadUnMarshaller(unmarshallerFQN);
                if (unmarshaller != null && (marshaller = MarshalFactory.loadMarshaller(marshallerFQN = (String)params.get("marshaller"))) != null) {
                    MarshalFactory.addMarshaller(dataType, marshaller, unmarshaller);
                }
            }
            if (log.isTraceEnabled() && unmarshaller == null) {
                log.trace("Tried to find unmarshaller from locator by both data type and class name but was unsuccessful.");
            }
            if (unmarshaller == null && dataType != null) {
                InvokerLocator loaderLocator = MarshallLoaderFactory.convertLocator(locator);
                unmarshaller = MarshallerLoaderClient.getUnMarshaller(loaderLocator, dataType, classLoader);
                if (unmarshaller != null) {
                    unmarshaller.setClassLoader(classLoader);
                }
                Marshaller marshaller = MarshallerLoaderClient.getMarshaller(loaderLocator, dataType, classLoader);
                if (log.isTraceEnabled()) {
                    log.trace("Remotely loaded marshaller: " + marshaller);
                    log.trace("Remotely loaded unmarshaller: " + unmarshaller);
                }
                if (marshaller != null && unmarshaller != null) {
                    MarshalFactory.addMarshaller(dataType, marshaller, unmarshaller);
                }
            }
        }
        if (unmarshaller != null) {
            try {
                unmarshaller = unmarshaller.cloneUnMarshaller();
            }
            catch (CloneNotSupportedException e) {
                log.warn("Could not clone " + unmarshaller);
            }
        }
        return unmarshaller;
    }

    private static UnMarshaller loadUnMarshaller(String unmarshallerFQN) {
        UnMarshaller unmarshaller = null;
        if (unmarshallerFQN != null) {
            try {
                Class<?> unmarshallerClass = Class.forName(unmarshallerFQN);
                unmarshaller = (UnMarshaller)unmarshallerClass.newInstance();
            }
            catch (Exception e) {
                log.error("Found unmarshaller fully qualified class name within locator parameters, but was unable to load class: " + unmarshallerFQN, e);
            }
        }
        return unmarshaller;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            marshallers.put("serializable", new SerializableMarshaller());
            unmarshallers.put("serializable", new SerializableUnMarshaller());
            marshallers.put("http", new HTTPMarshaller());
            unmarshallers.put("http", new HTTPUnMarshaller());
            marshallers.put("rmi", new RMIMarshaller());
            unmarshallers.put("rmi", new RMIUnMarshaller());
        }
        catch (Exception e) {
            log.error("Could not statically load default marshallers.", e);
        }
    }
}

