/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmp.dialog;

import com.clustercontrol.bean.ConvertValueConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.composite.StringVerifyListener;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.bean.MonitorCheckInfo;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.composite.MonitorBasicScopeComposite;
import com.clustercontrol.monitor.run.composite.MonitorBlockComposite;
import com.clustercontrol.monitor.run.composite.MonitorRuleComposite;
import com.clustercontrol.monitor.run.composite.NumericRunJobComposite;
import com.clustercontrol.monitor.run.composite.NumericValueInfoComposite;
import com.clustercontrol.monitor.run.composite.StringValueInfoComposite;
import com.clustercontrol.notify.composite.NotifyInfoComposite;
import com.clustercontrol.snmp.action.AddSnmp;
import com.clustercontrol.snmp.action.GetSnmp;
import com.clustercontrol.snmp.action.GetSnmpStringValueListTableDefine;
import com.clustercontrol.snmp.action.ModifySnmp;
import com.clustercontrol.snmp.bean.MonitorSnmpInfo;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SnmpCreateDialog
extends CommonDialog {
    public static final int WIDTH_TITLE = 5;
    public static final int WIDTH_VALUE = 2;
    private MonitorInfo inputData = null;
    private ValidateResult validateResult = null;
    private String monitorId = null;
    MonitorBasicScopeComposite m_monitorBasic = null;
    private MonitorRuleComposite m_monitorRule = null;
    private Text m_textCommunityName = null;
    private Text m_textOid = null;
    private Combo m_comboConvertValue = null;
    private MonitorBlockComposite m_monitorBlock = null;
    private NumericValueInfoComposite m_numericValueInfo = null;
    private StringValueInfoComposite m_stringValueInfo = null;
    private NotifyInfoComposite m_notifyInfo = null;
    private Button m_checkJobRun = null;
    private NumericRunJobComposite m_jobRun = null;
    private Button confirmValid = null;
    private int m_monitorType;

    public SnmpCreateDialog(Shell parent) {
        super(parent);
    }

    public SnmpCreateDialog(Shell parent, int monitorType) {
        super(parent);
        this.m_monitorType = monitorType;
    }

    public SnmpCreateDialog(Shell parent, String monitorId, int monitorType) {
        super(parent);
        this.monitorId = monitorId;
        this.m_monitorType = monitorType;
    }

    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString((String)"dialog.snmp.create.modify"));
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        parent.setLayout((Layout)layout);
        this.m_monitorBasic = new MonitorBasicScopeComposite(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_monitorBasic.setLayoutData((Object)gridData);
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"monitor.rule")) + " : ");
        Group groupRule = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        groupRule.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupRule.setLayoutData((Object)gridData);
        this.m_monitorRule = new MonitorRuleComposite((Composite)groupRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_monitorRule.setLayoutData((Object)gridData);
        label = new Label((Composite)groupRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"check.rule")) + " : ");
        Group groupCheckRule = new Group((Composite)groupRule, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupCheckRule.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupCheckRule.setLayoutData((Object)gridData);
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"community.name")) + " : ");
        this.m_textCommunityName = new Text((Composite)groupCheckRule, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textCommunityName.setLayoutData((Object)gridData);
        this.m_textCommunityName.addVerifyListener((VerifyListener)new StringVerifyListener(64));
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"oid")) + " : ");
        this.m_textOid = new Text((Composite)groupCheckRule, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textOid.setLayoutData((Object)gridData);
        this.m_textOid.addVerifyListener((VerifyListener)new StringVerifyListener(64));
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        if (this.m_monitorType == 1) {
            label = new Label((Composite)groupCheckRule, 0);
            gridData = new GridData();
            gridData.horizontalSpan = 5;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            label.setLayoutData((Object)gridData);
            label.setText(String.valueOf(Messages.getString((String)"convert.value")) + " : ");
            this.m_comboConvertValue = new Combo((Composite)groupCheckRule, 12);
            gridData = new GridData();
            gridData.horizontalSpan = 4;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            this.m_comboConvertValue.setLayoutData((Object)gridData);
            this.m_comboConvertValue.add(ConvertValueConstant.STRING_NO);
            this.m_comboConvertValue.add(ConvertValueConstant.STRING_DELTA);
            label = new Label((Composite)groupCheckRule, 0);
            gridData = new GridData();
            gridData.horizontalSpan = 6;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            label.setLayoutData((Object)gridData);
            label = new Label(parent, 0);
            gridData = new GridData();
            gridData.horizontalSpan = 15;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            label.setLayoutData((Object)gridData);
            label.setText(String.valueOf(Messages.getString((String)"monitor.block")) + " : ");
            Group groupMonitorBlock = new Group(parent, 0);
            layout = new GridLayout(1, true);
            layout.marginWidth = 5;
            layout.marginHeight = 5;
            layout.numColumns = 1;
            groupMonitorBlock.setLayout((Layout)layout);
            gridData = new GridData();
            gridData.horizontalSpan = 15;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            groupMonitorBlock.setLayoutData((Object)gridData);
            this.m_monitorBlock = new MonitorBlockComposite((Composite)groupMonitorBlock, 0);
            gridData = new GridData();
            gridData.horizontalSpan = 15;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            this.m_monitorBlock.setLayoutData((Object)gridData);
            label = new Label(parent, 0);
            gridData = new GridData();
            gridData.horizontalSpan = 15;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            label.setLayoutData((Object)gridData);
            label.setText(String.valueOf(Messages.getString((String)"def.result.node")) + " : ");
            Group groupDefResultNode = new Group(parent, 0);
            layout = new GridLayout(1, true);
            layout.marginWidth = 5;
            layout.marginHeight = 5;
            layout.numColumns = 1;
            groupDefResultNode.setLayout((Layout)layout);
            gridData = new GridData();
            gridData.horizontalSpan = 15;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            groupDefResultNode.setLayoutData((Object)gridData);
            this.m_numericValueInfo = new NumericValueInfoComposite((Composite)groupDefResultNode, 0, true, Messages.getString((String)"threshold.lower.limit"), Messages.getString((String)"threshold.upper.limit"), 1);
            this.m_numericValueInfo.setInputRange1(-1.0E308, 1.0E308);
            this.m_numericValueInfo.setInputRange2(-1.0E308, 1.0E308);
            gridData = new GridData();
            gridData.horizontalSpan = 15;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            this.m_numericValueInfo.setLayoutData((Object)gridData);
        }
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"notify.attribute")) + " : ");
        Group groupNotifyAttribute = new Group(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        groupNotifyAttribute.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupNotifyAttribute.setLayoutData((Object)gridData);
        if (this.m_monitorType == 1) {
            this.m_notifyInfo = new NotifyInfoComposite((Composite)groupNotifyAttribute, 0);
        } else if (this.m_monitorType == 2) {
            this.m_notifyInfo = new NotifyInfoComposite((Composite)groupNotifyAttribute, 0, Messages.getString((String)"notify.id.default"));
        }
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_notifyInfo.setLayoutData((Object)gridData);
        if (this.m_monitorType == 1) {
            this.m_checkJobRun = new Button((Composite)groupNotifyAttribute, 32);
            gridData = new GridData();
            gridData.horizontalSpan = 1;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            this.m_checkJobRun.setLayoutData((Object)gridData);
            this.m_checkJobRun.setText(String.valueOf(Messages.getString((String)"run")) + " : ");
            this.m_checkJobRun.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SnmpCreateDialog.this.m_jobRun.setEnabled(SnmpCreateDialog.this.m_checkJobRun.getSelection());
                }
            });
            Group groupRunJob = new Group((Composite)groupNotifyAttribute, 0);
            layout = new GridLayout(1, true);
            layout.marginWidth = 5;
            layout.marginHeight = 5;
            layout.numColumns = 1;
            groupRunJob.setLayout((Layout)layout);
            gridData = new GridData();
            gridData.horizontalSpan = 15;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            groupRunJob.setLayoutData((Object)gridData);
            this.m_jobRun = new NumericRunJobComposite((Composite)groupRunJob, 0);
            gridData = new GridData();
            gridData.horizontalSpan = 1;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            this.m_jobRun.setLayoutData((Object)gridData);
        } else if (this.m_monitorType == 2) {
            label = new Label(parent, 0);
            gridData = new GridData();
            gridData.horizontalSpan = 15;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            label.setLayoutData((Object)gridData);
            label.setText(String.valueOf(Messages.getString((String)"def.result.node")) + " : ");
            Group groupDefResult = new Group(parent, 0);
            layout = new GridLayout(1, true);
            layout.marginWidth = 5;
            layout.marginHeight = 5;
            layout.numColumns = 1;
            groupDefResult.setLayout((Layout)layout);
            gridData = new GridData();
            gridData.horizontalSpan = 15;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            groupDefResult.setLayoutData((Object)gridData);
            ArrayList tableDefine = GetSnmpStringValueListTableDefine.get();
            this.m_stringValueInfo = new StringValueInfoComposite((Composite)groupDefResult, 0, tableDefine);
            gridData = new GridData();
            gridData.horizontalSpan = 1;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            this.m_stringValueInfo.setLayoutData((Object)gridData);
        }
        this.confirmValid = new Button(parent, 32);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.confirmValid.setLayoutData((Object)gridData);
        this.confirmValid.setText(Messages.getString((String)"setting.valid.confirmed"));
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 15;
        line.setLayoutData((Object)gridData);
        shell.pack();
        shell.setSize(new Point(550, shell.getSize().y));
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
        MonitorInfo info = null;
        info = this.monitorId == null ? new MonitorInfo() : new GetSnmp().getSnmp(this.monitorId, this.m_monitorType);
        this.setInputData(info);
    }

    public MonitorInfo getInputData() {
        return this.inputData;
    }

    protected void setInputData(MonitorInfo monitor) {
        MonitorSnmpInfo snmpInfo;
        this.m_monitorBasic.setInputData(monitor);
        this.m_monitorRule.setInputData(monitor);
        if (this.m_monitorType == 1) {
            this.m_monitorBlock.setInputData(monitor);
        }
        if ((snmpInfo = (MonitorSnmpInfo)monitor.getCheckInfo()) == null) {
            snmpInfo = new MonitorSnmpInfo();
        }
        if (snmpInfo != null) {
            if (snmpInfo.getCommunityName() != null) {
                this.m_textCommunityName.setText(snmpInfo.getCommunityName());
            }
            if (snmpInfo.getSnmpOid() != null) {
                this.m_textOid.setText(snmpInfo.getSnmpOid());
            }
            if (this.m_monitorType == 1 && snmpInfo.getConvertFlg() != null) {
                this.m_comboConvertValue.setText(ConvertValueConstant.typeToString((int)snmpInfo.getConvertFlg()));
            }
        }
        if (monitor.getNotifyId() != null) {
            this.m_notifyInfo.setText(monitor.getNotifyId());
        }
        if (monitor.getApplication() != null) {
            this.m_notifyInfo.setApplication(monitor.getApplication());
        }
        if (this.m_monitorType == 1) {
            this.m_numericValueInfo.setInputData(monitor);
            this.m_checkJobRun.setSelection(YesNoConstant.typeToBoolean((int)monitor.getJobRun()));
            this.m_jobRun.setInputData(monitor);
            this.m_jobRun.setEnabled(YesNoConstant.typeToBoolean((int)monitor.getJobRun()));
        } else if (this.m_monitorType == 2) {
            this.m_stringValueInfo.setInputData(monitor);
        }
        if (monitor.getValid() == 1) {
            this.confirmValid.setSelection(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected MonitorInfo createInputData() {
        MonitorSnmpInfo snmpInfo;
        MonitorInfo info;
        block21: {
            block25: {
                block26: {
                    block23: {
                        block24: {
                            block22: {
                                info = new MonitorInfo();
                                info.setMonitorTypeId("SNMP");
                                info.setMonitorType(this.m_monitorType);
                                this.validateResult = this.m_monitorBasic.createInputData(info);
                                if (this.validateResult != null) {
                                    return null;
                                }
                                this.validateResult = this.m_monitorRule.createInputData(info);
                                if (this.validateResult != null) {
                                    return null;
                                }
                                if (this.m_monitorType == 1) {
                                    this.validateResult = this.m_monitorBlock.createInputData(info);
                                    if (this.validateResult != null) {
                                        return null;
                                    }
                                } else if (this.m_monitorType == 2) {
                                    info.setMonitorBlock(0);
                                }
                                snmpInfo = new MonitorSnmpInfo();
                                snmpInfo.setMonitorTypeId("SNMP");
                                snmpInfo.setMonitorId(info.getMonitorId());
                                if (this.m_textCommunityName.getText() == null || "".equals(this.m_textCommunityName.getText().trim())) break block22;
                                snmpInfo.setCommunityName(this.m_textCommunityName.getText());
                                if (this.m_textOid.getText() == null) break block23;
                                break block24;
                            }
                            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.snmp.1"));
                            return null;
                        }
                        if ("".equals(this.m_textOid.getText().trim())) break block23;
                        snmpInfo.setSnmpOid(this.m_textOid.getText());
                        if (this.m_monitorType != 1) break block25;
                        break block26;
                    }
                    this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.snmp.2"));
                    return null;
                }
                if (this.m_comboConvertValue.getText() != null && !"".equals(this.m_comboConvertValue.getText().trim())) {
                    snmpInfo.setConvertFlg(Integer.valueOf(ConvertValueConstant.stringToType((String)this.m_comboConvertValue.getText())));
                    break block21;
                } else {
                    this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.snmp.3"));
                    return null;
                }
            }
            if (this.m_monitorType == 2) {
                snmpInfo.setConvertFlg(Integer.valueOf(-1));
            }
        }
        info.setCheckInfo((MonitorCheckInfo)snmpInfo);
        if (this.m_notifyInfo.getText() != null && !"".equals(this.m_notifyInfo.getText().trim())) {
            info.setNotifyId(this.m_notifyInfo.getText());
        }
        if (this.m_notifyInfo.getApplication() != null && !"".equals(this.m_notifyInfo.getApplication().trim())) {
            info.setApplication(this.m_notifyInfo.getApplication());
        } else if (this.m_notifyInfo.getText() != null && !"".equals(this.m_notifyInfo.getText().trim())) {
            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.10"));
            return null;
        }
        if (this.m_monitorType == 1) {
            this.validateResult = this.m_numericValueInfo.createInputData(info);
            if (this.validateResult != null) {
                return null;
            }
            info.setJobRun(YesNoConstant.booleanToType((boolean)this.m_checkJobRun.getSelection()));
            this.validateResult = this.m_jobRun.createInputData(info);
            if (this.validateResult != null) {
                return null;
            }
        } else if (this.m_monitorType == 2) {
            this.validateResult = this.m_stringValueInfo.createInputData(info);
            if (this.validateResult != null) {
                return null;
            }
            if (this.m_stringValueInfo.isNotify() && (this.m_notifyInfo.getApplication() == null || "".equals(this.m_notifyInfo.getApplication().trim()))) {
                this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.10"));
                return null;
            }
            info.setJobRun(1);
        }
        if (this.confirmValid.getSelection()) {
            info.setValid(1);
            return info;
        }
        info.setValid(0);
        return info;
    }

    protected ValidateResult validate() {
        this.inputData = this.createInputData();
        if (this.inputData != null) {
            return super.validate();
        }
        return this.validateResult;
    }

    protected boolean action() {
        boolean result = false;
        MonitorInfo info = this.inputData;
        if (info != null) {
            result = this.monitorId == null ? new AddSnmp().add(info) : new ModifySnmp().modify(info);
        }
        return result;
    }

    protected String getOkButtonText() {
        return Messages.getString((String)"ok");
    }

    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }

    private void setValidateResult(String id, String message) {
        this.validateResult = new ValidateResult();
        this.validateResult.setValid(false);
        this.validateResult.setID(id);
        this.validateResult.setMessage(message);
    }
}

