/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AllPermission;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.osgi.framework.adaptor.PermissionStorage;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleCombinedPermissions;
import org.eclipse.osgi.framework.internal.core.BundlePermissionCollection;
import org.eclipse.osgi.framework.internal.core.ConditionalPermissionInfoImpl;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.osgi.service.condpermadmin.ConditionInfo;
import org.osgi.service.condpermadmin.ConditionalPermissionAdmin;
import org.osgi.service.condpermadmin.ConditionalPermissionInfo;
import org.osgi.service.permissionadmin.PermissionInfo;

public class ConditionalPermissionAdminImpl
implements ConditionalPermissionAdmin {
    Vector condPerms;
    Framework framework;
    PermissionStorage storage;
    private long nextID = System.currentTimeMillis();
    static /* synthetic */ Class class$0;

    public ConditionalPermissionAdminImpl(Framework framework, PermissionStorage permissionStorage) {
        ConditionalPermissionInfoImpl.setConditionalPermissionAdminImpl(this);
        this.framework = framework;
        this.storage = permissionStorage;
        try {
            this.condPerms = permissionStorage.deserializeConditionalPermissionInfos();
        }
        catch (IOException e) {
            framework.publishFrameworkEvent(2, framework.systemBundle, e);
            this.condPerms = new Vector();
        }
    }

    public ConditionalPermissionInfo addConditionalPermissionInfo(ConditionInfo[] conds, PermissionInfo[] perms) {
        return this.setConditionalPermissionInfo(null, conds, perms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConditionalPermissionInfo setConditionalPermissionInfo(String name, ConditionInfo[] conds, PermissionInfo[] perms) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AllPermission());
        }
        if (name == null) {
            name = "generated_" + Long.toString(this.nextID++);
        }
        ConditionalPermissionInfoImpl condPermInfo = null;
        Vector vector = this.condPerms;
        synchronized (vector) {
            condPermInfo = (ConditionalPermissionInfoImpl)this.getConditionalPermissionInfo(name);
            if (condPermInfo == null) {
                condPermInfo = new ConditionalPermissionInfoImpl(name, conds, perms);
                this.condPerms.add(condPermInfo);
            } else {
                condPermInfo.conds = conds;
                condPermInfo.perms = perms;
            }
            this.saveCondPermInfos();
        }
        AbstractBundle[] bundles = this.framework.getAllBundles();
        int i = 0;
        while (i < bundles.length) {
            AbstractBundle bundle = bundles[i];
            if (bundle.domain != null) {
                BundleCombinedPermissions bcp = (BundleCombinedPermissions)bundle.domain.getPermissions();
                if (perms != null) {
                    bcp.checkConditionalPermissionInfo(condPermInfo);
                }
            }
            ++i;
        }
        return condPermInfo;
    }

    public ConditionalPermissionInfo getConditionalPermissionInfo(String name) {
        Enumeration eCondPerms = this.condPerms.elements();
        while (eCondPerms.hasMoreElements()) {
            ConditionalPermissionInfoImpl condPerm = (ConditionalPermissionInfoImpl)eCondPerms.nextElement();
            if (!name.equals(condPerm.getName())) continue;
            return condPerm;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getConditionalPermissionInfos() {
        Vector vector = this.condPerms;
        synchronized (vector) {
            return this.condPerms.elements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteConditionalPermissionInfo(ConditionalPermissionInfo cpi) {
        Vector vector = this.condPerms;
        synchronized (vector) {
            this.condPerms.remove(cpi);
            this.saveCondPermInfos();
        }
    }

    private void saveCondPermInfos() {
        try {
            this.storage.serializeConditionalPermissionInfos(this.condPerms);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, e);
        }
    }

    public AccessControlContext getAccessControlContext(String[] signers) {
        ProtectionDomain[] protectionDomainArray;
        BundlePermissionCollection collection;
        Enumeration infos = this.getConditionalPermissionInfos();
        ArrayList<PermissionInfo> permissionInfos = new ArrayList<PermissionInfo>();
        if (infos != null) {
            while (infos.hasMoreElements()) {
                ConditionalPermissionInfoImpl condPermInfo = (ConditionalPermissionInfoImpl)infos.nextElement();
                ConditionInfo[] condInfo = condPermInfo.getConditionInfos();
                boolean match = true;
                int i = 0;
                while (i < condInfo.length) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.osgi.service.condpermadmin.BundleSignerCondition");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (!clazz.getName().equals(condInfo[i].getType())) {
                        match = false;
                        break;
                    }
                    String[] args = condInfo[i].getArgs();
                    int j = 0;
                    while (j < args.length) {
                        if (!this.framework.adaptor.matchDNChain(args[j], signers)) {
                            match = false;
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (!match) continue;
                PermissionInfo[] addPermInfos = condPermInfo.getPermissionInfos();
                int i2 = 0;
                while (i2 < addPermInfos.length) {
                    permissionInfos.add(addPermInfos[i2]);
                    ++i2;
                }
            }
        }
        if ((collection = this.framework.permissionAdmin.createPermissions(permissionInfos.toArray(new PermissionInfo[permissionInfos.size()]), null)) == null) {
            protectionDomainArray = new ProtectionDomain[]{};
        } else {
            ProtectionDomain[] protectionDomainArray2 = new ProtectionDomain[1];
            protectionDomainArray = protectionDomainArray2;
            protectionDomainArray2[0] = new ProtectionDomain(null, collection);
        }
        return new AccessControlContext(protectionDomainArray);
    }
}

